/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.services;

import com.aelitis.net.upnp.UPnPAction;
import com.aelitis.net.upnp.UPnPActionArgument;
import com.aelitis.net.upnp.UPnPActionInvocation;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.impl.UPnPImpl;
import com.aelitis.net.upnp.impl.device.UPnPRootDeviceImpl;
import com.aelitis.net.upnp.impl.services.UPnPServiceImpl;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import com.aelitis.net.upnp.services.UPnPWANConnectionListener;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public abstract class UPnPSSWANConnectionImpl
implements UPnPWANConnection {
    private static AEMonitor class_mon = new AEMonitor("UPnPSSWANConnection");
    private static List services = new ArrayList();
    private UPnPServiceImpl service;
    private List mappings = new ArrayList();
    private List listeners = new ArrayList();
    private boolean recheck_mappings = true;
    private boolean last_mapping_check_failed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UPnPSSWANConnectionImpl(UPnPServiceImpl uPnPServiceImpl) {
        this.service = uPnPServiceImpl;
        try {
            class_mon.enter();
            services.add(this);
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public int getCapabilities() {
        String string = this.service.getDevice().getRootDevice().getDevice().getFriendlyName();
        int n = -1;
        if (string.equals("WRT54G")) {
            n = -2;
        }
        return n;
    }

    @Override
    public UPnPService getGenericService() {
        return this.service;
    }

    @Override
    public String[] getStatusInfo() throws UPnPException {
        UPnPAction uPnPAction = this.service.getAction("GetStatusInfo");
        if (uPnPAction == null) {
            this.log("Action 'GetStatusInfo' not supported, binding not established");
            throw new UPnPException("GetStatusInfo not supported");
        }
        UPnPActionInvocation uPnPActionInvocation = uPnPAction.getInvocation();
        UPnPActionArgument[] uPnPActionArgumentArray = uPnPActionInvocation.invoke();
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < uPnPActionArgumentArray.length; ++i) {
            UPnPActionArgument uPnPActionArgument = uPnPActionArgumentArray[i];
            String string4 = uPnPActionArgument.getName();
            if (string4.equalsIgnoreCase("NewConnectionStatus")) {
                string = uPnPActionArgument.getValue();
                continue;
            }
            if (string4.equalsIgnoreCase("NewLastConnectionError")) {
                string2 = uPnPActionArgument.getValue();
                continue;
            }
            if (!string4.equalsIgnoreCase("NewUptime")) continue;
            string3 = uPnPActionArgument.getValue();
        }
        return new String[]{string, string2, string3};
    }

    @Override
    public void periodicallyRecheckMappings(boolean bl) {
        this.recheck_mappings = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkMappings() throws UPnPException {
        ArrayList arrayList;
        if (!this.recheck_mappings) {
            return;
        }
        try {
            class_mon.enter();
            arrayList = new ArrayList(this.mappings);
        }
        finally {
            class_mon.exit();
        }
        UPnPWANConnectionPortMapping[] uPnPWANConnectionPortMappingArray = this.getPortMappings();
        Iterator iterator = arrayList.iterator();
        block5: while (iterator.hasNext()) {
            portMapping portMapping2 = (portMapping)iterator.next();
            for (int i = 0; i < uPnPWANConnectionPortMappingArray.length; ++i) {
                UPnPWANConnectionPortMapping uPnPWANConnectionPortMapping = uPnPWANConnectionPortMappingArray[i];
                if (uPnPWANConnectionPortMapping.getExternalPort() != portMapping2.getExternalPort() || uPnPWANConnectionPortMapping.isTCP() != portMapping2.isTCP()) continue;
                iterator.remove();
                continue block5;
            }
        }
        boolean bl = false;
        if (arrayList.size() > 0) {
            if (!this.last_mapping_check_failed) {
                this.last_mapping_check_failed = true;
                bl = true;
            }
        } else {
            this.last_mapping_check_failed = false;
        }
        for (portMapping portMapping3 : arrayList) {
            try {
                if (bl) {
                    this.log("Re-establishing mapping " + portMapping3.getString());
                }
                this.addPortMapping(portMapping3.isTCP(), portMapping3.getExternalPort(), portMapping3.getDescription());
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPortMapping(boolean bl, int n, String string) throws UPnPException {
        UPnPAction uPnPAction = this.service.getAction("AddPortMapping");
        if (uPnPAction == null) {
            this.log("Action 'AddPortMapping' not supported, binding not established");
        } else {
            Object object;
            UPnPActionInvocation uPnPActionInvocation = uPnPAction.getInvocation();
            uPnPActionInvocation.addArgument("NewRemoteHost", "");
            uPnPActionInvocation.addArgument("NewExternalPort", "" + n);
            uPnPActionInvocation.addArgument("NewProtocol", bl ? "TCP" : "UDP");
            uPnPActionInvocation.addArgument("NewInternalPort", "" + n);
            uPnPActionInvocation.addArgument("NewInternalClient", this.service.getDevice().getRootDevice().getLocalAddress().getHostAddress());
            uPnPActionInvocation.addArgument("NewEnabled", "1");
            uPnPActionInvocation.addArgument("NewPortMappingDescription", string);
            uPnPActionInvocation.addArgument("NewLeaseDuration", "0");
            boolean bl2 = false;
            try {
                uPnPActionInvocation.invoke();
                bl2 = true;
            }
            catch (UPnPException uPnPException) {
                try {
                    this.log("Problem when adding port mapping - will try to see if an existing mapping is in the way");
                    this.deletePortMapping(bl, n);
                }
                catch (Throwable throwable) {
                    throw uPnPException;
                }
                uPnPActionInvocation.invoke();
                bl2 = true;
            }
            finally {
                ((UPnPRootDeviceImpl)this.service.getDevice().getRootDevice()).portMappingResult(bl2);
                for (int i = 0; i < this.listeners.size(); ++i) {
                    object = (UPnPWANConnectionListener)this.listeners.get(i);
                    try {
                        object.mappingResult(this, bl2);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
            try {
                class_mon.enter();
                Iterator iterator = this.mappings.iterator();
                while (iterator.hasNext()) {
                    object = (portMapping)iterator.next();
                    if (((portMapping)object).getExternalPort() != n || ((portMapping)object).isTCP() != bl) continue;
                    iterator.remove();
                }
                this.mappings.add(new portMapping(n, bl, "", string));
            }
            finally {
                class_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePortMapping(boolean bl, int n) throws UPnPException {
        UPnPAction uPnPAction = this.service.getAction("DeletePortMapping");
        if (uPnPAction == null) {
            this.log("Action 'DeletePortMapping' not supported, binding not removed");
        } else {
            boolean bl2 = false;
            try {
                class_mon.enter();
                Iterator iterator = this.mappings.iterator();
                while (iterator.hasNext()) {
                    portMapping portMapping2 = (portMapping)iterator.next();
                    if (portMapping2.getExternalPort() != n || portMapping2.isTCP() != bl) continue;
                    iterator.remove();
                    bl2 = true;
                    break;
                }
            }
            finally {
                class_mon.exit();
            }
            try {
                long l = SystemTime.getCurrentTime();
                UPnPActionInvocation uPnPActionInvocation = uPnPAction.getInvocation();
                uPnPActionInvocation.addArgument("NewRemoteHost", "");
                uPnPActionInvocation.addArgument("NewProtocol", bl ? "TCP" : "UDP");
                uPnPActionInvocation.addArgument("NewExternalPort", "" + n);
                uPnPActionInvocation.invoke();
                long l2 = SystemTime.getCurrentTime() - l;
                if (l2 > 4000L) {
                    String string = this.service.getDevice().getRootDevice().getInfo();
                    ((UPnPImpl)this.service.getDevice().getRootDevice().getUPnP()).logAlert("UPnP device '" + string + "' is taking a long time to release port mappings, consider disabling this via the UPnP configuration.", false, 3);
                }
            }
            catch (UPnPException uPnPException) {
                if (bl2) {
                    throw uPnPException;
                }
                this.log("Removal of mapping failed but not established explicitly so ignoring error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UPnPWANConnectionPortMapping[] getPortMappings() throws UPnPException {
        boolean bl = true;
        try {
            UPnPWANConnectionPortMapping[] uPnPWANConnectionPortMappingArray;
            int n = 0;
            UPnPAction uPnPAction = this.service.getAction("GetGenericPortMappingEntry");
            if (uPnPAction == null) {
                this.log("Action 'GetGenericPortMappingEntry' not supported, can't enumerate bindings");
                UPnPWANConnectionPortMapping[] uPnPWANConnectionPortMappingArray2 = new UPnPWANConnectionPortMapping[]{};
                return uPnPWANConnectionPortMappingArray2;
            }
            ArrayList<portMapping> arrayList = new ArrayList<portMapping>();
            portMapping portMapping2 = null;
            for (int i = 0; i < (n == 0 ? 512 : n); ++i) {
                uPnPWANConnectionPortMappingArray = uPnPAction.getInvocation();
                uPnPWANConnectionPortMappingArray.addArgument("NewPortMappingIndex", "" + i);
                try {
                    UPnPActionArgument[] uPnPActionArgumentArray = uPnPWANConnectionPortMappingArray.invoke();
                    int n2 = 0;
                    boolean bl2 = false;
                    String string = null;
                    String string2 = "";
                    for (int j = 0; j < uPnPActionArgumentArray.length; ++j) {
                        UPnPActionArgument uPnPActionArgument = uPnPActionArgumentArray[j];
                        String string3 = uPnPActionArgument.getName();
                        if (string3.equalsIgnoreCase("NewExternalPort")) {
                            n2 = Integer.parseInt(uPnPActionArgument.getValue());
                            continue;
                        }
                        if (string3.equalsIgnoreCase("NewProtocol")) {
                            bl2 = uPnPActionArgument.getValue().equalsIgnoreCase("TCP");
                            continue;
                        }
                        if (string3.equalsIgnoreCase("NewInternalClient")) {
                            string = uPnPActionArgument.getValue();
                            continue;
                        }
                        if (!string3.equalsIgnoreCase("NewPortMappingDescription")) continue;
                        string2 = uPnPActionArgument.getValue();
                    }
                    if (portMapping2 != null && portMapping2.getExternalPort() == n2 && portMapping2.isTCP() == bl2) break;
                    portMapping2 = new portMapping(n2, bl2, string, string2);
                    arrayList.add(portMapping2);
                    continue;
                }
                catch (UPnPException uPnPException) {
                    if (n == 0) break;
                    bl = false;
                    throw uPnPException;
                }
            }
            UPnPWANConnectionPortMapping[] uPnPWANConnectionPortMappingArray3 = new UPnPWANConnectionPortMapping[arrayList.size()];
            arrayList.toArray(uPnPWANConnectionPortMappingArray3);
            uPnPWANConnectionPortMappingArray = uPnPWANConnectionPortMappingArray3;
            return uPnPWANConnectionPortMappingArray;
        }
        finally {
            for (int i = 0; i < this.listeners.size(); ++i) {
                UPnPWANConnectionListener uPnPWANConnectionListener = (UPnPWANConnectionListener)this.listeners.get(i);
                try {
                    uPnPWANConnectionListener.mappingsReadResult(this, bl);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    @Override
    public String getExternalIPAddress() throws UPnPException {
        UPnPAction uPnPAction = this.service.getAction("GetExternalIPAddress");
        if (uPnPAction == null) {
            this.log("Action 'GetExternalIPAddress' not supported, binding not established");
            throw new UPnPException("GetExternalIPAddress not supported");
        }
        UPnPActionInvocation uPnPActionInvocation = uPnPAction.getInvocation();
        UPnPActionArgument[] uPnPActionArgumentArray = uPnPActionInvocation.invoke();
        String string = null;
        for (int i = 0; i < uPnPActionArgumentArray.length; ++i) {
            UPnPActionArgument uPnPActionArgument = uPnPActionArgumentArray[i];
            String string2 = uPnPActionArgument.getName();
            if (!string2.equalsIgnoreCase("NewExternalIPAddress")) continue;
            string = uPnPActionArgument.getValue();
        }
        return string;
    }

    protected void log(String string) {
        this.service.getDevice().getRootDevice().getUPnP().log(string);
    }

    @Override
    public void addListener(UPnPWANConnectionListener uPnPWANConnectionListener) {
        this.listeners.add(uPnPWANConnectionListener);
    }

    @Override
    public void removeListener(UPnPWANConnectionListener uPnPWANConnectionListener) {
        this.listeners.add(uPnPWANConnectionListener);
    }

    static {
        SimpleTimer.addPeriodicEvent("UPnPSSWAN:checker", 600000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent timerEvent2) {
                try {
                    ArrayList<UPnPSSWANConnectionImpl> arrayList = new ArrayList<UPnPSSWANConnectionImpl>();
                    try {
                        class_mon.enter();
                        Iterator iterator = services.iterator();
                        while (iterator.hasNext()) {
                            UPnPSSWANConnectionImpl uPnPSSWANConnectionImpl = (UPnPSSWANConnectionImpl)iterator.next();
                            if (uPnPSSWANConnectionImpl.getGenericService().getDevice().getRootDevice().isDestroyed()) {
                                iterator.remove();
                                continue;
                            }
                            arrayList.add(uPnPSSWANConnectionImpl);
                        }
                    }
                    finally {
                        class_mon.exit();
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        try {
                            ((UPnPSSWANConnectionImpl)arrayList.get(i)).checkMappings();
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        });
    }

    protected class portMapping
    implements UPnPWANConnectionPortMapping {
        protected int external_port;
        protected boolean tcp;
        protected String internal_host;
        protected String description;

        protected portMapping(int n, boolean bl, String string, String string2) {
            this.external_port = n;
            this.tcp = bl;
            this.internal_host = string;
            this.description = string2;
        }

        @Override
        public boolean isTCP() {
            return this.tcp;
        }

        @Override
        public int getExternalPort() {
            return this.external_port;
        }

        @Override
        public String getInternalHost() {
            return this.internal_host;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        protected String getString() {
            return this.getDescription() + " [" + this.getExternalPort() + ":" + (this.isTCP() ? "TCP" : "UDP") + "]";
        }
    }
}

