/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.piecemapper.impl;

import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMap;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.torrent.TOTorrent;

public class DMPieceMapSimple
implements DMPieceMap {
    private final int piece_length;
    private final int piece_count;
    private final int last_piece_length;
    private final DiskManagerFileInfoImpl file;

    protected DMPieceMapSimple(TOTorrent tOTorrent, DiskManagerFileInfoImpl diskManagerFileInfoImpl) {
        this.piece_length = (int)tOTorrent.getPieceLength();
        this.piece_count = tOTorrent.getNumberOfPieces();
        int n = (int)(tOTorrent.getSize() % (long)this.piece_length);
        if (n == 0) {
            n = this.piece_length;
        }
        this.last_piece_length = n;
        this.file = diskManagerFileInfoImpl;
    }

    @Override
    public DMPieceList getPieceList(int n) {
        return new pieceList(n);
    }

    protected class pieceList
    implements DMPieceList,
    DMPieceMapEntry {
        private int piece_number;

        protected pieceList(int n) {
            this.piece_number = n;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public DMPieceMapEntry get(int n) {
            return this;
        }

        @Override
        public int getCumulativeLengthToPiece(int n) {
            return this.getLength();
        }

        @Override
        public DiskManagerFileInfoImpl getFile() {
            return DMPieceMapSimple.this.file;
        }

        @Override
        public long getOffset() {
            return (long)this.piece_number * (long)DMPieceMapSimple.this.piece_length;
        }

        @Override
        public int getLength() {
            if (this.piece_number == DMPieceMapSimple.this.piece_count - 1) {
                return DMPieceMapSimple.this.last_piece_length;
            }
            return DMPieceMapSimple.this.piece_length;
        }
    }
}

