/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.logging.impl;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.ILogAlertListener;
import org.gudy.azureus2.core3.logging.ILogEventListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;

public class LoggerImpl {
    private final int MAXHISTORY = 256;
    private boolean bLogToStdOut = System.getProperty("azureus.log.stdout") != null;
    private boolean bEventLoggingEnabled = false;
    private PrintStream psOldOut = null;
    private PrintStream psOldErr = null;
    private PrintStream psOut;
    private PrintStream psErr;
    private List logListeners = new ArrayList();
    private AEDiagnosticsLogger alertLogger;
    private List alertListeners = new ArrayList();
    private List alertHistory = new ArrayList();
    private boolean logToStdErrAllowed = true;

    public LoggerImpl() {
        this.doRedirects();
    }

    public void init() {
        boolean bl;
        this.bEventLoggingEnabled = true;
        final ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        boolean bl2 = bl = System.getProperty("azureus.overridelog") != null;
        if (bl) {
            this.bEventLoggingEnabled = true;
        } else {
            this.bEventLoggingEnabled = configurationManager.getBooleanParameter("Logger.Enabled");
            configurationManager.addParameterListener("Logger.Enabled", new ParameterListener(){

                @Override
                public void parameterChanged(String string) {
                    LoggerImpl.this.bEventLoggingEnabled = configurationManager.getBooleanParameter("Logger.Enabled");
                }
            });
        }
    }

    public void doRedirects() {
        try {
            if (System.out != this.psOut) {
                if (this.psOldOut == null) {
                    this.psOldOut = System.out;
                }
                this.psOut = new PrintStream(new RedirectorStream(this.psOldOut, LogIDs.STDOUT, 0));
                System.setOut(this.psOut);
            }
            if (System.err != this.psErr) {
                if (this.psOldErr == null) {
                    this.psOldErr = System.err;
                }
                this.psErr = new PrintStream(new RedirectorStream(this.psOldErr, LogIDs.STDERR, 3));
                System.setErr(this.psErr);
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public boolean isEnabled() {
        return this.bEventLoggingEnabled;
    }

    public void log(LogEvent logEvent) {
        if (this.bLogToStdOut && this.psOldOut != null) {
            this.psOldOut.println(logEvent.text);
        }
        if (logEvent.entryType == 3) {
            if (AEDiagnostics.isStartupComplete()) {
                Debug.outDiagLoggerOnly("[" + logEvent.logID + "] " + logEvent.text);
            }
            if (this.logToStdErrAllowed && this.psOldErr != null && logEvent.logID != LogIDs.STDERR) {
                this.psOldErr.println("[" + logEvent.logID + "] " + logEvent.text);
            }
        }
        if (this.bEventLoggingEnabled) {
            for (int i = 0; i < this.logListeners.size(); ++i) {
                try {
                    Object e = this.logListeners.get(i);
                    if (!(e instanceof ILogEventListener)) continue;
                    ((ILogEventListener)e).log(logEvent);
                    continue;
                }
                catch (Throwable throwable) {
                    if (!this.logToStdErrAllowed || this.psOldErr == null) continue;
                    this.psOldErr.println("Error while logging: " + throwable.getMessage());
                    throwable.printStackTrace(this.psOldErr);
                }
            }
        }
        if (logEvent.err != null && logEvent.entryType == 3) {
            Debug.printStackTrace(logEvent.err);
        }
    }

    public void logTextResource(LogEvent logEvent) {
        logEvent.text = MessageText.getString(logEvent.text);
        this.log(logEvent);
    }

    public void logTextResource(LogEvent logEvent, String[] stringArray) {
        logEvent.text = MessageText.getString(logEvent.text, stringArray);
        this.log(logEvent);
    }

    public void addListener(ILogEventListener iLogEventListener) {
        this.logListeners.add(iLogEventListener);
    }

    public void removeListener(ILogEventListener iLogEventListener) {
        this.logListeners.remove(iLogEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(LogAlert logAlert) {
        String string = "Alert:" + logAlert.entryType + ":" + logAlert.text;
        LogEvent logEvent = new LogEvent(LogIDs.ALERT, logAlert.entryType, string);
        logEvent.err = logAlert.err;
        Logger.log(logEvent);
        LoggerImpl loggerImpl = this;
        synchronized (loggerImpl) {
            if (this.alertLogger == null) {
                this.alertLogger = AEDiagnostics.getLogger("alerts");
            }
        }
        this.alertLogger.log(string);
        this.alertHistory.add(logAlert);
        if (this.alertHistory.size() > 256) {
            this.alertHistory.remove(0);
        }
        for (int i = 0; i < this.alertListeners.size(); ++i) {
            try {
                Object e = this.alertListeners.get(i);
                if (!(e instanceof ILogAlertListener)) continue;
                ((ILogAlertListener)e).alertRaised(logAlert);
                continue;
            }
            catch (Throwable throwable) {
                if (this.psOldErr == null) continue;
                this.psOldErr.println("Error while alerting: " + throwable.getMessage());
                throwable.printStackTrace(this.psOldErr);
            }
        }
    }

    public void logTextResource(LogAlert logAlert) {
        logAlert.text = MessageText.getString(logAlert.text);
        this.log(logAlert);
    }

    public void logTextResource(LogAlert logAlert, String[] stringArray) {
        logAlert.text = MessageText.getString(logAlert.text, stringArray);
        this.log(logAlert);
    }

    public void addListener(ILogAlertListener iLogAlertListener) {
        this.alertListeners.add(iLogAlertListener);
        for (int i = 0; i < this.alertHistory.size(); ++i) {
            LogAlert logAlert = (LogAlert)this.alertHistory.get(i);
            iLogAlertListener.alertRaised(logAlert);
        }
    }

    public void removeListener(ILogAlertListener iLogAlertListener) {
        this.alertListeners.remove(iLogAlertListener);
    }

    public PrintStream getOldStdErr() {
        return this.psOldErr;
    }

    public void allowLoggingToStdErr(boolean bl) {
        this.logToStdErrAllowed = bl;
    }

    private class RedirectorStream
    extends OutputStream {
        protected PrintStream ps;
        protected StringBuffer buffer = new StringBuffer(1024);
        protected LogIDs logID;
        protected int logType;

        protected RedirectorStream(PrintStream printStream, LogIDs logIDs, int n) {
            this.ps = printStream;
            this.logType = n;
            this.logID = logIDs;
        }

        @Override
        public void write(int n) {
            char c = (char)n;
            if (c == '\n') {
                if (!LoggerImpl.this.bLogToStdOut) {
                    this.ps.println(this.buffer);
                }
                LoggerImpl.this.log(new LogEvent(this.logID, this.logType, this.buffer.toString()));
                this.buffer.setLength(0);
            } else if (c != '\r') {
                this.buffer.append(c);
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            for (int i = n; i < n + n2; ++i) {
                int n3 = byArray[i];
                if (n3 < 0) {
                    n3 += 256;
                }
                this.write(n3);
            }
        }
    }
}

