/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.StringInterner;

public class TOTorrentFileImpl
implements TOTorrentFile {
    private final TOTorrent torrent;
    private final long file_length;
    private final byte[][] path_components;
    private final byte[][] path_components_utf8;
    private final int first_piece_number;
    private final int last_piece_number;
    private final Map additional_properties = new LightHashMap(1);
    private final boolean is_utf8;

    protected TOTorrentFileImpl(TOTorrent tOTorrent, long l, long l2, String string) throws TOTorrentException {
        this.torrent = tOTorrent;
        this.file_length = l2;
        this.first_piece_number = (int)(l / this.torrent.getPieceLength());
        this.last_piece_number = (int)((l + this.file_length - 1L) / this.torrent.getPieceLength());
        this.is_utf8 = true;
        try {
            Vector<byte[]> vector = new Vector<byte[]>();
            int n = 0;
            while (true) {
                int n2;
                if ((n2 = string.indexOf(File.separator, n)) == -1) break;
                vector.add(string.substring(n, n2).getBytes("UTF8"));
                n = n2 + 1;
            }
            vector.add(string.substring(n).getBytes("UTF8"));
            this.path_components = new byte[vector.size()][];
            vector.copyInto((Object[])this.path_components);
            this.path_components_utf8 = new byte[vector.size()][];
            vector.copyInto((Object[])this.path_components_utf8);
            this.checkComponents();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TOTorrentException("Unsupported encoding for '" + string + "'", 7);
        }
    }

    protected TOTorrentFileImpl(TOTorrent tOTorrent, long l, long l2, byte[][] byArray) throws TOTorrentException {
        this.torrent = tOTorrent;
        this.file_length = l2;
        this.path_components = byArray;
        this.path_components_utf8 = null;
        this.first_piece_number = (int)(l / this.torrent.getPieceLength());
        this.last_piece_number = (int)((l + this.file_length - 1L) / this.torrent.getPieceLength());
        this.is_utf8 = false;
        this.checkComponents();
    }

    protected TOTorrentFileImpl(TOTorrent tOTorrent, long l, long l2, byte[][] byArray, byte[][] byArray2) throws TOTorrentException {
        this.torrent = tOTorrent;
        this.file_length = l2;
        this.path_components = byArray;
        this.path_components_utf8 = byArray2;
        this.first_piece_number = (int)(l / this.torrent.getPieceLength());
        this.last_piece_number = (int)((l + this.file_length - 1L) / this.torrent.getPieceLength());
        this.is_utf8 = false;
        this.checkComponents();
    }

    protected void checkComponents() throws TOTorrentException {
        byte[][][] byArrayArray;
        for (byte[][] byArray : byArrayArray = new byte[][][]{this.path_components, this.path_components_utf8}) {
            if (byArray == null) continue;
            for (int i = 0; i < byArray.length; ++i) {
                byte[] byArray2 = byArray[i];
                if (byArray2.length == 2 && byArray2[0] == 46 && byArray2[1] == 46) {
                    throw new TOTorrentException("Torrent file contains illegal '..' component", 6);
                }
                if (i >= byArray.length - 1) continue;
                byArray[i] = StringInterner.internBytes(byArray[i]);
            }
        }
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public long getLength() {
        return this.file_length;
    }

    public byte[][] getPathComponentsBasic() {
        return this.path_components;
    }

    @Override
    public byte[][] getPathComponents() {
        return this.path_components_utf8 == null ? this.path_components : this.path_components_utf8;
    }

    public byte[][] getPathComponentsUTF8() {
        return this.path_components_utf8;
    }

    protected boolean isUTF8() {
        return this.is_utf8;
    }

    protected void setAdditionalProperty(String string, Object object) {
        this.additional_properties.put(string, object);
    }

    protected Map getAdditionalProperties() {
        return this.additional_properties;
    }

    @Override
    public int getFirstPieceNumber() {
        return this.first_piece_number;
    }

    @Override
    public int getLastPieceNumber() {
        return this.last_piece_number;
    }

    @Override
    public int getNumberOfPieces() {
        return this.getLastPieceNumber() - this.getFirstPieceNumber() + 1;
    }

    @Override
    public String getRelativePath() {
        Object object;
        if (this.torrent == null) {
            return "";
        }
        String string = "";
        byte[][] byArray = this.getPathComponentsUTF8();
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                try {
                    String string2;
                    try {
                        string2 = new String(byArray[i], "utf8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        System.out.println("file - unsupported encoding!!!!");
                        string2 = "UnsupportedEncoding";
                    }
                    string2 = FileUtil.convertOSSpecificChars(string2, i != byArray.length - 1);
                    string = string + (i == 0 ? "" : File.separator) + string2;
                    continue;
                }
                catch (Exception exception) {
                    Debug.out(exception);
                }
            }
            return string;
        }
        LocaleUtilDecoder localeUtilDecoder = null;
        try {
            localeUtilDecoder = LocaleTorrentUtil.getTorrentEncodingIfAvailable(this.torrent);
            if (localeUtilDecoder == null) {
                object = LocaleUtil.getSingleton();
                localeUtilDecoder = ((LocaleUtil)object).getUTF8Decoder();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (localeUtilDecoder != null) {
            object = this.getPathComponents();
            for (int i = 0; i < ((Object)object).length; ++i) {
                try {
                    String string3;
                    try {
                        string3 = localeUtilDecoder.decodeString((byte[])object[i]);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        System.out.println("file - unsupported encoding!!!!");
                        try {
                            string3 = new String((byte[])object[i]);
                        }
                        catch (Exception exception) {
                            string3 = "UnsupportedEncoding";
                        }
                    }
                    string3 = FileUtil.convertOSSpecificChars(string3, i != ((Object)object).length - 1);
                    string = string + (i == 0 ? "" : File.separator) + string3;
                    continue;
                }
                catch (Exception exception) {
                    Debug.out(exception);
                }
            }
        }
        return string;
    }

    public Map serializeToMap() {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("length", new Long(this.getLength()));
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        hashMap.put("path", arrayList);
        byte[][] byArray = this.getPathComponentsBasic();
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                arrayList.add(byArray[i]);
            }
        }
        if (byArray != null && this.isUTF8()) {
            object = new ArrayList();
            hashMap.put("path.utf-8", object);
            for (int i = 0; i < byArray.length; ++i) {
                object.add(byArray[i]);
            }
        } else {
            object = this.getPathComponentsUTF8();
            if (object != null) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                hashMap.put("path.utf-8", arrayList2);
                for (int i = 0; i < ((Object)object).length; ++i) {
                    arrayList2.add(object[i]);
                }
            }
        }
        object = this.getAdditionalProperties();
        for (String string : object.keySet()) {
            hashMap.put(string, object.get(string));
        }
        return hashMap;
    }
}

