/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import com.aelitis.net.udp.uc.PRUDPPacketReply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PRUDPPacketReplyScrape
extends PRUDPPacketReply {
    protected static final int BYTES_PER_ENTRY = 32;
    protected byte[][] hashes;
    protected int[] complete;
    protected int[] incomplete;
    protected int[] downloaded;

    public PRUDPPacketReplyScrape(int n) {
        super(2, n);
    }

    protected PRUDPPacketReplyScrape(DataInputStream dataInputStream, int n) throws IOException {
        super(2, n);
        this.hashes = new byte[dataInputStream.available() / 32][];
        this.complete = new int[this.hashes.length];
        this.incomplete = new int[this.hashes.length];
        this.downloaded = new int[this.hashes.length];
        for (int i = 0; i < this.hashes.length; ++i) {
            this.hashes[i] = new byte[20];
            dataInputStream.read(this.hashes[i]);
            this.complete[i] = dataInputStream.readInt();
            this.downloaded[i] = dataInputStream.readInt();
            this.incomplete[i] = dataInputStream.readInt();
        }
    }

    public void setDetails(byte[][] byArray, int[] nArray, int[] nArray2, int[] nArray3) {
        this.hashes = byArray;
        this.complete = nArray;
        this.downloaded = nArray2;
        this.incomplete = nArray3;
    }

    public byte[][] getHashes() {
        return this.hashes;
    }

    public int[] getComplete() {
        return this.complete;
    }

    public int[] getDownloaded() {
        return this.downloaded;
    }

    public int[] getIncomplete() {
        return this.incomplete;
    }

    @Override
    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        if (this.hashes != null) {
            for (int i = 0; i < this.hashes.length; ++i) {
                dataOutputStream.write(this.hashes[i]);
                dataOutputStream.writeInt(this.complete[i]);
                dataOutputStream.writeInt(this.downloaded[i]);
                dataOutputStream.writeInt(this.incomplete[i]);
            }
        }
    }

    @Override
    public String getString() {
        return super.getString().concat("[hashes=").concat(String.valueOf(this.hashes.length)).concat("]");
    }
}

