/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeerBase;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentPeerListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentStats;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNATChecker;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerSimplePeer;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentStatsImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class TRTrackerServerTorrentImpl
implements TRTrackerServerTorrent {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    public static final int MIN_CACHE_ENTRY_SIZE = 10;
    public static final int MAX_UPLOAD_BYTES_PER_SEC = 0x300000;
    public static final int MAX_DOWNLOAD_BYTES_PER_SEC = 0x300000;
    public static final boolean USE_LIGHTWEIGHT_SEEDS = true;
    public static final int MAX_IP_OVERRIDE_PEERS = 64;
    public static final byte COMPACT_MODE_NONE = 0;
    public static final byte COMPACT_MODE_NORMAL = 1;
    public static final byte COMPACT_MODE_AZ = 2;
    public static final byte COMPACT_MODE_AZ_2 = 3;
    public static final byte COMPACT_MODE_XML = 16;
    private static final int QUEUED_PEERS_MAX_SWARM_SIZE = 32;
    private static final int QUEUED_PEERS_MAX = 32;
    private static final int QUEUED_PEERS_ADD_MAX = 3;
    private TRTrackerServerImpl server;
    private HashWrapper hash;
    private Map<HashWrapper, TRTrackerServerPeerImpl> peer_map = new HashMap<HashWrapper, TRTrackerServerPeerImpl>();
    private Map<String, TRTrackerServerPeerImpl> peer_reuse_map = new HashMap<String, TRTrackerServerPeerImpl>();
    private List<TRTrackerServerPeerImpl> peer_list = new ArrayList<TRTrackerServerPeerImpl>();
    private int peer_list_hole_count;
    private boolean peer_list_compaction_suspended;
    private List biased_peers = null;
    private int min_biased_peers = 0;
    private Map lightweight_seed_map = new HashMap();
    private int seed_count;
    private int removed_count;
    private int ip_override_count;
    private int bad_NAT_count;
    private Random random = new Random(SystemTime.getCurrentTime());
    private long last_scrape_calc_time;
    private Map last_scrape;
    private LinkedHashMap announce_cache = new LinkedHashMap();
    private TRTrackerServerTorrentStatsImpl stats;
    private List listeners = new ArrayList();
    private List peer_listeners;
    private boolean deleted;
    private boolean enabled;
    private boolean map_size_diff_reported;
    private boolean ip_override_limit_exceeded_reported;
    private byte duplicate_peer_checker_index = 0;
    private byte[] duplicate_peer_checker = new byte[0];
    private URL[] redirects;
    private boolean caching_enabled = true;
    private LinkedList queued_peers;
    protected AEMonitor this_mon = new AEMonitor("TRTrackerServerTorrent");
    private List explicit_manual_biased_peers;
    private int explicit_next_peer;

    public TRTrackerServerTorrentImpl(TRTrackerServerImpl tRTrackerServerImpl, HashWrapper hashWrapper, boolean bl) {
        this.server = tRTrackerServerImpl;
        this.hash = hashWrapper;
        this.enabled = bl;
        this.stats = new TRTrackerServerTorrentStatsImpl(this);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setMinBiasedPeers(int n) {
        this.min_biased_peers = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importPeers(List list) {
        try {
            this.this_mon.enter();
            if (this.peer_map.size() > 0) {
                System.out.println("TRTrackerServerTorrent: ignoring peer import as torrent already active");
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                TRTrackerServerPeerImpl tRTrackerServerPeerImpl = TRTrackerServerPeerImpl.importPeer((Map)list.get(i));
                if (tRTrackerServerPeerImpl == null) continue;
                try {
                    String string = new String(tRTrackerServerPeerImpl.getIPAsRead(), "ISO-8859-1") + ":" + tRTrackerServerPeerImpl.getTCPPort();
                    this.peer_map.put(tRTrackerServerPeerImpl.getPeerId(), tRTrackerServerPeerImpl);
                    this.peer_list.add(tRTrackerServerPeerImpl);
                    this.peer_reuse_map.put(string, tRTrackerServerPeerImpl);
                    if (tRTrackerServerPeerImpl.isSeed()) {
                        ++this.seed_count;
                    }
                    if (!tRTrackerServerPeerImpl.isBiased()) continue;
                    if (this.biased_peers == null) {
                        this.biased_peers = new ArrayList();
                    }
                    this.biased_peers.add(tRTrackerServerPeerImpl);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerPeerImpl peerContact(String string, String string2, HashWrapper hashWrapper, int n, int n2, int n3, byte by, byte by2, String string3, String string4, boolean bl, boolean bl2, String string5, long l, long l2, long l3, long l4, int n4, DHTNetworkPosition dHTNetworkPosition) throws TRTrackerServerException {
        if (!this.enabled) {
            throw new TRTrackerServerException("Torrent temporarily disabled");
        }
        if (!HostNameToIPResolver.isNonDNSName(string4)) {
            try {
                string4 = HostNameToIPResolver.syncResolve(string4).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        TRTrackerServerException tRTrackerServerException = null;
        try {
            boolean bl3;
            Object object;
            Object object2;
            TRTrackerServerPeerImpl tRTrackerServerPeerImpl;
            this.this_mon.enter();
            this.handleRedirects(string, string4, false);
            int n5 = 2;
            if (string2 != null && string2.length() > 2) {
                char c = string2.charAt(2);
                n5 = c == 'm' ? 3 : (c == 'o' ? 4 : 1);
            }
            long l5 = SystemTime.getCurrentTime();
            int n6 = string5 == null ? 0 : string5.hashCode();
            TRTrackerServerPeerImpl tRTrackerServerPeerImpl2 = this.peer_map.get(hashWrapper);
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            long l6 = 0L;
            long l7 = 0L;
            long l8 = 0L;
            long l9 = 0L;
            byte[] byArray = string4.getBytes("ISO-8859-1");
            if (tRTrackerServerPeerImpl2 == null) {
                String string6 = new String(byArray, "ISO-8859-1") + ":" + n;
                byte by3 = bl2 ? (byte)3 : 0;
                bl4 = true;
                tRTrackerServerPeerImpl = this.peer_reuse_map.get(string6);
                if (tRTrackerServerPeerImpl != null) {
                    if (bl && !tRTrackerServerPeerImpl.isIPOverride()) {
                        throw new TRTrackerServerException("IP Override denied (existing '" + string6 + "' is not override)");
                    }
                    l6 = tRTrackerServerPeerImpl.getLastContactTime();
                    bl6 = tRTrackerServerPeerImpl.getDownloadCompleted();
                    this.removePeer(tRTrackerServerPeerImpl, 5, null);
                    this.lightweight_seed_map.remove(tRTrackerServerPeerImpl.getPeerId());
                } else {
                    object2 = (lightweightSeed)this.lightweight_seed_map.remove(hashWrapper);
                    if (object2 != null) {
                        l6 = ((lightweightSeed)object2).getLastContactTime();
                        l7 = l - ((lightweightSeed)object2).getUploaded();
                        if (l7 < 0L) {
                            l7 = 0L;
                        }
                        by3 = ((lightweightSeed)object2).getNATStatus();
                    } else {
                        l6 = l5;
                    }
                }
                if (n5 != 4) {
                    boolean bl7;
                    object2 = this.server.getBiasedPeers();
                    boolean bl8 = bl7 = object2 != null && object2.contains(string4);
                    if (bl && this.ip_override_count >= 64 && !bl2 && !bl7) {
                        if (!this.ip_override_limit_exceeded_reported) {
                            this.ip_override_limit_exceeded_reported = true;
                            Debug.out("Too many ip-override peers for " + ByteFormatter.encodeString(this.hash.getBytes()));
                        }
                        TRTrackerServerPeerImpl tRTrackerServerPeerImpl3 = null;
                        return tRTrackerServerPeerImpl3;
                    }
                    tRTrackerServerPeerImpl2 = new TRTrackerServerPeerImpl(hashWrapper, n6, byArray, bl, n, n2, n3, by, by2, l6, bl6, by3, n4, dHTNetworkPosition);
                    if (bl) {
                        if (bl7 && !object2.contains(string3)) {
                            throw new TRTrackerServerException("IP Override denied (you are " + string3 + ")");
                        }
                        ++this.ip_override_count;
                    }
                    this.peer_map.put(hashWrapper, tRTrackerServerPeerImpl2);
                    this.peer_list.add(tRTrackerServerPeerImpl2);
                    this.peer_reuse_map.put(string6, tRTrackerServerPeerImpl2);
                    if (bl7) {
                        tRTrackerServerPeerImpl2.setBiased(true);
                        if (this.biased_peers == null) {
                            this.biased_peers = new ArrayList();
                        }
                        this.biased_peers.add(tRTrackerServerPeerImpl2);
                    }
                    if (this.queued_peers != null) {
                        if (this.peer_map.size() > 32) {
                            this.queued_peers = null;
                        } else {
                            object = this.queued_peers.iterator();
                            while (object.hasNext()) {
                                QueuedPeer queuedPeer = (QueuedPeer)object.next();
                                if (!queuedPeer.sameAs(tRTrackerServerPeerImpl2)) continue;
                                object.remove();
                                break;
                            }
                        }
                    }
                }
            } else {
                Object object3;
                int n7 = tRTrackerServerPeerImpl2.getKeyHashCode();
                if (n7 != n6) {
                    throw new TRTrackerServerException("Unauthorised: key mismatch ");
                }
                if (bl) {
                    if (tRTrackerServerPeerImpl2.isBiased() && ((object3 = this.server.getBiasedPeers()) == null || !object3.contains(string3))) {
                        throw new TRTrackerServerException("IP Override denied (you are " + string3 + ")");
                    }
                    if (!tRTrackerServerPeerImpl2.isIPOverride()) {
                        throw new TRTrackerServerException("IP Override denied (existing entry not override)");
                    }
                }
                bl6 = tRTrackerServerPeerImpl2.getDownloadCompleted();
                l6 = tRTrackerServerPeerImpl2.getLastContactTime();
                if (n5 == 4) {
                    this.removePeer(tRTrackerServerPeerImpl2, n5, string);
                    bl5 = true;
                } else {
                    object3 = tRTrackerServerPeerImpl2.getIPAsRead();
                    int n8 = tRTrackerServerPeerImpl2.getTCPPort();
                    if (tRTrackerServerPeerImpl2.update(byArray, n, n2, n3, by, by2, n4, dHTNetworkPosition)) {
                        object2 = new String((byte[])object3, "ISO-8859-1") + ":" + n8;
                        String string7 = new String(byArray, "ISO-8859-1") + ":" + n;
                        object = this.peer_reuse_map.get(string7);
                        if (object != null) {
                            this.removePeer((TRTrackerServerPeerImpl)object, 5, null);
                        }
                        if (this.peer_reuse_map.remove(object2) == null) {
                            Debug.out("TRTrackerServerTorrent: IP address change: '" + (String)object2 + "' -> '" + string7 + "': old key not found");
                        }
                        this.peer_reuse_map.put(string7, tRTrackerServerPeerImpl2);
                    }
                }
            }
            long l10 = l5 + l4 * 1000L * 3L;
            if (tRTrackerServerPeerImpl2 != null) {
                long l11;
                tRTrackerServerPeerImpl2.setTimeout(l5, l10);
                if (!bl4) {
                    l7 = l - tRTrackerServerPeerImpl2.getUploaded();
                    l8 = l2 - tRTrackerServerPeerImpl2.getDownloaded();
                }
                if ((l11 = l5 - l6) == 0L) {
                    l11 = 25L;
                }
                long l12 = l7 * 1000L / l11;
                long l13 = l8 * 1000L / l11;
                if (l12 > 0x300000L) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "TRTrackerPeer: peer " + tRTrackerServerPeerImpl2.getIPRaw() + "/" + new String(tRTrackerServerPeerImpl2.getPeerId().getHash()) + " reported an upload rate of " + l12 / 1024L + " KiB/s per second"));
                    }
                    l7 = 0L;
                }
                if (l13 > 0x300000L) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "TRTrackerPeer: peer " + tRTrackerServerPeerImpl2.getIPRaw() + "/" + new String(tRTrackerServerPeerImpl2.getPeerId().getHash()) + " reported a download rate of " + l13 / 1024L + " KiB/s per second"));
                    }
                    l8 = 0L;
                }
                l9 = n5 == 4 ? 0L : l3 - tRTrackerServerPeerImpl2.getAmountLeft();
                bl3 = bl4 ? false : tRTrackerServerPeerImpl2.isSeed();
                tRTrackerServerPeerImpl2.setStats(l, l2, l3);
                boolean bl9 = tRTrackerServerPeerImpl2.isSeed();
                if (n5 != 4 && !bl3 && bl9) {
                    ++this.seed_count;
                }
                if (!bl5) {
                    try {
                        this.peerEvent(tRTrackerServerPeerImpl2, n5, string);
                    }
                    catch (TRTrackerServerException tRTrackerServerException2) {
                        tRTrackerServerException = tRTrackerServerException2;
                    }
                }
            }
            this.stats.addAnnounce(l7, l8, l9, tRTrackerServerPeerImpl2 != null && tRTrackerServerPeerImpl2.isBiased());
            if (n5 == 3 && !bl6) {
                tRTrackerServerPeerImpl2.setDownloadCompleted();
                this.stats.addCompleted();
            }
            if (tRTrackerServerPeerImpl2 != null && tRTrackerServerPeerImpl2.isSeed()) {
                int n9 = TRTrackerServerImpl.getSeedLimit();
                if (n9 != 0 && this.seed_count > n9 && !bl2) {
                    if (!bl5) {
                        this.removePeer(tRTrackerServerPeerImpl2, 6, null);
                    }
                    throw new TRTrackerServerException("too many seeds");
                }
                int n10 = TRTrackerServerImpl.getMaxSeedRetention();
                if (n10 != 0 && this.seed_count > n10) {
                    int n11 = n10 / 20 + 1;
                    try {
                        int n12;
                        this.peer_list_compaction_suspended = true;
                        int n13 = n12 = TRTrackerServerNATChecker.getSingleton().isEnabled() ? 0 : 1;
                        while (n12 < 2) {
                            for (int i = 0; i < this.peer_list.size(); ++i) {
                                TRTrackerServerPeerImpl tRTrackerServerPeerImpl4 = this.peer_list.get(i);
                                if (tRTrackerServerPeerImpl4 == null || !tRTrackerServerPeerImpl4.isSeed() || tRTrackerServerPeerImpl4.isBiased()) continue;
                                bl3 = tRTrackerServerPeerImpl4.isNATStatusBad();
                                if ((n12 != 0 || !bl3) && n12 != 1) continue;
                                this.lightweight_seed_map.put(tRTrackerServerPeerImpl4.getPeerId(), new lightweightSeed(l5, l10, tRTrackerServerPeerImpl4.getUploaded(), tRTrackerServerPeerImpl4.getNATStatus()));
                                this.removePeer(tRTrackerServerPeerImpl4, i, 6, null);
                                if (--n11 == 0) break;
                            }
                            if (n11 == 0) {
                                break;
                            }
                            ++n12;
                        }
                    }
                    finally {
                        this.peer_list_compaction_suspended = false;
                    }
                    this.checkForPeerListCompaction(false);
                }
            }
            if (tRTrackerServerException != null) {
                if (tRTrackerServerPeerImpl2 != null && !bl5) {
                    this.removePeer(tRTrackerServerPeerImpl2, 7, string);
                }
                throw tRTrackerServerException;
            }
            tRTrackerServerPeerImpl = tRTrackerServerPeerImpl2;
            return tRTrackerServerPeerImpl;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TRTrackerServerException("Encoding fails", unsupportedEncodingException);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peerQueued(String string, int n, int n2, int n3, byte by, byte by2, long l, boolean bl) {
        if (this.peer_map.size() >= 32 || n == 0) {
            return;
        }
        try {
            this.this_mon.enter();
            Set set = this.server.getBiasedPeers();
            boolean bl2 = set != null && set.contains(string);
            QueuedPeer queuedPeer = new QueuedPeer(string, n, n2, n3, by, by2, (int)l, bl, bl2);
            String string2 = queuedPeer.getIP() + ":" + n;
            if (this.peer_reuse_map.containsKey(string2)) {
                return;
            }
            boolean bl3 = true;
            if (this.queued_peers != null) {
                QueuedPeer queuedPeer2;
                Iterator iterator = this.queued_peers.iterator();
                while (iterator.hasNext()) {
                    queuedPeer2 = (QueuedPeer)iterator.next();
                    if (!queuedPeer2.sameAs(queuedPeer)) continue;
                    iterator.remove();
                    this.queued_peers.add(queuedPeer);
                    return;
                }
                if (this.queued_peers.size() >= 32) {
                    queuedPeer2 = null;
                    for (QueuedPeer queuedPeer3 : this.queued_peers) {
                        if (queuedPeer3.isBiased()) continue;
                        if (queuedPeer2 == null) {
                            queuedPeer2 = queuedPeer3;
                            continue;
                        }
                        if (queuedPeer3.getCreateTime() >= queuedPeer2.getCreateTime()) continue;
                        queuedPeer2 = queuedPeer3;
                    }
                    if (queuedPeer2 == null) {
                        bl3 = false;
                    } else {
                        this.queued_peers.remove(queuedPeer2);
                    }
                }
            } else {
                this.queued_peers = new LinkedList();
            }
            if (bl3) {
                this.queued_peers.addFirst(queuedPeer);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(TRTrackerServerPeerBase tRTrackerServerPeerBase) {
        try {
            this.this_mon.enter();
            if (tRTrackerServerPeerBase instanceof TRTrackerServerPeerImpl) {
                int n;
                TRTrackerServerPeerImpl tRTrackerServerPeerImpl = (TRTrackerServerPeerImpl)tRTrackerServerPeerBase;
                if (this.peer_map.containsKey(tRTrackerServerPeerImpl.getPeerId()) && (n = this.peer_list.indexOf(tRTrackerServerPeerImpl)) != -1) {
                    this.removePeer(tRTrackerServerPeerImpl, n, 7, null);
                }
            } else if (this.queued_peers != null) {
                this.queued_peers.remove(tRTrackerServerPeerBase);
                if (this.queued_peers.size() == 0) {
                    this.queued_peers = null;
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void removePeer(TRTrackerServerPeerImpl tRTrackerServerPeerImpl, int n, String string) {
        this.removePeer(tRTrackerServerPeerImpl, -1, n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePeer(TRTrackerServerPeerImpl tRTrackerServerPeerImpl, int n, int n2, String string) {
        try {
            TRTrackerServerPeerImpl tRTrackerServerPeerImpl2;
            this.this_mon.enter();
            if (tRTrackerServerPeerImpl.isIPOverride()) {
                --this.ip_override_count;
            }
            this.stats.removeLeft(tRTrackerServerPeerImpl.getAmountLeft());
            if (this.peer_map.size() != this.peer_reuse_map.size() && !this.map_size_diff_reported) {
                this.map_size_diff_reported = true;
                Debug.out("TRTrackerServerTorrent::removePeer: maps size different ( " + this.peer_map.size() + "/" + this.peer_reuse_map.size() + ")");
            }
            if ((tRTrackerServerPeerImpl2 = this.peer_map.remove(tRTrackerServerPeerImpl.getPeerId())) == null) {
                Debug.out(" TRTrackerServerTorrent::removePeer: peer_map doesn't contain peer");
            } else {
                try {
                    this.peerEvent(tRTrackerServerPeerImpl, n2, string);
                }
                catch (TRTrackerServerException tRTrackerServerException) {
                    // empty catch block
                }
            }
            if (n == -1) {
                int n3 = this.peer_list.indexOf(tRTrackerServerPeerImpl);
                if (n3 == -1) {
                    Debug.out(" TRTrackerServerTorrent::removePeer: peer_list doesn't contain peer");
                } else {
                    this.peer_list.set(n3, null);
                }
            } else if (this.peer_list.get(n) == tRTrackerServerPeerImpl) {
                this.peer_list.set(n, null);
            } else {
                Debug.out(" TRTrackerServerTorrent::removePeer: peer_list doesn't contain peer at index");
            }
            ++this.peer_list_hole_count;
            this.checkForPeerListCompaction(false);
            try {
                TRTrackerServerPeerImpl tRTrackerServerPeerImpl3 = this.peer_reuse_map.remove(new String(tRTrackerServerPeerImpl.getIPAsRead(), "ISO-8859-1") + ":" + tRTrackerServerPeerImpl.getTCPPort());
                if (tRTrackerServerPeerImpl3 == null) {
                    Debug.out(" TRTrackerServerTorrent::removePeer: peer_reuse_map doesn't contain peer");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (this.biased_peers != null) {
                this.biased_peers.remove(tRTrackerServerPeerImpl);
            }
            if (tRTrackerServerPeerImpl.isSeed()) {
                --this.seed_count;
            }
            ++this.removed_count;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBiasedPeers(Set set) {
        try {
            this.this_mon.enter();
            Iterator<TRTrackerServerPeerImpl> iterator = this.peer_list.iterator();
            if (iterator.hasNext() && this.biased_peers == null) {
                this.biased_peers = new ArrayList();
            }
            while (iterator.hasNext()) {
                TRTrackerServerPeerBase tRTrackerServerPeerBase = iterator.next();
                if (tRTrackerServerPeerBase == null) continue;
                boolean bl = set.contains(((TRTrackerServerPeerImpl)tRTrackerServerPeerBase).getIPRaw());
                ((TRTrackerServerPeerImpl)tRTrackerServerPeerBase).setBiased(bl);
                if (bl) {
                    if (this.biased_peers.contains(tRTrackerServerPeerBase)) continue;
                    this.biased_peers.add(tRTrackerServerPeerBase);
                    continue;
                }
                this.biased_peers.remove(tRTrackerServerPeerBase);
            }
            if (this.queued_peers != null) {
                for (TRTrackerServerPeerBase tRTrackerServerPeerBase : this.queued_peers) {
                    ((QueuedPeer)tRTrackerServerPeerBase).setBiased(set.contains(((QueuedPeer)tRTrackerServerPeerBase).getIP()));
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public TRTrackerServerTorrent addLink(String string) {
        return this.server.addLink(string, this);
    }

    @Override
    public void removeLink(String string) {
        this.server.removeLink(string, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map exportAnnounceToMap(String string, HashMap hashMap, TRTrackerServerPeerImpl tRTrackerServerPeerImpl, boolean bl, int n, long l, long l2, boolean bl2, byte by, byte by2, DHTNetworkPosition dHTNetworkPosition) {
        try {
            Object object;
            Object object2;
            Serializable serializable;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Iterator iterator;
            int n2;
            this.this_mon.enter();
            long l3 = SystemTime.getCurrentTime();
            boolean bl3 = tRTrackerServerPeerImpl != null && tRTrackerServerPeerImpl.getNATStatus() == 4;
            int n3 = this.peer_map.size();
            int n4 = TRTrackerServerImpl.getAnnounceCachePeriod();
            boolean bl4 = TRTrackerServerImpl.getSendPeerIds();
            if (bl2 || by != 0) {
                bl4 = false;
            }
            boolean bl5 = false;
            int n5 = TRTrackerServerImpl.getMaxPeersToSend();
            if (n < 0) {
                n = n3;
            }
            if (n5 > 0 && n > n5) {
                n = n5;
            }
            ArrayList<Object> arrayList = null;
            ArrayList<TRTrackerServerSimplePeer> arrayList2 = null;
            Set set = null;
            if (tRTrackerServerPeerImpl != null && this.peer_listeners != null) {
                for (n2 = 0; n2 < this.peer_listeners.size(); n2 += 1) {
                    try {
                        Object object7;
                        iterator = ((TRTrackerServerTorrentPeerListener)this.peer_listeners.get(n2)).eventOccurred(this, tRTrackerServerPeerImpl, 8, null);
                        if (iterator == null) continue;
                        object6 = (List)iterator.get("limited_peers");
                        if (object6 != null) {
                            if (arrayList == null) {
                                arrayList = new ArrayList<Object>();
                            }
                            for (int i = 0; i < object6.size(); ++i) {
                                Map map = (Map)object6.get(i);
                                object5 = (String)map.get("ip");
                                int n6 = ((Long)map.get("port")).intValue();
                                String string2 = (String)object5 + ":" + n6;
                                object7 = this.peer_reuse_map.get(string2);
                                if (object7 == null || arrayList.contains(object7)) continue;
                                arrayList.add(object7);
                            }
                        }
                        if ((object4 = (List)iterator.get("biased_peers")) != null) {
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList<TRTrackerServerSimplePeer>();
                            }
                            for (int i = 0; i < object4.size(); ++i) {
                                object5 = (Map)object4.get(i);
                                String string3 = (String)object5.get("ip");
                                int n7 = ((Long)object5.get("port")).intValue();
                                object7 = string3 + ":" + n7;
                                TRTrackerServerSimplePeer tRTrackerServerSimplePeer = this.peer_reuse_map.get(object7);
                                if (tRTrackerServerSimplePeer == null) {
                                    tRTrackerServerSimplePeer = new temporaryBiasedSeed(string3, n7);
                                }
                                if (arrayList2.contains(tRTrackerServerSimplePeer)) continue;
                                arrayList2.add(tRTrackerServerSimplePeer);
                            }
                        }
                        set = (Set)iterator.get("remove_ips");
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
            n2 = tRTrackerServerPeerImpl == null ? ((iterator = this.server.getBiasedPeers()) == null ? 0 : (int)(iterator.contains(string) ? 1 : 0)) : tRTrackerServerPeerImpl.isBiased();
            if (this.caching_enabled && arrayList == null && arrayList2 == null && !n2 && set == null && !bl3 && hashMap.size() == 0 && n4 > 0 && n >= 10 && n3 >= TRTrackerServerImpl.getAnnounceCachePeerThreshold() && by2 != 2) {
                dHTNetworkPosition = null;
                iterator = this.announce_cache.keySet().iterator();
                while (iterator.hasNext()) {
                    object6 = (Integer)iterator.next();
                    object4 = (announceCacheEntry)this.announce_cache.get(object6);
                    if (l3 - ((announceCacheEntry)object4).getTime() <= (long)n4) continue;
                    iterator.remove();
                }
                for (int i = n / 10; i > n / 20; --i) {
                    object4 = (announceCacheEntry)this.announce_cache.get(new Integer(i));
                    if (object4 == null) continue;
                    if (l3 - ((announceCacheEntry)object4).getTime() > (long)n4) {
                        this.announce_cache.remove(new Integer(i));
                        continue;
                    }
                    if (((announceCacheEntry)object4).getSendPeerIds() != bl4 || ((announceCacheEntry)object4).getCompactMode() != by) continue;
                    Map map = ((announceCacheEntry)object4).getData();
                    return map;
                }
                bl5 = true;
            }
            iterator = new LinkedList();
            if (n > 0 && arrayList == null) {
                if (n >= n3) {
                    for (int i = 0; i < this.peer_list.size(); ++i) {
                        object4 = this.peer_list.get(i);
                        if (object4 == null || object4 == tRTrackerServerPeerImpl) continue;
                        if (l3 > ((TRTrackerServerPeerImpl)object4).getTimeout()) {
                            this.removePeer((TRTrackerServerPeerImpl)object4, i, 5, null);
                            continue;
                        }
                        if (((TRTrackerServerPeerImpl)object4).getTCPPort() == 0 || by2 == 0 && ((TRTrackerServerPeerImpl)object4).getCryptoLevel() == 2 || set != null && set.contains(new String(((TRTrackerServerPeerImpl)object4).getIP())) || !bl && ((TRTrackerServerPeerImpl)object4).isSeed()) continue;
                        HashMap<String, Object> hashMap2 = new HashMap<String, Object>(3);
                        if (bl4) {
                            hashMap2.put("peer id", ((TRTrackerServerPeerImpl)object4).getPeerId().getHash());
                        }
                        if (by != 0) {
                            object5 = ((TRTrackerServerPeerImpl)object4).getIPAddressBytes();
                            if (object5 == null) continue;
                            hashMap2.put("ip", object5);
                            if (by >= 2) {
                                hashMap2.put("azver", new Long(((TRTrackerServerPeerImpl)object4).getAZVer()));
                                hashMap2.put("azudp", new Long(((TRTrackerServerPeerImpl)object4).getUDPPort()));
                                if (((TRTrackerServerPeerImpl)object4).isSeed()) {
                                    hashMap2.put("azhttp", new Long(((TRTrackerServerPeerImpl)object4).getHTTPPort()));
                                }
                                if (by >= 16) {
                                    hashMap2.put("ip", ((TRTrackerServerPeerImpl)object4).getIPAsRead());
                                } else {
                                    DHTNetworkPosition dHTNetworkPosition2;
                                    hashMap2.put("azup", new Long(((TRTrackerServerPeerImpl)object4).getUpSpeed()));
                                    if (((TRTrackerServerPeerImpl)object4).isBiased()) {
                                        hashMap2.put("azbiased", "");
                                    }
                                    if (dHTNetworkPosition != null && (dHTNetworkPosition2 = ((TRTrackerServerPeerImpl)object4).getNetworkPosition()) != null && dHTNetworkPosition.getPositionType() == dHTNetworkPosition2.getPositionType()) {
                                        hashMap2.put("azrtt", new Long((long)dHTNetworkPosition2.estimateRTT(dHTNetworkPosition)));
                                    }
                                }
                            }
                        } else {
                            hashMap2.put("ip", ((TRTrackerServerPeerImpl)object4).getIPAsRead());
                        }
                        hashMap2.put("port", new Long(((TRTrackerServerPeerImpl)object4).getTCPPort()));
                        if (by2 != 0) {
                            hashMap2.put("crypto_flag", new Long(((TRTrackerServerPeerImpl)object4).getCryptoLevel() == 2 ? 1L : 0L));
                        }
                        if (((TRTrackerServerPeerImpl)object4).isBiased()) {
                            ((LinkedList)((Object)iterator)).addFirst(hashMap2);
                            continue;
                        }
                        ((LinkedList)((Object)iterator)).addLast(hashMap2);
                    }
                } else {
                    int n8 = this.peer_list.size();
                    if (this.duplicate_peer_checker.length < n8) {
                        this.duplicate_peer_checker = new byte[n8 * 2];
                        this.duplicate_peer_checker_index = 1;
                    } else if (this.duplicate_peer_checker.length > n8 * 2) {
                        this.duplicate_peer_checker = new byte[3 * n8 / 2];
                        this.duplicate_peer_checker_index = 1;
                    } else {
                        this.duplicate_peer_checker_index = (byte)(this.duplicate_peer_checker_index + 1);
                        if (this.duplicate_peer_checker_index == 0) {
                            Arrays.fill(this.duplicate_peer_checker, (byte)0);
                            this.duplicate_peer_checker_index = 1;
                        }
                    }
                    boolean bl6 = false;
                    try {
                        int n9;
                        this.peer_list_compaction_suspended = true;
                        int n10 = 0;
                        int n11 = n9 = TRTrackerServerNATChecker.getSingleton().isEnabled() ? 0 : 1;
                        while (n9 < 2) {
                            int n12 = n * 2;
                            if (n * 3 > n3) {
                                ++n12;
                            }
                            int n13 = 0;
                            if (this.biased_peers != null) {
                                if (this.biased_peers.size() > 1) {
                                    Object e = this.biased_peers.remove(0);
                                    this.biased_peers.add(this.random.nextInt(this.biased_peers.size() + 1), e);
                                }
                                n13 = Math.min(this.min_biased_peers, this.biased_peers.size());
                            }
                            for (int i = 0; i < n12 && n10 < n; ++i) {
                                int n14;
                                if (n9 == 1 && i < n13) {
                                    object3 = (TRTrackerServerPeerImpl)this.biased_peers.get(i);
                                    n14 = -1;
                                } else {
                                    n14 = this.random.nextInt(n8);
                                    object3 = this.peer_list.get(n14);
                                    if (object3 == null || ((TRTrackerServerPeerImpl)object3).isBiased()) continue;
                                }
                                if (l3 > ((TRTrackerServerPeerImpl)object3).getTimeout()) {
                                    this.removePeer((TRTrackerServerPeerImpl)object3, 5, null);
                                    bl6 = true;
                                    continue;
                                }
                                if (tRTrackerServerPeerImpl == object3 || ((TRTrackerServerPeerImpl)object3).getTCPPort() == 0 || by2 == 0 && ((TRTrackerServerPeerImpl)object3).getCryptoLevel() == 2 || set != null && set.contains(new String(((TRTrackerServerPeerImpl)object3).getIP())) || !bl && ((TRTrackerServerPeerImpl)object3).isSeed()) continue;
                                boolean bl7 = ((TRTrackerServerPeerImpl)object3).isNATStatusBad();
                                if ((n9 != 0 || bl7) && n9 != 1 || n14 != -1 && this.duplicate_peer_checker[n14] == this.duplicate_peer_checker_index) continue;
                                if (n14 != -1) {
                                    this.duplicate_peer_checker[n14] = this.duplicate_peer_checker_index;
                                }
                                ++n10;
                                serializable = new HashMap(3);
                                if (bl4) {
                                    serializable.put("peer id", ((TRTrackerServerPeerImpl)object3).getPeerId().getHash());
                                }
                                if (by != 0) {
                                    byte[] byArray = ((TRTrackerServerPeerImpl)object3).getIPAddressBytes();
                                    if (byArray == null) continue;
                                    serializable.put("ip", byArray);
                                    if (by >= 2) {
                                        serializable.put("azver", new Long(((TRTrackerServerPeerImpl)object3).getAZVer()));
                                        serializable.put("azudp", new Long(((TRTrackerServerPeerImpl)object3).getUDPPort()));
                                        if (((TRTrackerServerPeerImpl)object3).isSeed()) {
                                            serializable.put("azhttp", new Long(((TRTrackerServerPeerImpl)object3).getHTTPPort()));
                                        }
                                        if (by >= 16) {
                                            serializable.put("ip", ((TRTrackerServerPeerImpl)object3).getIPAsRead());
                                        } else {
                                            serializable.put("azup", new Long(((TRTrackerServerPeerImpl)object3).getUpSpeed()));
                                            if (((TRTrackerServerPeerImpl)object3).isBiased()) {
                                                serializable.put("azbiased", "");
                                            }
                                            if (dHTNetworkPosition != null && (object2 = ((TRTrackerServerPeerImpl)object3).getNetworkPosition()) != null && dHTNetworkPosition.getPositionType() == object2.getPositionType()) {
                                                serializable.put("azrtt", new Long((long)object2.estimateRTT(dHTNetworkPosition)));
                                            }
                                        }
                                    }
                                } else {
                                    serializable.put("ip", ((TRTrackerServerPeerImpl)object3).getIPAsRead());
                                }
                                serializable.put("port", new Long(((TRTrackerServerPeerImpl)object3).getTCPPort()));
                                if (by2 != 0) {
                                    serializable.put("crypto_flag", new Long(((TRTrackerServerPeerImpl)object3).getCryptoLevel() == 2 ? 1L : 0L));
                                }
                                if (((TRTrackerServerPeerImpl)object3).isBiased()) {
                                    ((LinkedList)((Object)iterator)).addFirst((Serializable)serializable);
                                    continue;
                                }
                                ((LinkedList)((Object)iterator)).addLast((Serializable)serializable);
                            }
                            ++n9;
                        }
                    }
                    finally {
                        this.peer_list_compaction_suspended = false;
                        if (bl6) {
                            this.checkForPeerListCompaction(false);
                        }
                    }
                }
            }
            if (bl && arrayList == null && !bl4 && this.seed_count < 3 && this.queued_peers != null) {
                Iterator iterator2 = this.queued_peers.iterator();
                ArrayList<QueuedPeer> arrayList3 = new ArrayList<QueuedPeer>(3);
                while (iterator2.hasNext() && n > ((LinkedList)((Object)iterator)).size() && arrayList3.size() < 3) {
                    QueuedPeer queuedPeer = (QueuedPeer)iterator2.next();
                    if (queuedPeer.isTimedOut(l3)) {
                        iterator2.remove();
                        continue;
                    }
                    if (by2 == 0 && queuedPeer.getCryptoLevel() == 2 || set != null && set.contains(queuedPeer.getIP())) continue;
                    HashMap<String, Object> hashMap3 = new HashMap<String, Object>(3);
                    if (by != 0) {
                        byte[] byArray = queuedPeer.getIPAddressBytes();
                        if (byArray == null) continue;
                        hashMap3.put("ip", byArray);
                        if (by >= 2) {
                            hashMap3.put("azver", new Long(queuedPeer.getAZVer()));
                            hashMap3.put("azudp", new Long(queuedPeer.getUDPPort()));
                            if (queuedPeer.isSeed()) {
                                hashMap3.put("azhttp", new Long(queuedPeer.getHTTPPort()));
                            }
                            if (by >= 16) {
                                hashMap3.put("ip", queuedPeer.getIPAsRead());
                            }
                        }
                    } else {
                        hashMap3.put("ip", queuedPeer.getIPAsRead());
                    }
                    hashMap3.put("port", new Long(queuedPeer.getTCPPort()));
                    if (by2 != 0) {
                        hashMap3.put("crypto_flag", new Long(queuedPeer.getCryptoLevel() == 2 ? 1L : 0L));
                    }
                    ((LinkedList)((Object)iterator)).addLast(hashMap3);
                    arrayList3.add(queuedPeer);
                    iterator2.remove();
                }
                for (int i = 0; i < arrayList3.size(); ++i) {
                    this.queued_peers.add(arrayList3.get(i));
                }
            }
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            if (hashMap.size() > 0) {
                treeMap.putAll(hashMap);
            }
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    --n;
                    TRTrackerServerSimplePeer tRTrackerServerSimplePeer = (TRTrackerServerSimplePeer)arrayList.get(i);
                    this.exportPeer((LinkedList)((Object)iterator), tRTrackerServerSimplePeer, bl4, by, by2, dHTNetworkPosition);
                }
            }
            if (arrayList2 != null) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    --n;
                    TRTrackerServerSimplePeer tRTrackerServerSimplePeer = (TRTrackerServerSimplePeer)arrayList2.get(i);
                    this.exportPeer((LinkedList)((Object)iterator), tRTrackerServerSimplePeer, bl4, by, by2, dHTNetworkPosition);
                }
            }
            if (this.explicit_manual_biased_peers != null && tRTrackerServerPeerImpl != null && !tRTrackerServerPeerImpl.isSeed()) {
                Object[] objectArray = (Object[])this.explicit_manual_biased_peers.get(this.explicit_next_peer++);
                if (this.explicit_next_peer == this.explicit_manual_biased_peers.size()) {
                    this.explicit_next_peer = 0;
                }
                HashMap<String, Object> hashMap4 = new HashMap<String, Object>(3);
                if (bl4) {
                    byte[] byArray = new byte[20];
                    this.random.nextBytes(byArray);
                    hashMap4.put("peer id", byArray);
                }
                if (by != 0) {
                    byte[] byArray = (byte[])objectArray[1];
                    hashMap4.put("ip", byArray);
                    if (by >= 2) {
                        hashMap4.put("azver", new Long(0L));
                        hashMap4.put("azudp", new Long(0L));
                        hashMap4.put("azup", new Long(0L));
                        hashMap4.put("azbiased", "");
                    }
                } else {
                    hashMap4.put("ip", ((String)objectArray[0]).getBytes());
                }
                hashMap4.put("port", new Long(((Integer)objectArray[2]).intValue()));
                if (by2 != 0) {
                    hashMap4.put("crypto_flag", new Long(0L));
                }
                ((LinkedList)((Object)iterator)).addFirst(hashMap4);
            }
            int n15 = ((LinkedList)((Object)iterator)).size();
            Iterator iterator3 = ((AbstractSequentialList)((Object)iterator)).iterator();
            if (by == 2) {
                object = new byte[n15 * 9];
                int n16 = 0;
                while (iterator3.hasNext()) {
                    Map map = (Map)iterator3.next();
                    byte[] byArray = (byte[])map.get("ip");
                    int n17 = ((Long)map.get("port")).intValue();
                    int n18 = ((Long)map.get("azudp")).intValue();
                    Long l4 = (Long)map.get("crypto_flag");
                    byte by3 = l4 == null ? (byte)0 : l4.byteValue();
                    int n19 = n16 * 9;
                    System.arraycopy(byArray, 0, object, n19, 4);
                    n19 += 4;
                    object[n19++] = (byte)(n17 >> 8);
                    object[n19++] = (byte)(n17 & 0xFF);
                    object[n19++] = (byte)(n18 >> 8);
                    object[n19++] = (byte)(n18 & 0xFF);
                    object[n19++] = by3;
                    ++n16;
                }
                treeMap.put("peers", object);
                treeMap.put("azcompact", new Long(1L));
            } else if (by == 3) {
                object = new ArrayList(n15);
                while (iterator3.hasNext()) {
                    Long l5;
                    Long l6;
                    byte by4;
                    byte by5;
                    int n20;
                    Long l7;
                    Map map = (Map)iterator3.next();
                    HashMap<String, Object> hashMap5 = new HashMap<String, Object>();
                    object.add(hashMap5);
                    byte[] byArray = (byte[])map.get("ip");
                    hashMap5.put("i", byArray);
                    int n21 = ((Long)map.get("port")).intValue();
                    hashMap5.put("t", new byte[]{(byte)(n21 >> 8), (byte)(n21 & 0xFF)});
                    int n22 = ((Long)map.get("azudp")).intValue();
                    if (n22 != 0) {
                        if (n22 == n21) {
                            hashMap5.put("u", new byte[0]);
                        } else {
                            hashMap5.put("u", new byte[]{(byte)(n22 >> 8), (byte)(n22 & 0xFF)});
                        }
                    }
                    if ((l7 = (Long)map.get("azhttp")) != null && (n20 = l7.intValue()) != 0) {
                        hashMap5.put("h", new byte[]{(byte)(n20 >> 8), (byte)(n20 & 0xFF)});
                    }
                    byte by6 = by5 = (serializable = (Long)map.get("crypto_flag")) == null ? (byte)0 : ((Long)serializable).byteValue();
                    if (by5 != 0) {
                        hashMap5.put("c", new byte[]{by5});
                    }
                    byte by7 = by4 = (object2 = (Long)map.get("azver")) == null ? (byte)0 : ((Long)object2).byteValue();
                    if (by4 != 0) {
                        hashMap5.put("v", new Long(by4));
                    }
                    if ((l6 = (Long)map.get("azup")) != null && l6 != 0L) {
                        hashMap5.put("s", l6);
                    }
                    if ((l5 = (Long)map.get("azrtt")) != null) {
                        hashMap5.put("r", l5);
                    }
                    if (!map.containsKey("azbiased")) continue;
                    hashMap5.put("b", new Long(1L));
                }
                treeMap.put("peers", object);
                treeMap.put("azcompact", new Long(2L));
            } else if (by == 16) {
                object = new ArrayList(n15);
                while (iterator3.hasNext()) {
                    int n23;
                    Long l8;
                    Map map = (Map)iterator3.next();
                    HashMap hashMap6 = new HashMap();
                    object.add(hashMap6);
                    hashMap6.put("ip", map.get("ip"));
                    hashMap6.put("tcp", map.get("port"));
                    int n24 = ((Long)map.get("azudp")).intValue();
                    if (n24 != 0) {
                        hashMap6.put("udp", new Long(n24));
                    }
                    if ((l8 = (Long)map.get("azhttp")) == null || (n23 = l8.intValue()) == 0) continue;
                    hashMap6.put("http", new Long(n23));
                }
                treeMap.put("peers", object);
            } else {
                object = null;
                if (by2 != 0) {
                    object = new byte[n15];
                }
                if (by == 1) {
                    byte[] byArray = new byte[n15 * 6];
                    int n25 = 0;
                    int n26 = 0;
                    int n27 = 0;
                    while (iterator3.hasNext()) {
                        object3 = (Map)iterator3.next();
                        byte[] byArray2 = (byte[])object3.get("ip");
                        if (byArray2.length > 4) {
                            ++n27;
                        } else {
                            ++n26;
                            if (n27 == 0) {
                                int n28 = ((Long)object3.get("port")).intValue();
                                int n29 = n25 * 6;
                                System.arraycopy(byArray2, 0, byArray, n29, 4);
                                n29 += 4;
                                byArray[n29++] = (byte)(n28 >> 8);
                                byArray[n29++] = (byte)(n28 & 0xFF);
                            }
                        }
                        if (object != null) {
                            Long l9 = (Long)object3.remove("crypto_flag");
                            object[n25] = l9.byteValue();
                        }
                        ++n25;
                    }
                    if (n27 > 0) {
                        object3 = new byte[n26 * 6];
                        byte[] byArray3 = new byte[n27 * 18];
                        iterator3 = ((AbstractSequentialList)((Object)iterator)).iterator();
                        int n30 = 0;
                        int n31 = 0;
                        while (iterator3.hasNext()) {
                            int n32;
                            object2 = (Map)iterator3.next();
                            byte[] byArray4 = (byte[])object2.get("ip");
                            int n33 = ((Long)object2.get("port")).intValue();
                            if (byArray4.length > 4) {
                                n32 = n31 * 18;
                                System.arraycopy(byArray4, 0, byArray3, n32, 16);
                                n32 += 16;
                                byArray3[n32++] = (byte)(n33 >> 8);
                                byArray3[n32++] = (byte)(n33 & 0xFF);
                                ++n31;
                                continue;
                            }
                            n32 = n30 * 6;
                            System.arraycopy(byArray4, 0, object3, n32, 4);
                            n32 += 4;
                            object3[n32++] = (byte)(n33 >> 8);
                            object3[n32++] = (byte)(n33 & 0xFF);
                            ++n30;
                        }
                        if (((Object)object3).length > 0) {
                            treeMap.put("peers", object3);
                        }
                        if (byArray3.length > 0) {
                            treeMap.put("peers6", byArray3);
                        }
                    } else {
                        treeMap.put("peers", byArray);
                    }
                } else {
                    int n34 = 0;
                    while (iterator3.hasNext()) {
                        Map map = (Map)iterator3.next();
                        if (object != null) {
                            Long l10 = (Long)map.remove("crypto_flag");
                            object[n34] = l10.byteValue();
                        }
                        ++n34;
                    }
                    treeMap.put("peers", iterator);
                }
                if (object != null) {
                    treeMap.put("crypto_flags", object);
                }
            }
            treeMap.put("interval", new Long(l));
            treeMap.put("min interval", new Long(l2));
            if (bl3) {
                tRTrackerServerPeerImpl.setNATStatus((byte)5);
                treeMap.put("warning message", ("Unable to connect to your incoming data port (" + tRTrackerServerPeerImpl.getIP() + ":" + tRTrackerServerPeerImpl.getTCPPort() + "). " + "This will result in slow downloads. Please check your firewall/router settings").getBytes());
            }
            treeMap.put("complete", new Long(this.getSeedCountForScrape(n2 != 0)));
            treeMap.put("incomplete", new Long(this.getLeecherCount()));
            treeMap.put("downloaded", new Long(this.stats.getCompletedCount()));
            if (bl5) {
                this.announce_cache.put(new Integer((n15 + 9) / 10), new announceCacheEntry(treeMap, bl4, by));
            }
            object = treeMap;
            return object;
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void exportPeer(LinkedList linkedList, TRTrackerServerSimplePeer tRTrackerServerSimplePeer, boolean bl, byte by, byte by2, DHTNetworkPosition dHTNetworkPosition) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
        if (bl) {
            hashMap.put("peer id", tRTrackerServerSimplePeer.getPeerId().getHash());
        }
        if (by != 0) {
            byte[] byArray = tRTrackerServerSimplePeer.getIPAddressBytes();
            if (byArray == null) {
                return;
            }
            hashMap.put("ip", byArray);
            if (by >= 2) {
                hashMap.put("azver", new Long(tRTrackerServerSimplePeer.getAZVer()));
                hashMap.put("azudp", new Long(tRTrackerServerSimplePeer.getUDPPort()));
                if (tRTrackerServerSimplePeer.isSeed()) {
                    hashMap.put("azhttp", new Long(tRTrackerServerSimplePeer.getHTTPPort()));
                }
                if (by >= 16) {
                    hashMap.put("ip", tRTrackerServerSimplePeer.getIPAsRead());
                } else {
                    DHTNetworkPosition dHTNetworkPosition2;
                    hashMap.put("azup", new Long(tRTrackerServerSimplePeer.getUpSpeed()));
                    if (tRTrackerServerSimplePeer.isBiased()) {
                        hashMap.put("azbiased", "");
                    }
                    if (dHTNetworkPosition != null && (dHTNetworkPosition2 = tRTrackerServerSimplePeer.getNetworkPosition()) != null && dHTNetworkPosition.getPositionType() == dHTNetworkPosition2.getPositionType()) {
                        hashMap.put("azrtt", new Long((long)dHTNetworkPosition2.estimateRTT(dHTNetworkPosition)));
                    }
                }
            }
        } else {
            hashMap.put("ip", tRTrackerServerSimplePeer.getIPAsRead());
        }
        hashMap.put("port", new Long(tRTrackerServerSimplePeer.getTCPPort()));
        if (by2 != 0) {
            hashMap.put("crypto_flag", new Long(tRTrackerServerSimplePeer.getCryptoLevel() == 2 ? 1L : 0L));
        }
        if (tRTrackerServerSimplePeer.isBiased()) {
            linkedList.addFirst(hashMap);
        } else {
            linkedList.addLast(hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map exportScrapeToMap(String string, String string2, boolean bl) throws TRTrackerServerException {
        try {
            this.this_mon.enter();
            this.handleRedirects(string, string2, true);
            this.stats.addScrape();
            long l = SystemTime.getCurrentTime();
            long l2 = l - this.last_scrape_calc_time;
            if (bl && this.last_scrape != null && l2 < (long)TRTrackerServerImpl.getScrapeCachePeriod() && l2 >= 0L) {
                Map map = this.last_scrape;
                return map;
            }
            this.last_scrape = new TreeMap();
            this.last_scrape_calc_time = l;
            Set set = this.server.getBiasedPeers();
            boolean bl2 = set == null ? false : set.contains(string2);
            this.last_scrape.put("complete", new Long(this.getSeedCountForScrape(bl2)));
            this.last_scrape.put("incomplete", new Long(this.getLeecherCount()));
            this.last_scrape.put("downloaded", new Long(this.stats.getCompletedCount()));
            Map map = this.last_scrape;
            return map;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        try {
            Object object;
            this.this_mon.enter();
            long l = SystemTime.getCurrentTime();
            int n = 0;
            int n2 = 0;
            try {
                this.peer_list_compaction_suspended = true;
                for (int i = 0; i < this.peer_list.size(); ++i) {
                    object = this.peer_list.get(i);
                    if (object == null) continue;
                    if (l > ((TRTrackerServerPeerImpl)object).getTimeout()) {
                        this.removePeer((TRTrackerServerPeerImpl)object, i, 5, null);
                        continue;
                    }
                    if (((TRTrackerServerPeerImpl)object).isSeed()) {
                        ++n2;
                    }
                    if (!((TRTrackerServerPeerImpl)object).isNATStatusBad()) continue;
                    ++n;
                }
            }
            finally {
                this.peer_list_compaction_suspended = false;
            }
            this.bad_NAT_count = n;
            this.seed_count = n2;
            if (this.removed_count > 1000) {
                this.removed_count = 0;
                this.checkForPeerListCompaction(true);
                HashMap<HashWrapper, TRTrackerServerPeerImpl> hashMap = new HashMap<HashWrapper, TRTrackerServerPeerImpl>(this.peer_map);
                object = new HashMap<String, TRTrackerServerPeerImpl>(this.peer_reuse_map);
                this.peer_map = hashMap;
                this.peer_reuse_map = object;
            } else {
                this.checkForPeerListCompaction(false);
            }
            Iterator iterator = this.lightweight_seed_map.values().iterator();
            while (iterator.hasNext()) {
                object = (lightweightSeed)iterator.next();
                if (l <= ((lightweightSeed)object).getTimeout()) continue;
                iterator.remove();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void checkForPeerListCompaction(boolean bl) {
        if (this.peer_list_hole_count > 0 && !this.peer_list_compaction_suspended && (bl || this.peer_list_hole_count > this.peer_map.size() / 10)) {
            ArrayList<TRTrackerServerPeerImpl> arrayList = new ArrayList<TRTrackerServerPeerImpl>(this.peer_list.size() - this.peer_list_hole_count / 2);
            int n = 0;
            for (int i = 0; i < this.peer_list.size(); ++i) {
                TRTrackerServerPeerImpl tRTrackerServerPeerImpl = this.peer_list.get(i);
                if (tRTrackerServerPeerImpl == null) {
                    ++n;
                    continue;
                }
                arrayList.add(tRTrackerServerPeerImpl);
            }
            if (n != this.peer_list_hole_count) {
                Debug.out("TRTrackerTorrent:compactHoles: count mismatch");
            }
            this.peer_list = arrayList;
            this.peer_list_hole_count = 0;
        }
    }

    protected void updateXferStats(int n, int n2) {
        this.stats.addXferStats(n, n2);
    }

    @Override
    public TRTrackerServerTorrentStats getStats() {
        return this.stats;
    }

    protected int getPeerCount() {
        return this.peer_map.size() + this.lightweight_seed_map.size();
    }

    protected int getSeedCount() {
        if (this.seed_count < 0) {
            Debug.out("seed count negative");
        }
        return this.seed_count + this.lightweight_seed_map.size();
    }

    protected int getSeedCountForScrape(boolean bl) {
        int n;
        int n2 = this.getSeedCount();
        if (this.biased_peers != null && !bl) {
            n = 0;
            for (TRTrackerServerPeerImpl tRTrackerServerPeerImpl : this.biased_peers) {
                if (!tRTrackerServerPeerImpl.isSeed()) continue;
                --n2;
                ++n;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n > 0) {
                ++n2;
            }
        }
        if ((n = this.getQueuedCount()) > 0) {
            ++n2;
        }
        return n2;
    }

    protected int getLeecherCount() {
        int n = this.peer_map.size() - this.seed_count;
        return n < 0 ? 0 : n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TRTrackerServerPeer[] getPeers() {
        try {
            this.this_mon.enter();
            TRTrackerServerPeer[] tRTrackerServerPeerArray = new TRTrackerServerPeer[this.peer_map.size()];
            this.peer_map.values().toArray(tRTrackerServerPeerArray);
            TRTrackerServerPeer[] tRTrackerServerPeerArray2 = tRTrackerServerPeerArray;
            return tRTrackerServerPeerArray2;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected int getQueuedCount() {
        LinkedList linkedList = this.queued_peers;
        if (linkedList == null) {
            return 0;
        }
        return linkedList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TRTrackerServerPeerBase[] getQueuedPeers() {
        try {
            this.this_mon.enter();
            if (this.queued_peers == null) {
                TRTrackerServerPeerBase[] tRTrackerServerPeerBaseArray = new TRTrackerServerPeerBase[]{};
                return tRTrackerServerPeerBaseArray;
            }
            TRTrackerServerPeerBase[] tRTrackerServerPeerBaseArray = new TRTrackerServerPeerBase[this.queued_peers.size()];
            this.queued_peers.toArray(tRTrackerServerPeerBaseArray);
            TRTrackerServerPeerBase[] tRTrackerServerPeerBaseArray2 = tRTrackerServerPeerBaseArray;
            return tRTrackerServerPeerBaseArray2;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public HashWrapper getHash() {
        return this.hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExplicitBiasedPeer(String string, int n) {
        byte[] byArray = HostNameToIPResolver.hostAddressToBytes(string);
        if (byArray != null) {
            try {
                this.this_mon.enter();
                if (this.explicit_manual_biased_peers == null) {
                    this.explicit_manual_biased_peers = new ArrayList();
                }
                this.explicit_manual_biased_peers.add(new Object[]{string, byArray, new Integer(n)});
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRedirects(URL[] uRLArray) {
        try {
            this.this_mon.enter();
            this.redirects = uRLArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public URL[] getRedirects() {
        return this.redirects;
    }

    protected void handleRedirects(String string, String string2, boolean bl) throws TRTrackerServerException {
        if (this.redirects != null) {
            if (string.indexOf("permredirect") != -1) {
                Debug.out("redirect recursion");
                throw new TRTrackerServerException("redirection recursion not supported");
            }
            URL uRL = this.redirects[string2.hashCode() % this.redirects.length];
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string3 = uRL.toString();
            if (bl) {
                int n = string3.indexOf("/announce");
                if (n == -1) {
                    return;
                }
                string3 = string3.substring(0, n) + "/scrape" + string3.substring(n + 9);
            }
            string3 = string3.indexOf(63) == -1 ? string3 + "?" : string3 + "&";
            string3 = string3 + "permredirect=1";
            if (string.length() > 0) {
                string3 = string3 + "&" + string;
            }
            System.out.println("redirect -> " + string3);
            hashMap.put("Location", string3);
            throw new TRTrackerServerException(301, "Moved Permanently", hashMap);
        }
    }

    @Override
    public void addListener(TRTrackerServerTorrentListener tRTrackerServerTorrentListener) {
        this.listeners.add(tRTrackerServerTorrentListener);
        if (this.deleted) {
            tRTrackerServerTorrentListener.deleted(this);
        }
    }

    @Override
    public void removeListener(TRTrackerServerTorrentListener tRTrackerServerTorrentListener) {
        this.listeners.remove(tRTrackerServerTorrentListener);
    }

    protected void peerEvent(TRTrackerServerPeer tRTrackerServerPeer, int n, String string) throws TRTrackerServerException {
        if (this.peer_listeners != null) {
            for (int i = 0; i < this.peer_listeners.size(); ++i) {
                try {
                    ((TRTrackerServerTorrentPeerListener)this.peer_listeners.get(i)).eventOccurred(this, tRTrackerServerPeer, n, string);
                    continue;
                }
                catch (TRTrackerServerException tRTrackerServerException) {
                    throw tRTrackerServerException;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    @Override
    public void addPeerListener(TRTrackerServerTorrentPeerListener tRTrackerServerTorrentPeerListener) {
        if (this.peer_listeners == null) {
            this.peer_listeners = new ArrayList();
        }
        this.peer_listeners.add(tRTrackerServerTorrentPeerListener);
    }

    @Override
    public void removePeerListener(TRTrackerServerTorrentPeerListener tRTrackerServerTorrentPeerListener) {
        if (this.peer_listeners != null) {
            this.peer_listeners.remove(tRTrackerServerTorrentPeerListener);
        }
    }

    @Override
    public void disableCaching() {
        this.caching_enabled = false;
    }

    public boolean isCachingEnabled() {
        return this.caching_enabled;
    }

    public int getBadNATPeerCount() {
        return this.bad_NAT_count;
    }

    protected void delete() {
        this.deleted = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TRTrackerServerTorrentListener)this.listeners.get(i)).deleted(this);
        }
    }

    @Override
    public String getString() {
        String string;
        if (this.redirects == null) {
            string = "none";
        } else {
            string = "";
            for (int i = 0; i < this.redirects.length; ++i) {
                string = string + (i == 0 ? "" : ",") + this.redirects[i];
            }
        }
        return "seeds=" + this.getSeedCount() + ",leechers=" + this.getLeecherCount() + ", redirect=" + string;
    }

    protected class temporaryBiasedSeed
    implements TRTrackerServerSimplePeer {
        private String ip;
        private int tcp_port;
        private HashWrapper peer_id;

        protected temporaryBiasedSeed(String string, int n) {
            this.ip = string;
            this.tcp_port = n;
            this.peer_id = new HashWrapper(RandomUtils.nextHash());
        }

        @Override
        public byte[] getIPAsRead() {
            try {
                return this.ip.getBytes("ISO-8859-1");
            }
            catch (Throwable throwable) {
                return this.ip.getBytes();
            }
        }

        @Override
        public byte[] getIPAddressBytes() {
            try {
                return InetAddress.getByName(this.ip).getAddress();
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Override
        public HashWrapper getPeerId() {
            return this.peer_id;
        }

        @Override
        public int getTCPPort() {
            return this.tcp_port;
        }

        @Override
        public int getUDPPort() {
            return 0;
        }

        @Override
        public int getHTTPPort() {
            return 0;
        }

        @Override
        public boolean isSeed() {
            return true;
        }

        @Override
        public boolean isBiased() {
            return true;
        }

        @Override
        public byte getCryptoLevel() {
            return 0;
        }

        @Override
        public byte getAZVer() {
            return 0;
        }

        @Override
        public int getUpSpeed() {
            return 0;
        }

        @Override
        public DHTNetworkPosition getNetworkPosition() {
            return null;
        }
    }

    protected static class QueuedPeer
    implements TRTrackerServerPeerBase {
        private static final byte FLAG_SEED = 1;
        private static final byte FLAG_BIASED = 2;
        private short tcp_port;
        private short udp_port;
        private short http_port;
        private byte[] ip;
        private byte crypto_level;
        private byte az_ver;
        private int create_time_secs;
        private int timeout_secs;
        private byte flags;

        protected QueuedPeer(String string, int n, int n2, int n3, byte by, byte by2, int n4, boolean bl, boolean bl2) {
            try {
                this.ip = string.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Debug.printStackTrace(unsupportedEncodingException);
            }
            this.tcp_port = (short)n;
            this.udp_port = (short)n2;
            this.http_port = (short)n3;
            this.crypto_level = by;
            this.az_ver = by2;
            this.setFlag((byte)1, bl);
            this.setFlag((byte)2, bl2);
            this.create_time_secs = (int)(SystemTime.getCurrentTime() / 1000L);
            this.timeout_secs = n4 * 3;
        }

        protected boolean sameAs(TRTrackerServerPeerImpl tRTrackerServerPeerImpl) {
            return this.tcp_port == tRTrackerServerPeerImpl.getTCPPort() && Arrays.equals(this.ip, tRTrackerServerPeerImpl.getIPAsRead()) && this.isIPOverride() == tRTrackerServerPeerImpl.isIPOverride();
        }

        protected boolean sameAs(QueuedPeer queuedPeer) {
            return this.tcp_port == queuedPeer.tcp_port && Arrays.equals(this.ip, queuedPeer.ip);
        }

        protected byte[] getIPAsRead() {
            return this.ip;
        }

        @Override
        public String getIP() {
            try {
                return new String(this.ip, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(this.ip);
            }
        }

        protected boolean isSeed() {
            return this.getFlag((byte)1);
        }

        protected void setBiased(boolean bl) {
            this.setFlag((byte)2, bl);
        }

        protected boolean isBiased() {
            return this.getFlag((byte)2);
        }

        protected boolean isIPOverride() {
            return false;
        }

        protected void setFlag(byte by, boolean bl) {
            this.flags = bl ? (byte)(this.flags | by) : (byte)(this.flags & ~by);
        }

        protected boolean getFlag(byte by) {
            return (this.flags & by) != 0;
        }

        protected byte[] getIPAddressBytes() {
            try {
                return HostNameToIPResolver.hostAddressToBytes(new String(this.ip, "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Debug.printStackTrace(unsupportedEncodingException);
                return null;
            }
        }

        @Override
        public int getTCPPort() {
            return this.tcp_port & 0xFFFF;
        }

        public int getUDPPort() {
            return this.udp_port & 0xFFFF;
        }

        @Override
        public int getHTTPPort() {
            return this.http_port & 0xFFFF;
        }

        protected byte getCryptoLevel() {
            return this.crypto_level;
        }

        protected byte getAZVer() {
            return this.az_ver;
        }

        protected int getCreateTime() {
            return this.create_time_secs;
        }

        protected boolean isTimedOut(long l) {
            int n = (int)(l / 1000L);
            if (n < this.create_time_secs) {
                this.create_time_secs = n;
            }
            return this.create_time_secs + this.timeout_secs < n;
        }

        @Override
        public int getSecsToLive() {
            int n = (int)(SystemTime.getCurrentTime() / 1000L);
            if (n < this.create_time_secs) {
                this.create_time_secs = n;
            }
            return this.create_time_secs + this.timeout_secs - n;
        }

        protected String getString() {
            return new String(this.ip) + ":" + this.getTCPPort() + "/" + this.getUDPPort() + "/" + this.getCryptoLevel();
        }
    }

    protected static class lightweightSeed {
        long timeout;
        long last_contact_time;
        long uploaded;
        byte nat_status;

        protected lightweightSeed(long l, long l2, long l3, byte by) {
            this.last_contact_time = l;
            this.timeout = l2;
            this.uploaded = l3;
            this.nat_status = by;
        }

        protected long getTimeout() {
            return this.timeout;
        }

        protected long getLastContactTime() {
            return this.last_contact_time;
        }

        protected long getUploaded() {
            return this.uploaded;
        }

        protected byte getNATStatus() {
            return this.nat_status;
        }
    }

    static class announceCacheEntry {
        protected Map data;
        protected boolean send_peer_ids;
        protected byte compact_mode;
        protected long time;

        protected announceCacheEntry(Map map, boolean bl, byte by) {
            this.data = map;
            this.send_peer_ids = bl;
            this.compact_mode = by;
            this.time = SystemTime.getCurrentTime();
        }

        protected boolean getSendPeerIds() {
            return this.send_peer_ids;
        }

        protected byte getCompactMode() {
            return this.compact_mode;
        }

        protected long getTime() {
            return this.time;
        }

        protected Map getData() {
            return this.data;
        }
    }
}

