/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.util.AENetworkClassifierListener;
import org.gudy.azureus2.core3.util.Debug;

public class AENetworkClassifier {
    public static final String AT_PUBLIC = "Public";
    public static final String AT_I2P = "I2P";
    public static final String AT_TOR = "Tor";
    public static final String[] AT_NETWORKS = new String[]{"Public", "I2P", "Tor"};
    private static List listeners = new ArrayList();

    public static String categoriseAddress(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return AT_PUBLIC;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        if (string2.equals("i2p")) {
            return AT_I2P;
        }
        if (string2.equals("onion")) {
            return AT_TOR;
        }
        return AT_PUBLIC;
    }

    public static String[] getNetworks(TOTorrent tOTorrent, String string) {
        String[] stringArray;
        int n;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.add(tOTorrent.getAnnounceURL());
        TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = tOTorrent.getAnnounceURLGroup().getAnnounceURLSets();
        for (int i = 0; i < tOTorrentAnnounceURLSetArray.length; ++i) {
            URL[] uRLArray = tOTorrentAnnounceURLSetArray[i].getAnnounceURLs();
            for (int j = 0; j < uRLArray.length; ++j) {
                arrayList.add(uRLArray[j]);
            }
        }
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        for (n = 0; n < arrayList.size(); ++n) {
            URL uRL = (URL)arrayList.get(n);
            stringArray = AENetworkClassifier.categoriseAddress(uRL.getHost());
            if (arrayList2.contains(stringArray)) continue;
            arrayList2.add(stringArray);
        }
        if (arrayList2.size() == 1 && arrayList2.get(0) == AT_PUBLIC) {
            return new String[]{AT_PUBLIC};
        }
        n = COConfigurationManager.getBooleanParameter("Network Selection Prompt") ? 1 : 0;
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (n != 0 && listeners.size() > 0) {
            stringArray = new String[arrayList2.size()];
            arrayList2.toArray(stringArray);
            for (int i = 0; i < listeners.size(); ++i) {
                try {
                    String[] stringArray2 = ((AENetworkClassifierListener)listeners.get(i)).selectNetworks(string, stringArray);
                    if (stringArray2 == null) continue;
                    for (int j = 0; j < stringArray2.length; ++j) {
                        arrayList3.add(stringArray2[j]);
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        } else {
            for (int i = 0; i < arrayList2.size(); ++i) {
                if (!COConfigurationManager.getBooleanParameter("Network Selection Default." + arrayList2.get(i))) continue;
                arrayList3.add((String)arrayList2.get(i));
            }
        }
        String[] stringArray3 = new String[arrayList3.size()];
        arrayList3.toArray(stringArray3);
        return stringArray3;
    }

    public static void addListener(AENetworkClassifierListener aENetworkClassifierListener) {
        listeners.add(aENetworkClassifierListener);
    }

    public static void removeListener(AENetworkClassifierListener aENetworkClassifierListener) {
        listeners.remove(aENetworkClassifierListener);
    }
}

