/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class TimerEvent
extends ThreadPoolTask
implements Comparable {
    private String name;
    private Timer timer;
    private long created;
    private long when;
    private TimerEventPerformer performer;
    private boolean absolute;
    private boolean cancelled;
    private boolean has_run;
    private long unique_id = 1L;

    protected TimerEvent(Timer timer, long l, long l2, long l3, boolean bl, TimerEventPerformer timerEventPerformer) {
        this.timer = timer;
        this.unique_id = l;
        this.when = l3;
        this.absolute = bl;
        this.performer = timerEventPerformer;
        this.created = l2;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public long getCreatedTime() {
        return this.created;
    }

    public long getWhen() {
        return this.when;
    }

    protected void setWhen(long l) {
        this.when = l;
    }

    protected AERunnable getRunnable() {
        return this;
    }

    protected TimerEventPerformer getPerformer() {
        return this.performer;
    }

    protected boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public void runSupport() {
        this.performer.perform(this);
    }

    public synchronized void cancel() {
        this.cancelled = true;
        this.timer.cancelEvent(this);
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected void setHasRun() {
        this.has_run = true;
    }

    public boolean hasRun() {
        return this.has_run;
    }

    protected long getUniqueId() {
        return this.unique_id;
    }

    public int compareTo(Object object) {
        long l = this.when - ((TimerEvent)object).getWhen();
        if (l == 0L) {
            return (int)(this.unique_id - ((TimerEvent)object).getUniqueId());
        }
        return l < 0L ? -1 : 1;
    }

    @Override
    public void interruptTask() {
    }

    public String getString() {
        if (this.performer instanceof TimerEventPeriodic) {
            TimerEventPeriodic timerEventPeriodic = (TimerEventPeriodic)this.performer;
            return "when=" + this.getWhen() + ",run=" + this.hasRun() + ", can=" + this.isCancelled() + "/" + timerEventPeriodic.isCancelled() + ",freq=" + timerEventPeriodic.getFrequency() + ",target=" + timerEventPeriodic.getPerformer() + (this.name == null ? "" : ",name=" + this.name);
        }
        return "when=" + this.getWhen() + ",run=" + this.hasRun() + ", can=" + this.isCancelled() + ",target=" + this.getPerformer() + (this.name == null ? "" : ",name=" + this.name);
    }
}

