/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;

public class TrackersUtil {
    private List trackers = new ArrayList();
    private Map multiTrackers = new HashMap();
    private Map webseeds = new HashMap();
    private static TrackersUtil instance;
    private static AEMonitor class_mon;

    private TrackersUtil() {
        this.loadList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrackersUtil getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new TrackersUtil();
            }
            TrackersUtil trackersUtil = instance;
            return trackersUtil;
        }
        finally {
            class_mon.exit();
        }
    }

    public List getTrackersList() {
        if (this.trackers != null) {
            return new ArrayList(this.trackers);
        }
        return null;
    }

    public void addTracker(String string) {
        if (this.trackers.contains(string)) {
            return;
        }
        this.trackers.add(0, string);
        this.saveList();
    }

    public void addMultiTracker(String string, List list) {
        this.multiTrackers.put(string, list);
        this.saveList();
    }

    public void removeMultiTracker(String string) {
        this.multiTrackers.remove(string);
        this.saveList();
    }

    public Map getMultiTrackers() {
        return new HashMap(this.multiTrackers);
    }

    public void addWebSeed(String string, Map map) {
        this.webseeds.put(string, map);
        this.saveList();
    }

    public void removeWebSeed(String string) {
        this.webseeds.remove(string);
        this.saveList();
    }

    public Map getWebSeeds() {
        return new HashMap(this.webseeds);
    }

    public void clearAllTrackers(boolean bl) {
        this.trackers = new ArrayList();
        this.multiTrackers = new HashMap();
        this.webseeds = new HashMap();
        if (bl) {
            this.saveList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadList() {
        File file = FileUtil.getUserFile("trackers.config");
        if (file.exists() && file.isFile()) {
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                Object object;
                fileInputStream = new FileInputStream(file);
                bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
                Map map = BDecoder.decode(bufferedInputStream);
                List list = (List)map.get("trackers");
                if (list != null) {
                    object = list.iterator();
                    while (object.hasNext()) {
                        String string = new String((byte[])object.next());
                        this.trackers.add(string);
                    }
                }
                if ((object = (Map)map.get("multi-trackers")) != null) {
                    for (String string : object.keySet()) {
                        List list2 = (List)object.get(string);
                        ArrayList arrayList = new ArrayList(list2.size());
                        for (List list3 : list2) {
                            ArrayList<String> arrayList2 = new ArrayList<String>(list3.size());
                            Iterator iterator = list3.iterator();
                            while (iterator.hasNext()) {
                                String string2 = new String((byte[])iterator.next());
                                arrayList2.add(string2);
                            }
                            arrayList.add(arrayList2);
                        }
                        this.multiTrackers.put(string, arrayList);
                    }
                }
                this.webseeds = (Map)map.get("webseeds");
                if (this.webseeds == null) {
                    this.webseeds = new HashMap();
                } else {
                    BDecoder.decodeStrings(this.webseeds);
                }
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveList() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("trackers", this.trackers);
        hashMap.put("multi-trackers", this.multiTrackers);
        hashMap.put("webseeds", this.webseeds);
        FileOutputStream fileOutputStream = null;
        try {
            File file = FileUtil.getUserFile("trackers.config");
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(BEncoder.encode(hashMap));
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    static {
        class_mon = new AEMonitor("TrackersUtil:class");
    }
}

