/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.xml.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;

public class XUXmlWriter {
    private static final int INDENT_AMOUNT = 4;
    private String current_indent_string;
    private PrintWriter writer;
    private boolean generic_simple;

    protected XUXmlWriter() {
        this.resetIndent();
    }

    protected XUXmlWriter(OutputStream outputStream) {
        this.setOutputStream(outputStream);
        this.resetIndent();
    }

    protected void setOutputStream(OutputStream outputStream) {
        try {
            this.writer = new PrintWriter(new OutputStreamWriter(outputStream, "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.printStackTrace(unsupportedEncodingException);
            this.writer = new PrintWriter(outputStream);
        }
    }

    protected void setOutputWriter(Writer writer) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    protected void setGenericSimple(boolean bl) {
        this.generic_simple = bl;
    }

    protected void writeTag(String string, String string2) {
        this.writeLineRaw("<" + string + ">" + XUXmlWriter.escapeXML(string2) + "</" + string + ">");
    }

    protected void writeTag(String string, long l) {
        this.writeLineRaw("<" + string + ">" + l + "</" + string + ">");
    }

    protected void writeTag(String string, boolean bl) {
        this.writeLineRaw("<" + string + ">" + (bl ? "YES" : "NO") + "</" + string + ">");
    }

    protected void writeLineRaw(String string) {
        this.writer.println(this.current_indent_string + string);
    }

    protected void writeLineEscaped(String string) {
        this.writer.println(this.current_indent_string + XUXmlWriter.escapeXML(string));
    }

    protected void resetIndent() {
        this.current_indent_string = "";
    }

    protected void indent() {
        for (int i = 0; i < 4; ++i) {
            this.current_indent_string = this.current_indent_string + " ";
        }
    }

    protected void exdent() {
        this.current_indent_string = this.current_indent_string.length() >= 4 ? this.current_indent_string.substring(0, this.current_indent_string.length() - 4) : "";
    }

    public static String escapeXML(String string) {
        if (string == null) {
            return "";
        }
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("'", "&apos;");
        string = string.replaceAll("--", "&#45;&#45;");
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c > '\u001f' && (c < '\u007f' || c > '\u009f') && Character.isDefined((int)c)) continue;
            cArray[i] = 63;
        }
        return new String(cArray);
    }

    public static String unescapeXML(String string) {
        if (string == null) {
            return "";
        }
        string = string.replaceAll("&gt;", ">");
        string = string.replaceAll("&lt;", "<");
        string = string.replaceAll("&quot;", "\"");
        string = string.replaceAll("&apos;", "'");
        string = string.replaceAll("&#45;&#45;", "--");
        string = string.replaceAll("&amp;", "&");
        return string;
    }

    public static String[] splitWithEscape(String string, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c2 = cArray[i];
            if (c2 == '\\' && i + 1 < cArray.length && cArray[i + 1] == c) {
                string2 = string2 + c;
                ++i;
                continue;
            }
            if (c2 == c) {
                if (string2.length() <= 0) continue;
                arrayList.add(string2);
                string2 = "";
                continue;
            }
            string2 = string2 + c2;
        }
        if (string2.length() > 0) {
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void flushOutputStream() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    protected void closeOutputStream() {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeGenericMapEntry(String string, Object object) {
        if (this.generic_simple) {
            string = string.replace(' ', '_').toUpperCase();
            this.writeLineRaw("<" + string + ">");
            try {
                this.indent();
                this.writeGeneric(object);
            }
            finally {
                this.exdent();
            }
            this.writeLineRaw("</" + string + ">");
        } else {
            this.writeLineRaw("<KEY name=\"" + XUXmlWriter.escapeXML(string) + "\">");
            try {
                this.indent();
                this.writeGeneric(object);
            }
            finally {
                this.exdent();
            }
            this.writeLineRaw("</KEY>");
        }
    }

    protected void writeGeneric(Object object) {
        if (object instanceof Map) {
            this.writeGeneric((Map)object);
        } else if (object instanceof List) {
            this.writeGeneric((List)object);
        } else if (object instanceof String) {
            this.writeGeneric((String)object);
        } else if (object instanceof byte[]) {
            this.writeGeneric((byte[])object);
        } else {
            this.writeGeneric((Long)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeGeneric(Map map) {
        this.writeLineRaw("<MAP>");
        try {
            this.indent();
            for (String string : map.keySet()) {
                this.writeGenericMapEntry(string, map.get(string));
            }
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</MAP>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeGeneric(List list) {
        this.writeLineRaw("<LIST>");
        try {
            this.indent();
            for (int i = 0; i < list.size(); ++i) {
                this.writeGeneric(list.get(i));
            }
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</LIST>");
    }

    protected void writeGeneric(byte[] byArray) {
        if (this.generic_simple) {
            try {
                this.writeLineRaw(XUXmlWriter.escapeXML(new String(byArray, "UTF-8")));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            this.writeTag("BYTES", this.encodeBytes(byArray));
        }
    }

    protected void writeGeneric(String string) {
        if (this.generic_simple) {
            try {
                this.writeLineRaw(XUXmlWriter.escapeXML(string));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            this.writeTag("STRING", string);
        }
    }

    protected void writeGeneric(Long l) {
        if (this.generic_simple) {
            this.writeLineRaw(l.toString());
        } else {
            this.writeTag("LONG", "" + l);
        }
    }

    protected void writeTag(String string, byte[] byArray) {
        this.writeLineRaw("<" + string + ">" + this.encodeBytes(byArray) + "</" + string + ">");
    }

    protected void writeLocalisableTag(String string, byte[] byArray) {
        boolean bl = true;
        String string2 = null;
        try {
            string2 = new String(byArray, "UTF8");
            if (Arrays.equals(byArray, string2.getBytes("UTF8"))) {
                bl = false;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.writeLineRaw("<" + string + " encoding=\"" + (bl ? "bytes" : "utf8") + "\">" + (bl ? this.encodeBytes(byArray) : XUXmlWriter.escapeXML(string2)) + "</" + string + ">");
    }

    protected String encodeBytes(byte[] byArray) {
        String string = ByteFormatter.nicePrint(byArray, true);
        return string;
    }

    protected String getUTF(byte[] byArray) {
        try {
            return new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.printStackTrace(unsupportedEncodingException);
            return "";
        }
    }
}

