/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.macosx;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.gudy.azureus2.core3.util.FileUtil;

public class PListEditor {
    private String plistFile;

    public PListEditor(String string) throws IOException {
        this.plistFile = string;
        File file = new File(string);
        if (!file.exists()) {
            throw new IOException("plist file '" + file + "' doesn't exist");
        }
        if (!file.canWrite()) {
            throw new IOException("plist file '" + file + "' is read only");
        }
    }

    public void setFileTypeExtensions(String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("(?s).*?<key>CFBundleDocumentTypes</key>\\s*<array>.*?<key>CFBundleTypeExtensions</key>\\s*<array>");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("\n\t\t\t\t<string>");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("</string>");
            stringBuffer2.append(".*?");
            stringBuffer2.append(stringArray[i]);
        }
        stringBuffer.append("\n\t\t\t");
        stringBuffer2.append(".*?</array>.*");
        String string = "(?s)(<key>CFBundleDocumentTypes</key>\\s*<array>.*?<key>CFBundleTypeExtensions</key>\\s*<array>)(.*?)(</array>)";
        this.setValue(stringBuffer2.toString(), string, stringBuffer.toString());
    }

    public void setSimpleStringValue(String string, String string2) throws IOException {
        String string3 = "(?s).*?<key>" + string + "</key>\\s*" + "<string>" + string2 + "</string>.*";
        String string4 = "(?s)(<key>" + string + "</key>\\s*" + "<string>)(.*?)(</string>)";
        this.setValue(string3, string4, string2);
    }

    public void setArrayValues(String string, String string2, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("(?s).*?<key>" + string + "</key>\\s*" + "<array>");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer2.append("\\s*<" + string2 + ">" + stringArray[i] + "</" + string2 + ">");
            stringBuffer.append("\n\t\t\t\t<" + string2 + ">");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("</" + string2 + ">");
        }
        stringBuffer2.append("\\s*</array>.*");
        stringBuffer.append("\n\t\t\t");
        String string3 = "(?s)(<key>" + string + "</key>\\s*<array>)(.*?)(</array>)";
        this.setValue(stringBuffer2.toString(), string3, stringBuffer.toString());
    }

    private boolean isValuePresent(String string) throws IOException {
        String string2 = this.getFileContent();
        return string2.matches(string);
    }

    private void setValue(String string, String string2, String string3) throws IOException {
        String string4 = this.getFileContent();
        if (!this.isValuePresent(string)) {
            string4 = string4.replaceFirst(string2, "$1" + string3 + "$3");
            this.setFileContent(string4);
            this.touchFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContent() throws IOException {
        try (FileReader fileReader = null;){
            String string;
            fileReader = new FileReader(this.plistFile);
            int n = 32768;
            char[] cArray = new char[n];
            int n2 = 0;
            int n3 = 0;
            while ((n3 = fileReader.read(cArray, n2, n - n2)) > 0) {
                n2 += n3;
            }
            String string2 = string = new String(cArray, 0, n2);
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFileContent(String string) throws IOException {
        Object object;
        File file = new File(this.plistFile);
        File file2 = new File(this.plistFile + ".bak");
        if (file.exists() && !FileUtil.copyFile(file, file2)) {
            throw new IOException("Failed to backup plist file prior to modification");
        }
        boolean bl = false;
        try {
            object = null;
            try {
                object = new FileWriter(this.plistFile);
                ((Writer)object).write(string);
            }
            finally {
                if (object != null) {
                    ((OutputStreamWriter)object).close();
                    bl = true;
                }
            }
        }
        finally {
            if (bl) {
                file2.delete();
            } else if (file2.exists()) {
                object = new File(this.plistFile + ".bad");
                file.renameTo((File)object);
                file.delete();
                file2.renameTo(file);
            }
        }
    }

    public void touchFile() {
        File file = new File(this.plistFile);
        for (int i = 0; i <= 2; ++i) {
            if (file != null) {
                String[] stringArray = new String[]{"touch", file.getAbsolutePath()};
                try {
                    Runtime.getRuntime().exec(stringArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            file = file.getParentFile();
        }
    }

    public static void main(String[] stringArray) {
        try {
            PListEditor pListEditor = new PListEditor("/Applications/Vuze.app/Contents/Info.plist");
            pListEditor.setFileTypeExtensions(new String[]{"torrent", "tor", "vuze", "vuz"});
            pListEditor.setSimpleStringValue("CFBundleName", "Vuze");
            pListEditor.setSimpleStringValue("CFBundleTypeName", "Vuze Download");
            pListEditor.setSimpleStringValue("CFBundleGetInfoString", "Vuze");
            pListEditor.setArrayValues("CFBundleURLSchemes", "string", new String[]{"magnet", "dht"});
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

