/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.disk;

import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PieceRTAProvider;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerFileInfoImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class DiskManagerChannelImpl
implements DiskManagerChannel,
DiskManagerFileInfoListener,
DownloadManagerPeerListener,
PieceRTAProvider {
    private static int DEFAULT_BUFFER_MILLIS;
    private static int DEFAULT_MIN_PIECES_TO_BUFFER;
    private static final boolean TRACE = false;
    private static final int COMPACT_DELAY = 32;
    private static final int MAX_READ_CHUNK_DEFAULT = 65536;
    private static final Comparator<dataEntry> comparator;
    private static final String channel_key = "DiskManagerChannel";
    private static int channel_id_next;
    private static CopyOnWriteList<channelCreateListener> listeners;
    private DownloadImpl download;
    private DiskManagerFileInfoImpl plugin_file;
    private DiskManagerFileInfo core_file;
    private Set<dataEntry> data_written = new TreeSet<dataEntry>(comparator);
    private int compact_delay = 32;
    private List<AESemaphore> waiters = new ArrayList<AESemaphore>();
    private long file_offset_in_torrent;
    private long piece_size;
    private Average byte_rate = Average.getInstance(1000, 20);
    private long start_position;
    private long start_time;
    private volatile long current_position;
    private request current_request;
    private long buffer_millis_override;
    private long buffer_delay_millis;
    private PEPeerManager peer_manager;
    private long[] rtas;
    private int channel_id;
    private volatile boolean destroyed;

    public static void addListener(channelCreateListener channelCreateListener2) {
        listeners.add(channelCreateListener2);
    }

    public static void removeListener(channelCreateListener channelCreateListener2) {
        listeners.remove(channelCreateListener2);
    }

    protected static void reportCreated(DiskManagerChannel diskManagerChannel) {
        Iterator<channelCreateListener> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().channelCreated(diskManagerChannel);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DiskManagerChannelImpl(DownloadImpl downloadImpl, DiskManagerFileInfoImpl diskManagerFileInfoImpl) throws DownloadException {
        this.download = downloadImpl;
        this.plugin_file = diskManagerFileInfoImpl;
        this.core_file = this.plugin_file.getCore();
        DownloadManager downloadManager = this.core_file.getDownloadManager();
        if (downloadManager.getTorrent() == null) {
            throw new DownloadException("Torrent invalid");
        }
        if (downloadManager.isDestroyed()) {
            Debug.out("Download has been removed");
            throw new DownloadException("Download has been removed");
        }
        Object object = DiskManagerChannelImpl.class;
        synchronized (DiskManagerChannelImpl.class) {
            this.channel_id = channel_id_next++;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            object = this.core_file.getTorrentFile();
            TOTorrent tOTorrent = object.getTorrent();
            TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
            this.rtas = new long[tOTorrent.getNumberOfPieces()];
            downloadManager.addPeerListener(this);
            for (int i = 0; i < this.core_file.getIndex(); ++i) {
                this.file_offset_in_torrent += tOTorrentFileArray[i].getLength();
            }
            this.piece_size = object.getTorrent().getPieceLength();
            this.core_file.addListener(this);
            DiskManagerChannelImpl.reportCreated(this);
            return;
        }
    }

    @Override
    public org.gudy.azureus2.plugins.disk.DiskManagerFileInfo getFile() {
        return this.plugin_file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiskManagerRequest createRequest() {
        if (this.core_file.getDownloaded() != this.core_file.getLength()) {
            boolean bl;
            if (this.core_file.isSkipped()) {
                this.core_file.setSkipped(false);
            }
            if (!(bl = this.download.isForceStart())) {
                DownloadImpl downloadImpl = this.download;
                synchronized (downloadImpl) {
                    HashMap<String, String> hashMap = (HashMap<String, String>)this.download.getDownload().getData(channel_key);
                    if (hashMap == null) {
                        hashMap = new HashMap<String, String>();
                        this.download.getDownload().setData(channel_key, hashMap);
                    }
                    hashMap.put("" + this.channel_id, "");
                }
                this.download.setForceStart(true);
            }
        }
        this.current_request = new request();
        return this.current_request;
    }

    @Override
    public long getPosition() {
        return this.current_position;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataWritten(long l, long l2) {
        dataEntry dataEntry2 = new dataEntry(l, l2);
        Set<dataEntry> set = this.data_written;
        synchronized (set) {
            this.data_written.add(dataEntry2);
            --this.compact_delay;
            if (this.compact_delay == 0) {
                this.compact_delay = 32;
                Iterator<dataEntry> iterator = this.data_written.iterator();
                dataEntry dataEntry3 = null;
                while (iterator.hasNext()) {
                    dataEntry dataEntry4 = iterator.next();
                    if (dataEntry3 == null) {
                        dataEntry3 = dataEntry4;
                        continue;
                    }
                    long l3 = dataEntry3.getOffset();
                    long l4 = dataEntry3.getLength();
                    long l5 = dataEntry4.getOffset();
                    long l6 = dataEntry4.getLength();
                    if (l5 <= l3 + l4) {
                        iterator.remove();
                        dataEntry3.setLength(Math.max(l3 + l4, l5 + l6) - l3);
                        continue;
                    }
                    dataEntry3 = dataEntry4;
                }
            }
            for (int i = 0; i < this.waiters.size(); ++i) {
                this.waiters.get(i).release();
            }
        }
    }

    @Override
    public void dataChecked(long l, long l2) {
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager pEPeerManager) {
    }

    @Override
    public void peerManagerAdded(PEPeerManager pEPeerManager) {
        this.peer_manager = pEPeerManager;
        pEPeerManager.getPiecePicker().addRTAProvider(this);
    }

    @Override
    public void peerManagerRemoved(PEPeerManager pEPeerManager) {
        this.peer_manager = null;
        pEPeerManager.getPiecePicker().removeRTAProvider(this);
    }

    @Override
    public void peerAdded(PEPeer pEPeer) {
    }

    @Override
    public void peerRemoved(PEPeer pEPeer) {
    }

    @Override
    public long[] updateRTAs(PiecePicker piecePicker) {
        long l;
        long l2 = this.current_position + this.file_offset_in_torrent;
        int n = (int)(l2 / this.piece_size);
        int n2 = (int)(this.buffer_millis_override == 0L ? (long)DEFAULT_BUFFER_MILLIS : this.buffer_millis_override);
        long l3 = (long)n2 * (l = this.byte_rate.getAverage()) / 1000L;
        int n3 = (int)(l3 / this.piece_size);
        if (n3 < 1) {
            n3 = 1;
        }
        int n4 = n2 / n3;
        if (n3 < DEFAULT_MIN_PIECES_TO_BUFFER) {
            n3 = DEFAULT_MIN_PIECES_TO_BUFFER;
        }
        Arrays.fill(this.rtas, 0L);
        long l4 = SystemTime.getCurrentTime();
        l4 += this.buffer_delay_millis;
        for (int i = n; i < n + n3 && i < this.rtas.length; ++i) {
            this.rtas[i] = l4 + (long)((i - n) * n4);
        }
        return this.rtas;
    }

    @Override
    public long getStartTime() {
        return this.start_time;
    }

    @Override
    public long getStartPosition() {
        return this.file_offset_in_torrent + this.start_position;
    }

    @Override
    public long getCurrentPosition() {
        return this.file_offset_in_torrent + this.current_position;
    }

    @Override
    public long getBlockingPosition() {
        request request2 = this.current_request;
        if (request2 == null) {
            return this.file_offset_in_torrent + this.current_position;
        }
        return this.file_offset_in_torrent + this.current_position + request2.getAvailableBytes();
    }

    @Override
    public void setBufferMillis(long l, long l2) {
        this.buffer_millis_override = l;
        this.buffer_delay_millis = l2;
    }

    @Override
    public String getUserAgent() {
        request request2 = this.current_request;
        if (request2 == null) {
            return null;
        }
        return request2.getUserAgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.destroyed = true;
        this.core_file.removeListener(this);
        this.core_file.getDownloadManager().removePeerListener(this);
        this.core_file.close();
        if (this.peer_manager != null) {
            this.peer_manager.getPiecePicker().removeRTAProvider(this);
        }
        boolean bl = false;
        DownloadImpl downloadImpl = this.download;
        synchronized (downloadImpl) {
            Map map = (Map)this.download.getDownload().getData(channel_key);
            if (map != null) {
                map.remove("" + this.channel_id);
                if (map.size() == 0) {
                    bl = true;
                }
            }
        }
        if (bl) {
            this.download.setForceStart(false);
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"filechannel.rt.buffer.millis", "filechannel.rt.buffer.pieces"}, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                DEFAULT_BUFFER_MILLIS = COConfigurationManager.getIntParameter("filechannel.rt.buffer.millis");
                DEFAULT_MIN_PIECES_TO_BUFFER = COConfigurationManager.getIntParameter("filechannel.rt.buffer.pieces");
            }
        });
        comparator = new Comparator<dataEntry>(){

            @Override
            public int compare(dataEntry dataEntry2, dataEntry dataEntry3) {
                long l = dataEntry2.getOffset();
                long l2 = dataEntry2.getLength();
                long l3 = dataEntry3.getOffset();
                long l4 = dataEntry3.getLength();
                long l5 = l == l3 ? l2 - l4 : l - l3;
                if (l5 == 0L) {
                    return 0;
                }
                if (l5 < 0L) {
                    return -1;
                }
                return 1;
            }
        };
        listeners = new CopyOnWriteList();
    }

    protected static class dataEntry {
        private long offset;
        private long length;

        protected dataEntry(long l, long l2) {
            this.offset = l;
            this.length = l2;
        }

        protected long getOffset() {
            return this.offset;
        }

        protected long getLength() {
            return this.length;
        }

        protected void setLength(long l) {
            this.length = l;
        }

        protected String getString() {
            return "offset=" + this.offset + ",length=" + this.length;
        }
    }

    protected class request
    implements DiskManagerRequest {
        private int request_type;
        private long request_offset;
        private long request_length;
        private List<DiskManagerListener> listeners = new ArrayList<DiskManagerListener>();
        private String user_agent;
        private int max_read_chunk = 65536;
        private volatile boolean cancelled;
        AESemaphore wait_sem = new AESemaphore("DiskManagerChannelImpl:wait");

        protected request() {
            DiskManagerChannelImpl.this.start_time = SystemTime.getCurrentTime();
        }

        @Override
        public void setType(int n) {
            this.request_type = n;
        }

        @Override
        public void setOffset(long l) {
            this.request_offset = l;
            DiskManagerChannelImpl.this.start_position = this.request_offset;
        }

        @Override
        public void setLength(long l) {
            if (l < 0L) {
                throw new RuntimeException("Illegal argument");
            }
            this.request_length = l;
        }

        @Override
        public void setMaximumReadChunkSize(int n) {
            this.max_read_chunk = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getRemaining() {
            Set set = DiskManagerChannelImpl.this.data_written;
            synchronized (set) {
                return this.request_length - (DiskManagerChannelImpl.this.current_position - this.request_offset);
            }
        }

        @Override
        public void setUserAgent(String string) {
            this.user_agent = string;
        }

        protected String getUserAgent() {
            return this.user_agent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getAvailableBytes() {
            if (DiskManagerChannelImpl.this.plugin_file.getDownloaded() == DiskManagerChannelImpl.this.plugin_file.getLength()) {
                return this.getRemaining();
            }
            int n = DiskManagerChannelImpl.this.download.getState();
            if (n != 4 && n != 5) {
                return -1L;
            }
            Set set = DiskManagerChannelImpl.this.data_written;
            synchronized (set) {
                Iterator iterator = DiskManagerChannelImpl.this.data_written.iterator();
                dataEntry dataEntry2 = null;
                while (iterator.hasNext()) {
                    dataEntry dataEntry3 = (dataEntry)iterator.next();
                    long l = dataEntry3.getOffset();
                    long l2 = dataEntry3.getLength();
                    if (dataEntry2 == null) {
                        if (l > DiskManagerChannelImpl.this.current_position) break;
                        if (l > DiskManagerChannelImpl.this.current_position || DiskManagerChannelImpl.this.current_position >= l + l2) continue;
                        dataEntry2 = dataEntry3;
                        continue;
                    }
                    if (dataEntry2.getOffset() + dataEntry2.getLength() != dataEntry3.getOffset()) break;
                    dataEntry2 = dataEntry3;
                }
                if (dataEntry2 == null) {
                    return 0L;
                }
                return dataEntry2.getOffset() + dataEntry2.getLength() - DiskManagerChannelImpl.this.current_position;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l = this.request_length;
            long l2 = this.request_offset;
            block20: while (true) {
                try {
                    Object object;
                    if (l <= 0L || this.cancelled) break;
                    long l3 = 0L;
                    Object object2 = DiskManagerChannelImpl.this.data_written;
                    synchronized (object2) {
                        dataEntry dataEntry2;
                        long l4;
                        DiskManagerChannelImpl.this.current_position = l2;
                        object = DiskManagerChannelImpl.this.data_written.iterator();
                        while (object.hasNext() && (l4 = (dataEntry2 = (dataEntry)object.next()).getOffset()) <= l2) {
                            long l5 = dataEntry2.getLength();
                            long l6 = l4 + l5 - l2;
                            if (l6 <= 0L) continue;
                            l3 = l6;
                            break;
                        }
                    }
                    if (l3 > 0L) {
                        if (l3 > l) {
                            l3 = l;
                        }
                        if (l3 > (long)this.max_read_chunk) {
                            l3 = this.max_read_chunk;
                        }
                        object2 = DiskManagerChannelImpl.this.core_file.read(l2, (int)l3);
                        this.inform(new event(new PooledByteBufferImpl((DirectByteBuffer)object2), l2, (int)l3));
                        l2 += l3;
                        l -= l3;
                        object = DiskManagerChannelImpl.this.data_written;
                        synchronized (object) {
                            DiskManagerChannelImpl.this.byte_rate.addValue(l3);
                            DiskManagerChannelImpl.this.current_position = l2;
                            continue;
                        }
                    }
                    this.inform(new event(l2));
                    object2 = DiskManagerChannelImpl.this.data_written;
                    synchronized (object2) {
                        DiskManagerChannelImpl.this.waiters.add(this.wait_sem);
                    }
                    try {
                        do {
                            if (this.wait_sem.reserve(500L)) continue block20;
                        } while (!DiskManagerChannelImpl.this.core_file.getDownloadManager().isDestroyed());
                        throw new Exception("Download has been removed");
                    }
                    finally {
                        object2 = DiskManagerChannelImpl.this.data_written;
                        synchronized (object2) {
                            DiskManagerChannelImpl.this.waiters.remove(this.wait_sem);
                        }
                    }
                }
                catch (Throwable throwable) {
                    this.inform(throwable);
                    break;
                }
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.inform(new Throwable("Request cancelled"));
            this.wait_sem.release();
        }

        protected void inform(Throwable throwable) {
            this.inform(new event(throwable));
        }

        protected void inform(event event2) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    this.listeners.get(i).eventOccurred(event2);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }

        @Override
        public void addListener(DiskManagerListener diskManagerListener) {
            this.listeners.add(diskManagerListener);
        }

        @Override
        public void removeListener(DiskManagerListener diskManagerListener) {
            this.listeners.remove(diskManagerListener);
        }

        protected class event
        implements DiskManagerEvent {
            private int event_type;
            private Throwable error;
            private PooledByteBuffer buffer;
            private long event_offset;
            private int event_length;

            protected event(Throwable throwable) {
                this.event_type = 2;
                this.error = throwable;
            }

            protected event(long l) {
                this.event_type = 3;
                this.event_offset = l;
            }

            protected event(PooledByteBuffer pooledByteBuffer, long l, int n) {
                this.event_type = 1;
                this.buffer = pooledByteBuffer;
                this.event_offset = l;
                this.event_length = n;
            }

            @Override
            public int getType() {
                return this.event_type;
            }

            @Override
            public DiskManagerRequest getRequest() {
                return request.this;
            }

            @Override
            public long getOffset() {
                return this.event_offset;
            }

            @Override
            public int getLength() {
                return this.event_length;
            }

            @Override
            public PooledByteBuffer getBuffer() {
                return this.buffer;
            }

            @Override
            public Throwable getFailure() {
                return this.error;
            }
        }
    }

    public static interface channelCreateListener {
        public void channelCreated(DiskManagerChannel var1);
    }
}

