/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.tracker.TrackerPeerSourceAdapter;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.CopyOnWriteMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerActivationListener;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.download.DownloadManagerStateEvent;
import org.gudy.azureus2.core3.download.DownloadManagerStateListener;
import org.gudy.azureus2.core3.download.DownloadManagerTrackerListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerMoveHandler;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadActivationEvent;
import org.gudy.azureus2.plugins.download.DownloadActivationListener;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadCompletionListener;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadPropertyEvent;
import org.gudy.azureus2.plugins.download.DownloadPropertyListener;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.deprecate.PluginDeprecation;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerFileInfoImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadAnnounceResultImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadScrapeResultImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadStatsImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;

public class DownloadImpl
extends LogRelation
implements Download,
DownloadManagerListener,
DownloadManagerTrackerListener,
DownloadManagerStateListener,
DownloadManagerActivationListener,
DownloadManagerStateAttributeListener {
    private DownloadManager download_manager;
    private DownloadStatsImpl download_stats;
    private int latest_state = 7;
    private boolean latest_forcedStart;
    private DownloadAnnounceResultImpl last_announce_result = new DownloadAnnounceResultImpl(this, null);
    private DownloadScrapeResultImpl last_scrape_result = new DownloadScrapeResultImpl(this, null);
    private TorrentImpl torrent = null;
    private List listeners = new ArrayList();
    private AEMonitor listeners_mon = new AEMonitor("Download:L");
    private List property_listeners = new ArrayList();
    private List tracker_listeners = new ArrayList();
    private AEMonitor tracker_listeners_mon = new AEMonitor("Download:TL");
    private List removal_listeners = new ArrayList();
    private AEMonitor removal_listeners_mon = new AEMonitor("Download:RL");
    private Map peer_listeners = new HashMap();
    private AEMonitor peer_listeners_mon = new AEMonitor("Download:PL");
    private CopyOnWriteList completion_listeners = new CopyOnWriteList();
    private CopyOnWriteMap read_attribute_listeners_map_cow = new CopyOnWriteMap();
    private CopyOnWriteMap write_attribute_listeners_map_cow = new CopyOnWriteMap();
    private CopyOnWriteList activation_listeners = new CopyOnWriteList();
    private DownloadActivationEvent activation_state;
    private HashMap property_to_attribute_map = null;
    private Map<String, int[]> announce_response_map;

    protected DownloadImpl(DownloadManager downloadManager) {
        this.download_manager = downloadManager;
        this.download_stats = new DownloadStatsImpl(this.download_manager);
        this.activation_state = new DownloadActivationEvent(){

            @Override
            public Download getDownload() {
                return DownloadImpl.this;
            }

            @Override
            public int getActivationCount() {
                return DownloadImpl.this.download_manager.getActivationCount();
            }
        };
        this.download_manager.addListener(this);
        this.latest_forcedStart = this.download_manager.isForceStart();
    }

    public DownloadManager getDownload() {
        return this.download_manager;
    }

    @Override
    public int getState() {
        return this.convertState(this.download_manager.getState());
    }

    @Override
    public int getSubState() {
        int n = this.getState();
        if (n == 6) {
            int n2 = this.download_manager.getSubState();
            if (n2 == 75) {
                return 9;
            }
            if (n2 == 70) {
                return 7;
            }
            if (n2 == 100) {
                return 8;
            }
        }
        return n;
    }

    protected int convertState(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 5: 
            case 10: 
            case 20: 
            case 30: {
                n2 = 2;
                break;
            }
            case 40: {
                n2 = 3;
                break;
            }
            case 50: 
            case 55: {
                n2 = 4;
                break;
            }
            case 60: {
                n2 = 5;
                break;
            }
            case 65: {
                n2 = 6;
                break;
            }
            case 70: {
                n2 = 7;
                break;
            }
            case 75: {
                n2 = 9;
                break;
            }
            case 100: {
                n2 = 8;
                break;
            }
            default: {
                n2 = 8;
            }
        }
        return n2;
    }

    @Override
    public String getErrorStateDetails() {
        return this.download_manager.getErrorDetails();
    }

    @Override
    public long getFlags() {
        return this.download_manager.getDownloadState().getFlags();
    }

    @Override
    public boolean getFlag(long l) {
        return this.download_manager.getDownloadState().getFlag(l);
    }

    @Override
    public void setFlag(long l, boolean bl) {
        this.download_manager.getDownloadState().setFlag(l, bl);
    }

    @Override
    public int getIndex() {
        GlobalManager globalManager = this.download_manager.getGlobalManager();
        return globalManager.getIndexOf(this.download_manager);
    }

    @Override
    public Torrent getTorrent() {
        if (this.torrent != null) {
            return this.torrent;
        }
        TOTorrent tOTorrent = this.download_manager.getTorrent();
        if (tOTorrent == null) {
            return null;
        }
        this.torrent = new TorrentImpl(tOTorrent);
        return this.torrent;
    }

    @Override
    public void initialize() throws DownloadException {
        int n = this.download_manager.getState();
        if (n != 0) {
            throw new DownloadException("Download::initialize: download not waiting (state=" + n + ")");
        }
        this.download_manager.initialize();
    }

    @Override
    public void start() throws DownloadException {
        int n = this.download_manager.getState();
        if (n != 40) {
            throw new DownloadException("Download::start: download not ready (state=" + n + ")");
        }
        this.download_manager.startDownload();
    }

    @Override
    public void restart() throws DownloadException {
        int n = this.download_manager.getState();
        if (n != 70 && n != 75) {
            throw new DownloadException("Download::restart: download already running (state=" + n + ")");
        }
        this.download_manager.setStateWaiting();
    }

    @Override
    public void stop() throws DownloadException {
        if (this.download_manager.getState() == 70) {
            throw new DownloadException("Download::stop: download already stopped");
        }
        this.download_manager.stopIt(70, false, false);
    }

    @Override
    public void stopAndQueue() throws DownloadException {
        if (this.download_manager.getState() == 75) {
            throw new DownloadException("Download::stopAndQueue: download already queued");
        }
        this.download_manager.stopIt(75, false, false);
    }

    @Override
    public void recheckData() throws DownloadException {
        if (!this.download_manager.canForceRecheck()) {
            throw new DownloadException("Download::recheckData: download must be stopped, queued or in error state");
        }
        this.download_manager.forceRecheck();
    }

    @Override
    public boolean isStartStopLocked() {
        return this.download_manager.getState() == 70;
    }

    @Override
    public boolean isForceStart() {
        return this.download_manager.isForceStart();
    }

    @Override
    public void setForceStart(boolean bl) {
        this.download_manager.setForceStart(bl);
    }

    @Override
    public boolean isPaused() {
        return this.download_manager.isPaused();
    }

    @Override
    public void pause() {
        this.download_manager.pause();
    }

    @Override
    public void resume() {
        this.download_manager.resume();
    }

    @Override
    public int getPosition() {
        return this.download_manager.getPosition();
    }

    @Override
    public long getCreationTime() {
        return this.download_manager.getCreationTime();
    }

    @Override
    public void setPosition(int n) {
        this.download_manager.setPosition(n);
    }

    @Override
    public void moveUp() {
        this.download_manager.getGlobalManager().moveUp(this.download_manager);
    }

    @Override
    public void moveDown() {
        this.download_manager.getGlobalManager().moveDown(this.download_manager);
    }

    @Override
    public void moveTo(int n) {
        this.download_manager.getGlobalManager().moveTo(this.download_manager, n);
    }

    @Override
    public String getName() {
        return this.download_manager.getDisplayName();
    }

    @Override
    public String getTorrentFileName() {
        return this.download_manager.getTorrentFileName();
    }

    @Override
    public String getCategoryName() {
        Category category = this.download_manager.getDownloadState().getCategory();
        if (category == null) {
            category = CategoryManager.getCategory(2);
        }
        if (category == null) {
            return null;
        }
        return category.getName();
    }

    @Override
    public String getAttribute(TorrentAttribute torrentAttribute) {
        String string = this.convertAttribute(torrentAttribute);
        if (string != null) {
            return this.download_manager.getDownloadState().getAttribute(string);
        }
        return null;
    }

    @Override
    public String[] getListAttribute(TorrentAttribute torrentAttribute) {
        String string = this.convertAttribute(torrentAttribute);
        if (string != null) {
            return this.download_manager.getDownloadState().getListAttribute(string);
        }
        return null;
    }

    @Override
    public void setListAttribute(TorrentAttribute torrentAttribute, String[] stringArray) {
        String string = this.convertAttribute(torrentAttribute);
        if (string != null) {
            this.download_manager.getDownloadState().setListAttribute(string, stringArray);
        }
    }

    @Override
    public void setMapAttribute(TorrentAttribute torrentAttribute, Map map) {
        String string = this.convertAttribute(torrentAttribute);
        if (string != null) {
            this.download_manager.getDownloadState().setMapAttribute(string, BEncoder.cloneMap(map));
        }
    }

    @Override
    public Map getMapAttribute(TorrentAttribute torrentAttribute) {
        String string = this.convertAttribute(torrentAttribute);
        if (string != null) {
            return this.download_manager.getDownloadState().getMapAttribute(string);
        }
        return null;
    }

    @Override
    public void setAttribute(TorrentAttribute torrentAttribute, String string) {
        String string2 = this.convertAttribute(torrentAttribute);
        if (string2 != null) {
            this.download_manager.getDownloadState().setAttribute(string2, string);
        }
    }

    @Override
    public boolean hasAttribute(TorrentAttribute torrentAttribute) {
        String string = this.convertAttribute(torrentAttribute);
        if (string == null) {
            return false;
        }
        return this.download_manager.getDownloadState().hasAttribute(string);
    }

    @Override
    public boolean getBooleanAttribute(TorrentAttribute torrentAttribute) {
        String string = this.convertAttribute(torrentAttribute);
        if (string == null) {
            return false;
        }
        return this.download_manager.getDownloadState().getBooleanAttribute(string);
    }

    @Override
    public void setBooleanAttribute(TorrentAttribute torrentAttribute, boolean bl) {
        String string = this.convertAttribute(torrentAttribute);
        if (string != null) {
            this.download_manager.getDownloadState().setBooleanAttribute(string, bl);
        }
    }

    @Override
    public int getIntAttribute(TorrentAttribute torrentAttribute) {
        String string = this.convertAttribute(torrentAttribute);
        if (string == null) {
            return 0;
        }
        return this.download_manager.getDownloadState().getIntAttribute(string);
    }

    @Override
    public void setIntAttribute(TorrentAttribute torrentAttribute, int n) {
        String string = this.convertAttribute(torrentAttribute);
        if (string != null) {
            this.download_manager.getDownloadState().setIntAttribute(string, n);
        }
    }

    @Override
    public long getLongAttribute(TorrentAttribute torrentAttribute) {
        String string = this.convertAttribute(torrentAttribute);
        if (string == null) {
            return 0L;
        }
        return this.download_manager.getDownloadState().getLongAttribute(string);
    }

    @Override
    public void setLongAttribute(TorrentAttribute torrentAttribute, long l) {
        String string = this.convertAttribute(torrentAttribute);
        if (string != null) {
            this.download_manager.getDownloadState().setLongAttribute(string, l);
        }
    }

    protected String convertAttribute(TorrentAttribute torrentAttribute) {
        if (torrentAttribute.getName() == "Category") {
            return "category";
        }
        if (torrentAttribute.getName() == "Networks") {
            return "networks";
        }
        if (torrentAttribute.getName() == "TrackerClientExtensions") {
            return "trackerclientextensions";
        }
        if (torrentAttribute.getName() == "PeerSources") {
            return "peersources";
        }
        if (torrentAttribute.getName() == "DisplayName") {
            return "displayname";
        }
        if (torrentAttribute.getName() == "UserComment") {
            return "comment";
        }
        if (torrentAttribute.getName() == "RelativePath") {
            return "relativepath";
        }
        if (torrentAttribute.getName() == "ShareProperties") {
            return null;
        }
        if (torrentAttribute.getName().startsWith("Plugin.")) {
            return torrentAttribute.getName();
        }
        Debug.out("Can't convert attribute '" + torrentAttribute.getName() + "'");
        return null;
    }

    protected TorrentAttribute convertAttribute(String string) {
        if (string.equals("category")) {
            return TorrentManagerImpl.getSingleton().getAttribute("Category");
        }
        if (string.equals("networks")) {
            return TorrentManagerImpl.getSingleton().getAttribute("Networks");
        }
        if (string.equals("peersources")) {
            return TorrentManagerImpl.getSingleton().getAttribute("PeerSources");
        }
        if (string.equals("trackerclientextensions")) {
            return TorrentManagerImpl.getSingleton().getAttribute("TrackerClientExtensions");
        }
        if (string.equals("displayname")) {
            return TorrentManagerImpl.getSingleton().getAttribute("DisplayName");
        }
        if (string.equals("comment")) {
            return TorrentManagerImpl.getSingleton().getAttribute("UserComment");
        }
        if (string.equals("relativepath")) {
            return TorrentManagerImpl.getSingleton().getAttribute("RelativePath");
        }
        if (string.startsWith("Plugin.")) {
            return TorrentManagerImpl.getSingleton().getAttribute(string);
        }
        return null;
    }

    @Override
    public void setCategory(String string) {
        Category category = CategoryManager.getCategory(string);
        if (category == null) {
            category = CategoryManager.createCategory(string);
        }
        this.download_manager.getDownloadState().setCategory(category);
    }

    @Override
    public boolean isPersistent() {
        return this.download_manager.isPersistent();
    }

    @Override
    public void remove() throws DownloadException, DownloadRemovalVetoException {
        this.remove(false, false);
    }

    @Override
    public void remove(boolean bl, boolean bl2) throws DownloadException, DownloadRemovalVetoException {
        int n = this.download_manager.getState();
        if (n == 70 || n == 100 || n == 75) {
            GlobalManager globalManager = this.download_manager.getGlobalManager();
            try {
                globalManager.removeDownloadManager(this.download_manager, bl, bl2);
            }
            catch (GlobalManagerDownloadRemovalVetoException globalManagerDownloadRemovalVetoException) {
                throw new DownloadRemovalVetoException(globalManagerDownloadRemovalVetoException.getMessage());
            }
        } else {
            throw new DownloadRemovalVetoException(MessageText.getString("plugin.download.remove.veto.notstopped"));
        }
    }

    @Override
    public boolean canBeRemoved() throws DownloadRemovalVetoException {
        int n = this.download_manager.getState();
        if (n == 70 || n == 100 || n == 75) {
            GlobalManager globalManager = this.download_manager.getGlobalManager();
            try {
                globalManager.canDownloadManagerBeRemoved(this.download_manager, false, false);
            }
            catch (GlobalManagerDownloadRemovalVetoException globalManagerDownloadRemovalVetoException) {
                throw new DownloadRemovalVetoException(globalManagerDownloadRemovalVetoException.getMessage(), globalManagerDownloadRemovalVetoException.isSilent());
            }
        } else {
            throw new DownloadRemovalVetoException(MessageText.getString("plugin.download.remove.veto.notstopped"));
        }
        return true;
    }

    @Override
    public DownloadStats getStats() {
        return this.download_stats;
    }

    @Override
    public boolean isComplete() {
        return this.download_manager.isDownloadComplete(false);
    }

    @Override
    public boolean isComplete(boolean bl) {
        return this.download_manager.isDownloadComplete(bl);
    }

    @Override
    public boolean isChecking() {
        return this.download_stats.getCheckingDoneInThousandNotation() != -1;
    }

    protected void isRemovable() throws DownloadRemovalVetoException {
        for (int i = 0; i < this.removal_listeners.size(); ++i) {
            try {
                ((DownloadWillBeRemovedListener)this.removal_listeners.get(i)).downloadWillBeRemoved(this);
                continue;
            }
            catch (DownloadRemovalVetoException downloadRemovalVetoException) {
                throw downloadRemovalVetoException;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void destroy() {
        this.download_manager.removeListener(this);
    }

    @Override
    public void stateChanged(DownloadManager downloadManager, int n) {
        int n2 = this.latest_state;
        this.latest_state = this.convertState(n);
        boolean bl = this.isForceStart();
        List list = this.listeners;
        if (n2 != this.latest_state || this.latest_forcedStart != bl) {
            this.latest_forcedStart = bl;
            for (int i = 0; i < list.size(); ++i) {
                try {
                    long l = SystemTime.getCurrentTime();
                    DownloadListener downloadListener2 = (DownloadListener)list.get(i);
                    downloadListener2.stateChanged(this, n2, this.latest_state);
                    long l2 = SystemTime.getCurrentTime() - l;
                    if (l2 <= 1000L) continue;
                    System.out.println("Plugin should move long processes (" + l2 + "ms) off of Download's stateChanged listener trigger. " + downloadListener2);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    @Override
    public void downloadComplete(DownloadManager downloadManager) {
        if (this.completion_listeners.isEmpty()) {
            return;
        }
        for (DownloadCompletionListener downloadCompletionListener : this.completion_listeners) {
            long l;
            long l2 = SystemTime.getCurrentTime();
            try {
                downloadCompletionListener.onCompletion(this);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
            if ((l = SystemTime.getCurrentTime() - l2) <= 1000L) continue;
            System.out.println("Plugin should move long processes (" + l + "ms) off of Download's onCompletion listener trigger. " + downloadCompletionListener);
        }
    }

    @Override
    public void completionChanged(DownloadManager downloadManager, boolean bl) {
    }

    @Override
    public void filePriorityChanged(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
    }

    @Override
    public void positionChanged(DownloadManager downloadManager, int n, int n2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                long l = SystemTime.getCurrentTime();
                DownloadListener downloadListener2 = (DownloadListener)this.listeners.get(i);
                downloadListener2.positionChanged(this, n, n2);
                long l2 = SystemTime.getCurrentTime() - l;
                if (l2 <= 1000L) continue;
                System.out.println("Plugin should move long processes (" + l2 + "ms) off of Download's positionChanged listener trigger. " + downloadListener2);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(DownloadListener downloadListener2) {
        try {
            this.listeners_mon.enter();
            ArrayList<DownloadListener> arrayList = new ArrayList<DownloadListener>(this.listeners);
            arrayList.add(downloadListener2);
            this.listeners = arrayList;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(DownloadListener downloadListener2) {
        try {
            this.listeners_mon.enter();
            ArrayList arrayList = new ArrayList(this.listeners);
            arrayList.remove(downloadListener2);
            this.listeners = arrayList;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void addAttributeListener(DownloadAttributeListener downloadAttributeListener, TorrentAttribute torrentAttribute, int n) {
        String string = this.convertAttribute(torrentAttribute);
        if (string == null) {
            return;
        }
        CopyOnWriteMap copyOnWriteMap = this.getAttributeMapForType(n);
        CopyOnWriteList<DownloadAttributeListener> copyOnWriteList = (CopyOnWriteList<DownloadAttributeListener>)copyOnWriteMap.get(string);
        boolean bl = false;
        if (copyOnWriteList == null) {
            copyOnWriteList = new CopyOnWriteList<DownloadAttributeListener>();
            copyOnWriteMap.put(string, copyOnWriteList);
        }
        bl = copyOnWriteList.isEmpty();
        copyOnWriteList.add(downloadAttributeListener);
        if (bl) {
            this.download_manager.getDownloadState().addListener(this, string, n);
        }
    }

    @Override
    public void removeAttributeListener(DownloadAttributeListener downloadAttributeListener, TorrentAttribute torrentAttribute, int n) {
        String string = this.convertAttribute(torrentAttribute);
        if (string == null) {
            return;
        }
        CopyOnWriteMap copyOnWriteMap = this.getAttributeMapForType(n);
        CopyOnWriteList copyOnWriteList = (CopyOnWriteList)copyOnWriteMap.get(string);
        boolean bl = false;
        if (copyOnWriteList != null) {
            copyOnWriteList.remove(downloadAttributeListener);
            bl = copyOnWriteList.isEmpty();
        }
        if (bl) {
            this.download_manager.getDownloadState().removeListener(this, string, n);
        }
    }

    @Override
    public DownloadAnnounceResult getLastAnnounceResult() {
        TRTrackerAnnouncer tRTrackerAnnouncer = this.download_manager.getTrackerClient();
        if (tRTrackerAnnouncer != null) {
            this.last_announce_result.setContent(tRTrackerAnnouncer.getLastResponse());
        }
        return this.last_announce_result;
    }

    @Override
    public DownloadScrapeResult getLastScrapeResult() {
        TRTrackerScraperResponse tRTrackerScraperResponse = this.download_manager.getTrackerScrapeResponse();
        if (tRTrackerScraperResponse != null && (tRTrackerScraperResponse.getStatus() == 1 || tRTrackerScraperResponse.getStatus() == 2)) {
            this.last_scrape_result.setContent(tRTrackerScraperResponse);
        }
        return this.last_scrape_result;
    }

    @Override
    public void scrapeResult(TRTrackerScraperResponse tRTrackerScraperResponse) {
        if (tRTrackerScraperResponse.getStatus() != 1 && tRTrackerScraperResponse.getStatus() != 2) {
            return;
        }
        this.last_scrape_result.setContent(tRTrackerScraperResponse);
        for (int i = 0; i < this.tracker_listeners.size(); ++i) {
            try {
                ((DownloadTrackerListener)this.tracker_listeners.get(i)).scrapeResult(this.last_scrape_result);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    void announceTrackerResultsToListener(DownloadTrackerListener downloadTrackerListener) {
        downloadTrackerListener.announceResult(this.last_announce_result);
        downloadTrackerListener.scrapeResult(this.last_scrape_result);
    }

    @Override
    public void announceResult(TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse) {
        this.last_announce_result.setContent(tRTrackerAnnouncerResponse);
        List list = this.tracker_listeners;
        for (int i = 0; i < list.size(); ++i) {
            try {
                ((DownloadTrackerListener)list.get(i)).announceResult(this.last_announce_result);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public TrackerPeerSource getTrackerPeerSource() {
        return new TrackerPeerSourceAdapter(){
            private long fixup;
            private int state;
            private String details = "";
            private int seeds;
            private int leechers;
            private int peers;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fixup() {
                long l = SystemTime.getCurrentTime();
                if (l - this.fixup > 1000L) {
                    int n;
                    this.state = !DownloadImpl.this.download_manager.getDownloadState().isPeerSourceEnabled("Plugin") ? 1 : ((n = DownloadImpl.this.getState()) == 4 || n == 5 ? 5 : 2);
                    if (this.state == 5) {
                        try {
                            DownloadImpl.this.peer_listeners_mon.enter();
                            n = 0;
                            int n2 = 0;
                            int n3 = 0;
                            String string = "";
                            if (DownloadImpl.this.announce_response_map != null) {
                                for (Map.Entry entry : DownloadImpl.this.announce_response_map.entrySet()) {
                                    String string2 = (String)entry.getKey();
                                    int[] nArray = (int[])entry.getValue();
                                    string = string + (string.length() == 0 ? "" : ", ") + string2;
                                    string = string + " " + nArray[0] + "/" + nArray[1] + "/" + nArray[2];
                                    n += nArray[0];
                                    n2 += nArray[1];
                                    n3 += nArray[2];
                                }
                            }
                            this.details = string;
                            this.seeds = n;
                            this.leechers = n2;
                            this.peers = n3;
                        }
                        finally {
                            DownloadImpl.this.peer_listeners_mon.exit();
                        }
                    } else {
                        this.details = "";
                    }
                    this.fixup = l;
                }
            }

            @Override
            public int getType() {
                return 7;
            }

            @Override
            public int getStatus() {
                this.fixup();
                return this.state;
            }

            @Override
            public String getName() {
                this.fixup();
                if (this.state == 5) {
                    return this.details;
                }
                return "";
            }

            @Override
            public int getSeedCount() {
                this.fixup();
                if (this.state == 5) {
                    return this.seeds;
                }
                return -1;
            }

            @Override
            public int getLeecherCount() {
                this.fixup();
                if (this.state == 5) {
                    return this.leechers;
                }
                return -1;
            }

            @Override
            public int getPeers() {
                this.fixup();
                if (this.state == 5) {
                    return this.peers;
                }
                return -1;
            }
        };
    }

    private String getTrackingName(Object object) {
        String string = object.getClass().getName();
        int n = string.lastIndexOf(46);
        if ((n = (string = string.substring(n + 1)).indexOf(36)) != -1) {
            string = string.substring(0, n);
        }
        if (string.equals("DHTTrackerPlugin")) {
            string = null;
        } else if (string.equals("DHTAnnounceResult")) {
            string = "mlDHT";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAnnounceResult(DownloadAnnounceResult downloadAnnounceResult) {
        String string = this.getTrackingName(downloadAnnounceResult);
        if (string != null) {
            int n = downloadAnnounceResult.getSeedCount();
            int n2 = downloadAnnounceResult.getNonSeedCount();
            DownloadAnnounceResultPeer[] downloadAnnounceResultPeerArray = downloadAnnounceResult.getPeers();
            int n3 = downloadAnnounceResultPeerArray == null ? 0 : downloadAnnounceResultPeerArray.length;
            try {
                this.peer_listeners_mon.enter();
                if (this.announce_response_map == null) {
                    this.announce_response_map = new HashMap<String, int[]>();
                } else if (this.announce_response_map.size() > 32) {
                    Debug.out("eh?");
                    this.announce_response_map.clear();
                }
                int[] nArray = this.announce_response_map.get(string);
                if (nArray == null) {
                    nArray = new int[3];
                    this.announce_response_map.put(string, nArray);
                }
                nArray[0] = n;
                nArray[1] = n2;
                nArray[2] = n3;
            }
            finally {
                this.peer_listeners_mon.exit();
            }
        }
        this.download_manager.setAnnounceResult(downloadAnnounceResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScrapeResult(DownloadScrapeResult downloadScrapeResult) {
        String string = this.getTrackingName(downloadScrapeResult);
        if (string != null) {
            int n = downloadScrapeResult.getSeedCount();
            int n2 = downloadScrapeResult.getNonSeedCount();
            try {
                this.peer_listeners_mon.enter();
                if (this.announce_response_map == null) {
                    this.announce_response_map = new HashMap<String, int[]>();
                } else if (this.announce_response_map.size() > 32) {
                    Debug.out("eh?");
                    this.announce_response_map.clear();
                }
                int[] nArray = this.announce_response_map.get(string);
                if (nArray == null) {
                    nArray = new int[3];
                    this.announce_response_map.put(string, nArray);
                }
                nArray[0] = n;
                nArray[1] = n2;
            }
            finally {
                this.peer_listeners_mon.exit();
            }
        }
        this.download_manager.setScrapeResult(downloadScrapeResult);
    }

    @Override
    public void stateChanged(DownloadManagerState downloadManagerState, DownloadManagerStateEvent downloadManagerStateEvent) {
        final int n = downloadManagerStateEvent.getType();
        if (n == 1 || n == 2) {
            String string = (String)downloadManagerStateEvent.getData();
            List list = this.property_listeners;
            final TorrentAttribute torrentAttribute = this.convertAttribute(string);
            if (torrentAttribute != null) {
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        ((DownloadPropertyListener)list.get(i)).propertyChanged(this, new DownloadPropertyEvent(){

                            @Override
                            public int getType() {
                                return n == 1 ? 1 : 2;
                            }

                            @Override
                            public Object getData() {
                                return torrentAttribute;
                            }
                        });
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPropertyListener(DownloadPropertyListener downloadPropertyListener) {
        if ("com.aimedia.stopseeding.core.RatioWatcher".equals(downloadPropertyListener.getClass().getName())) {
            return;
        }
        PluginDeprecation.call("property listener", downloadPropertyListener);
        try {
            this.tracker_listeners_mon.enter();
            ArrayList<DownloadPropertyListener> arrayList = new ArrayList<DownloadPropertyListener>(this.property_listeners);
            arrayList.add(downloadPropertyListener);
            this.property_listeners = arrayList;
            if (this.property_listeners.size() == 1) {
                this.download_manager.getDownloadState().addListener(this);
            }
        }
        finally {
            this.tracker_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePropertyListener(DownloadPropertyListener downloadPropertyListener) {
        if ("com.aimedia.stopseeding.core.RatioWatcher".equals(downloadPropertyListener.getClass().getName())) {
            return;
        }
        try {
            this.tracker_listeners_mon.enter();
            ArrayList arrayList = new ArrayList(this.property_listeners);
            arrayList.remove(downloadPropertyListener);
            this.property_listeners = arrayList;
            if (this.property_listeners.size() == 0) {
                this.download_manager.getDownloadState().removeListener(this);
            }
        }
        finally {
            this.tracker_listeners_mon.exit();
        }
    }

    public void torrentChanged() {
        TRTrackerAnnouncer tRTrackerAnnouncer = this.download_manager.getTrackerClient();
        if (tRTrackerAnnouncer != null) {
            tRTrackerAnnouncer.resetTrackerUrl(true);
        }
    }

    @Override
    public void addTrackerListener(DownloadTrackerListener downloadTrackerListener) {
        this.addTrackerListener(downloadTrackerListener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTrackerListener(DownloadTrackerListener downloadTrackerListener, boolean bl) {
        try {
            this.tracker_listeners_mon.enter();
            ArrayList<DownloadTrackerListener> arrayList = new ArrayList<DownloadTrackerListener>(this.tracker_listeners);
            arrayList.add(downloadTrackerListener);
            this.tracker_listeners = arrayList;
            if (this.tracker_listeners.size() == 1) {
                this.download_manager.addTrackerListener(this);
            }
        }
        finally {
            this.tracker_listeners_mon.exit();
        }
        if (bl) {
            this.announceTrackerResultsToListener(downloadTrackerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTrackerListener(DownloadTrackerListener downloadTrackerListener) {
        try {
            this.tracker_listeners_mon.enter();
            ArrayList arrayList = new ArrayList(this.tracker_listeners);
            arrayList.remove(downloadTrackerListener);
            this.tracker_listeners = arrayList;
            if (this.tracker_listeners.size() == 0) {
                this.download_manager.removeTrackerListener(this);
            }
        }
        finally {
            this.tracker_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDownloadWillBeRemovedListener(DownloadWillBeRemovedListener downloadWillBeRemovedListener) {
        try {
            this.removal_listeners_mon.enter();
            ArrayList<DownloadWillBeRemovedListener> arrayList = new ArrayList<DownloadWillBeRemovedListener>(this.removal_listeners);
            arrayList.add(downloadWillBeRemovedListener);
            this.removal_listeners = arrayList;
        }
        finally {
            this.removal_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDownloadWillBeRemovedListener(DownloadWillBeRemovedListener downloadWillBeRemovedListener) {
        try {
            this.removal_listeners_mon.enter();
            ArrayList arrayList = new ArrayList(this.removal_listeners);
            arrayList.remove(downloadWillBeRemovedListener);
            this.removal_listeners = arrayList;
        }
        finally {
            this.removal_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPeerListener(final DownloadPeerListener downloadPeerListener) {
        DownloadManagerPeerListener downloadManagerPeerListener = new DownloadManagerPeerListener(){

            @Override
            public void peerManagerAdded(PEPeerManager pEPeerManager) {
                PeerManagerImpl peerManagerImpl = PeerManagerImpl.getPeerManager(pEPeerManager);
                downloadPeerListener.peerManagerAdded(DownloadImpl.this, peerManagerImpl);
            }

            @Override
            public void peerManagerRemoved(PEPeerManager pEPeerManager) {
                PeerManagerImpl peerManagerImpl = PeerManagerImpl.getPeerManager(pEPeerManager);
                downloadPeerListener.peerManagerRemoved(DownloadImpl.this, peerManagerImpl);
            }

            @Override
            public void peerManagerWillBeAdded(PEPeerManager pEPeerManager) {
            }

            @Override
            public void peerAdded(PEPeer pEPeer) {
            }

            @Override
            public void peerRemoved(PEPeer pEPeer) {
            }
        };
        try {
            this.peer_listeners_mon.enter();
            this.peer_listeners.put(downloadPeerListener, downloadManagerPeerListener);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
        this.download_manager.addPeerListener(downloadManagerPeerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePeerListener(DownloadPeerListener downloadPeerListener) {
        DownloadManagerPeerListener downloadManagerPeerListener;
        try {
            this.peer_listeners_mon.enter();
            downloadManagerPeerListener = (DownloadManagerPeerListener)this.peer_listeners.remove(downloadPeerListener);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
        if (downloadManagerPeerListener == null) {
            Debug.out("Listener not found for removal");
        } else {
            this.download_manager.removePeerListener(downloadManagerPeerListener);
        }
    }

    @Override
    public boolean activateRequest(final int n) {
        DownloadActivationEvent downloadActivationEvent = new DownloadActivationEvent(){

            @Override
            public Download getDownload() {
                return DownloadImpl.this;
            }

            @Override
            public int getActivationCount() {
                return n;
            }
        };
        Iterator iterator = this.activation_listeners.iterator();
        while (iterator.hasNext()) {
            try {
                DownloadActivationListener downloadActivationListener = (DownloadActivationListener)iterator.next();
                if (!downloadActivationListener.activationRequested(downloadActivationEvent)) continue;
                return true;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return false;
    }

    @Override
    public DownloadActivationEvent getActivationState() {
        return this.activation_state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActivationListener(DownloadActivationListener downloadActivationListener) {
        try {
            this.peer_listeners_mon.enter();
            this.activation_listeners.add(downloadActivationListener);
            if (this.activation_listeners.size() == 1) {
                this.download_manager.addActivationListener(this);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActivationListener(DownloadActivationListener downloadActivationListener) {
        try {
            this.peer_listeners_mon.enter();
            this.activation_listeners.remove(downloadActivationListener);
            if (this.activation_listeners.size() == 0) {
                this.download_manager.removeActivationListener(this);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCompletionListener(DownloadCompletionListener downloadCompletionListener) {
        try {
            this.listeners_mon.enter();
            this.completion_listeners.add(downloadCompletionListener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCompletionListener(DownloadCompletionListener downloadCompletionListener) {
        try {
            this.listeners_mon.enter();
            this.completion_listeners.remove(downloadCompletionListener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public PeerManager getPeerManager() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager == null) {
            return null;
        }
        return PeerManagerImpl.getPeerManager(pEPeerManager);
    }

    @Override
    public DiskManager getDiskManager() {
        PeerManager peerManager = this.getPeerManager();
        if (peerManager != null) {
            return peerManager.getDiskManager();
        }
        return null;
    }

    @Override
    public org.gudy.azureus2.plugins.disk.DiskManagerFileInfo getDiskManagerFileInfo(int n) {
        DiskManagerFileInfo[] diskManagerFileInfoArray = this.download_manager.getDiskManagerFileInfo();
        if (diskManagerFileInfoArray == null) {
            return null;
        }
        if (n < 0 || n >= diskManagerFileInfoArray.length) {
            return null;
        }
        return new DiskManagerFileInfoImpl(this, diskManagerFileInfoArray[n]);
    }

    @Override
    public org.gudy.azureus2.plugins.disk.DiskManagerFileInfo[] getDiskManagerFileInfo() {
        DiskManagerFileInfo[] diskManagerFileInfoArray = this.download_manager.getDiskManagerFileInfo();
        if (diskManagerFileInfoArray == null) {
            return new org.gudy.azureus2.plugins.disk.DiskManagerFileInfo[0];
        }
        org.gudy.azureus2.plugins.disk.DiskManagerFileInfo[] diskManagerFileInfoArray2 = new org.gudy.azureus2.plugins.disk.DiskManagerFileInfo[diskManagerFileInfoArray.length];
        for (int i = 0; i < diskManagerFileInfoArray2.length; ++i) {
            diskManagerFileInfoArray2[i] = new DiskManagerFileInfoImpl(this, diskManagerFileInfoArray[i]);
        }
        return diskManagerFileInfoArray2;
    }

    @Override
    public void setMaximumDownloadKBPerSecond(int n) {
        if (n == -1) {
            Debug.out("setMaximiumDownloadKBPerSecond got value (-1) ZERO_DOWNLOAD. (-1)does not work through this method, use getDownloadRateLimitBytesPerSecond() instead.");
        }
        this.download_manager.getStats().setDownloadRateLimitBytesPerSecond(n < 0 ? 0 : n * 1024);
    }

    @Override
    public int getMaximumDownloadKBPerSecond() {
        return this.download_manager.getStats().getDownloadRateLimitBytesPerSecond() / 1024;
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return this.download_manager.getStats().getUploadRateLimitBytesPerSecond();
    }

    @Override
    public void setUploadRateLimitBytesPerSecond(int n) {
        this.download_manager.getStats().setUploadRateLimitBytesPerSecond(n);
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return this.download_manager.getStats().getDownloadRateLimitBytesPerSecond();
    }

    @Override
    public void setDownloadRateLimitBytesPerSecond(int n) {
        this.download_manager.getStats().setDownloadRateLimitBytesPerSecond(n);
    }

    @Override
    public int getSeedingRank() {
        return this.download_manager.getSeedingRank();
    }

    @Override
    public void setSeedingRank(int n) {
        this.download_manager.setSeedingRank(n);
    }

    @Override
    public String getSavePath() {
        return this.download_manager.getSaveLocation().toString();
    }

    @Override
    public void moveDataFiles(File file) throws DownloadException {
        try {
            this.download_manager.moveDataFiles(file);
        }
        catch (DownloadManagerException downloadManagerException) {
            throw new DownloadException("move operation failed", downloadManagerException);
        }
    }

    @Override
    public void moveDataFiles(File file, String string) throws DownloadException {
        try {
            this.download_manager.moveDataFiles(file, string);
        }
        catch (DownloadManagerException downloadManagerException) {
            throw new DownloadException("move / rename operation failed", downloadManagerException);
        }
    }

    @Override
    public void renameDownload(String string) throws DownloadException {
        try {
            this.download_manager.renameDownload(string);
        }
        catch (DownloadManagerException downloadManagerException) {
            throw new DownloadException("rename operation failed", downloadManagerException);
        }
    }

    @Override
    public void moveTorrentFile(File file) throws DownloadException {
        try {
            this.download_manager.moveTorrentFile(file);
        }
        catch (DownloadManagerException downloadManagerException) {
            throw new DownloadException("move operation failed", downloadManagerException);
        }
    }

    @Override
    public File[] calculateDefaultPaths(boolean bl) {
        SaveLocationChange saveLocationChange = this.calculateDefaultDownloadLocation();
        if (saveLocationChange == null) {
            return null;
        }
        return new File[]{saveLocationChange.download_location, saveLocationChange.torrent_location};
    }

    @Override
    public boolean isInDefaultSaveDir() {
        return this.download_manager.isInDefaultSaveDir();
    }

    @Override
    public void requestTrackerAnnounce() {
        this.download_manager.requestTrackerAnnounce(false);
    }

    @Override
    public void requestTrackerAnnounce(boolean bl) {
        this.download_manager.requestTrackerAnnounce(bl);
    }

    @Override
    public void requestTrackerScrape(boolean bl) {
        this.download_manager.requestTrackerScrape(bl);
    }

    @Override
    public byte[] getDownloadPeerId() {
        TRTrackerAnnouncer tRTrackerAnnouncer = this.download_manager.getTrackerClient();
        if (tRTrackerAnnouncer == null) {
            return null;
        }
        return tRTrackerAnnouncer.getPeerId();
    }

    @Override
    public boolean isMessagingEnabled() {
        return this.download_manager.isExtendedMessagingEnabled();
    }

    @Override
    public void setMessagingEnabled(boolean bl) {
        throw new RuntimeException("setMessagingEnabled is in the process of being removed - if you are seeing this error, let the Azureus developers know that you need this method to stay!");
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean isPriorityLocked() {
        return false;
    }

    @Override
    public void setPriority(int n) {
    }

    @Override
    public boolean isRemoved() {
        return this.download_manager.isDestroyed();
    }

    @Override
    public String getRelationText() {
        return this.propogatedRelationText(this.download_manager);
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.download_manager};
    }

    private CopyOnWriteMap getAttributeMapForType(int n) {
        return n == 2 ? this.read_attribute_listeners_map_cow : this.write_attribute_listeners_map_cow;
    }

    @Override
    public boolean canMoveDataFiles() {
        return this.download_manager.canMoveDataFiles();
    }

    @Override
    public void attributeEventOccurred(DownloadManager downloadManager, String string, int n) {
        CopyOnWriteMap copyOnWriteMap = this.getAttributeMapForType(n);
        TorrentAttribute torrentAttribute = this.convertAttribute(string);
        if (torrentAttribute == null) {
            return;
        }
        List list = null;
        list = ((CopyOnWriteList)copyOnWriteMap.get(string)).getList();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            DownloadAttributeListener downloadAttributeListener = (DownloadAttributeListener)list.get(i);
            try {
                downloadAttributeListener.attributeEventOccurred(this, torrentAttribute, n);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    @Override
    public SaveLocationChange calculateDefaultDownloadLocation() {
        return DownloadManagerMoveHandler.recalculatePath(this.download_manager);
    }

    @Override
    public Object getUserData(Object object) {
        return this.download_manager.getUserData(object);
    }

    @Override
    public void setUserData(Object object, Object object2) {
        this.download_manager.setUserData(object, object2);
    }

    @Override
    public void startDownload(boolean bl) {
        if (bl) {
            this.setForceStart(true);
            return;
        }
        this.setForceStart(false);
        int n = this.getState();
        if (n == 70 || n == 75) {
            this.download_manager.setStateWaiting();
        }
    }

    @Override
    public void stopDownload() {
        if (this.download_manager.getState() == 70) {
            return;
        }
        this.download_manager.stopIt(70, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeLocation(SaveLocationChange saveLocationChange) throws DownloadException {
        boolean bl;
        boolean bl2 = bl = saveLocationChange.hasDownloadChange() || saveLocationChange.hasTorrentChange();
        if (!bl) {
            return;
        }
        bl = saveLocationChange.isDifferentDownloadLocation(new File(this.getSavePath()));
        if (!bl) {
            bl = saveLocationChange.isDifferentTorrentLocation(new File(this.getTorrentFileName()));
        }
        if (!bl) {
            return;
        }
        boolean bl3 = !this.isPaused();
        try {
            try {
                if (saveLocationChange.hasDownloadChange()) {
                    this.download_manager.moveDataFiles(saveLocationChange.download_location, saveLocationChange.download_name);
                }
                if (saveLocationChange.hasTorrentChange()) {
                    this.download_manager.moveTorrentFile(saveLocationChange.torrent_location, saveLocationChange.torrent_name);
                }
            }
            catch (DownloadManagerException downloadManagerException) {
                throw new DownloadException(downloadManagerException.getMessage(), downloadManagerException);
            }
        }
        finally {
            if (bl3) {
                this.resume();
            }
        }
    }

    private static class PropertyListenerBridge
    implements DownloadAttributeListener {
        private DownloadPropertyListener l;

        public PropertyListenerBridge(DownloadPropertyListener downloadPropertyListener) {
            this.l = downloadPropertyListener;
        }

        @Override
        public void attributeEventOccurred(Download download, final TorrentAttribute torrentAttribute, final int n) {
            this.l.propertyChanged(download, new DownloadPropertyEvent(){

                @Override
                public int getType() {
                    return n;
                }

                @Override
                public Object getData() {
                    return torrentAttribute;
                }
            });
        }
    }
}

