/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.sharing;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.BrokenMd5Hasher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDeletionVetoException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDirContents;
import org.gudy.azureus2.plugins.sharing.ShareResourceEvent;
import org.gudy.azureus2.plugins.sharing.ShareResourceListener;
import org.gudy.azureus2.plugins.sharing.ShareResourceWillBeDeletedListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareItemImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;

public abstract class ShareResourceImpl
implements ShareResource {
    protected static BrokenMd5Hasher hasher = new BrokenMd5Hasher();
    protected ShareManagerImpl manager;
    protected int type;
    protected ShareResourceDirContents parent;
    protected Map attributes = new HashMap();
    protected List change_listeners = new ArrayList();
    protected List deletion_listeners = new ArrayList();

    protected ShareResourceImpl(ShareManagerImpl shareManagerImpl, int n) {
        this.manager = shareManagerImpl;
        this.type = n;
    }

    protected ShareResourceImpl(ShareManagerImpl shareManagerImpl, int n, Map map) {
        this.manager = shareManagerImpl;
        this.type = n;
        Map map2 = (Map)map.get("attributes");
        if (map2 != null) {
            for (String string : map2.keySet()) {
                try {
                    String string2 = new String((byte[])map2.get(string), "UTF8");
                    TorrentAttribute torrentAttribute = TorrentManagerImpl.getSingleton().getAttribute(string);
                    if (torrentAttribute == null) {
                        Debug.out("Invalid attribute '" + string);
                        continue;
                    }
                    this.attributes.put(torrentAttribute, string2);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    protected void serialiseResource(Map map) {
        Iterator iterator = this.attributes.keySet().iterator();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        map.put("attributes", hashMap);
        while (iterator.hasNext()) {
            TorrentAttribute torrentAttribute = (TorrentAttribute)iterator.next();
            String string = (String)this.attributes.get(torrentAttribute);
            try {
                if (string == null) continue;
                hashMap.put(torrentAttribute.getName(), string.getBytes("UTF8"));
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    @Override
    public ShareResourceDirContents getParent() {
        return this.parent;
    }

    protected void setParent(ShareResourceDirContents shareResourceDirContents) {
        this.parent = shareResourceDirContents;
    }

    public ShareResource[] getChildren() {
        return new ShareResource[0];
    }

    @Override
    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(final TorrentAttribute torrentAttribute, String string) {
        ShareConfigImpl shareConfigImpl = this.manager.getShareConfig();
        try {
            shareConfigImpl.suspendSaving();
            ShareResource[] shareResourceArray = this.getChildren();
            for (int i = 0; i < shareResourceArray.length; ++i) {
                shareResourceArray[i].setAttribute(torrentAttribute, string);
            }
            String string2 = (String)this.attributes.get(torrentAttribute);
            if (string2 == null && string == null) {
                return;
            }
            if (string2 != null && string != null && string2.equals(string)) {
                return;
            }
            this.attributes.put(torrentAttribute, string);
            try {
                shareConfigImpl.saveConfig();
            }
            catch (ShareException shareException) {
                Debug.printStackTrace(shareException);
            }
        }
        finally {
            try {
                shareConfigImpl.resumeSaving();
            }
            catch (ShareException shareException) {
                Debug.printStackTrace(shareException);
            }
        }
        for (int i = 0; i < this.change_listeners.size(); ++i) {
            try {
                ((ShareResourceListener)this.change_listeners.get(i)).shareResourceChanged(this, new ShareResourceEvent(){

                    @Override
                    public int getType() {
                        return 1;
                    }

                    @Override
                    public Object getData() {
                        return torrentAttribute;
                    }
                });
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    @Override
    public String getAttribute(TorrentAttribute torrentAttribute) {
        return (String)this.attributes.get(torrentAttribute);
    }

    @Override
    public TorrentAttribute[] getAttributes() {
        TorrentAttribute[] torrentAttributeArray = new TorrentAttribute[this.attributes.size()];
        this.attributes.keySet().toArray(torrentAttributeArray);
        return torrentAttributeArray;
    }

    protected void inheritAttributes(ShareResourceImpl shareResourceImpl) {
        TorrentAttribute[] torrentAttributeArray = shareResourceImpl.getAttributes();
        for (int i = 0; i < torrentAttributeArray.length; ++i) {
            this.setAttribute(torrentAttributeArray[i], shareResourceImpl.getAttribute(torrentAttributeArray[i]));
        }
    }

    @Override
    public void delete() throws ShareException, ShareResourceDeletionVetoException {
        if (this.getParent() != null) {
            throw new ShareResourceDeletionVetoException(MessageText.getString("plugin.sharing.remove.veto"));
        }
        this.delete(false);
    }

    @Override
    public void delete(boolean bl) throws ShareException, ShareResourceDeletionVetoException {
        this.delete(bl, true);
    }

    public void delete(boolean bl, boolean bl2) throws ShareException, ShareResourceDeletionVetoException {
        if (!bl) {
            this.canBeDeleted();
        }
        this.manager.delete(this, bl2);
    }

    @Override
    public abstract boolean canBeDeleted() throws ShareResourceDeletionVetoException;

    protected abstract void deleteInternal();

    protected byte[] getFingerPrint(File file) throws ShareException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            this.getFingerPrintSupport(stringBuffer, file, TorrentUtils.getIgnoreSet());
            return hasher.calculateHash(stringBuffer.toString().getBytes());
        }
        catch (ShareException shareException) {
            throw shareException;
        }
        catch (Throwable throwable) {
            throw new ShareException("ShareResource::getFingerPrint: fails", throwable);
        }
    }

    protected void getFingerPrintSupport(StringBuffer stringBuffer, File file, Set set) throws ShareException {
        block7: {
            try {
                if (file.isFile()) {
                    long l = file.lastModified();
                    long l2 = file.length();
                    String string = file.getName();
                    if (!set.contains(string.toLowerCase())) {
                        stringBuffer.append(string).append(":").append(l).append(":").append(l2);
                    }
                    break block7;
                }
                if (file.isDirectory()) {
                    File[] fileArray = file.listFiles();
                    ArrayList<File> arrayList = new ArrayList<File>(Arrays.asList(fileArray));
                    Collections.sort(arrayList);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        File file2 = (File)arrayList.get(i);
                        String string = file2.getName();
                        if (string.equals(".") || string.equals("..")) continue;
                        StringBuffer stringBuffer2 = new StringBuffer();
                        this.getFingerPrintSupport(stringBuffer2, file2, set);
                        if (stringBuffer2.length() <= 0) continue;
                        stringBuffer.append(":").append(stringBuffer2);
                    }
                    break block7;
                }
                throw new ShareException("ShareResource::getFingerPrint: '" + file.toString() + "' doesn't exist");
            }
            catch (Throwable throwable) {
                if (throwable instanceof ShareException) {
                    throw (ShareException)throwable;
                }
                Debug.printStackTrace(throwable);
                throw new ShareException("ShareResource::getFingerPrint: fails", throwable);
            }
        }
    }

    protected String getNewTorrentLocation() throws ShareException {
        return this.manager.getNewTorrentLocation();
    }

    protected void writeTorrent(ShareItemImpl shareItemImpl) throws ShareException {
        this.manager.writeTorrent(shareItemImpl);
    }

    protected void readTorrent(ShareItemImpl shareItemImpl) throws ShareException {
        this.manager.readTorrent(shareItemImpl);
    }

    protected void deleteTorrent(ShareItemImpl shareItemImpl) {
        this.manager.deleteTorrent(shareItemImpl);
    }

    public File getTorrentFile(ShareItemImpl shareItemImpl) {
        return this.manager.getTorrentFile(shareItemImpl);
    }

    protected abstract void checkConsistency() throws ShareException;

    @Override
    public void addChangeListener(ShareResourceListener shareResourceListener) {
        this.change_listeners.add(shareResourceListener);
    }

    @Override
    public void removeChangeListener(ShareResourceListener shareResourceListener) {
        this.change_listeners.remove(shareResourceListener);
    }

    @Override
    public void addDeletionListener(ShareResourceWillBeDeletedListener shareResourceWillBeDeletedListener) {
        this.deletion_listeners.add(shareResourceWillBeDeletedListener);
    }

    @Override
    public void removeDeletionListener(ShareResourceWillBeDeletedListener shareResourceWillBeDeletedListener) {
        this.deletion_listeners.remove(shareResourceWillBeDeletedListener);
    }
}

