/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerAuthenticationListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerFactory;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationAdapter;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationListener;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWCHelper;

public class TrackerWebContextImpl
extends TrackerWCHelper
implements TRTrackerServerListener2,
TRTrackerServerAuthenticationListener {
    protected TRTrackerServer server;
    protected List<TrackerAuthenticationListener> auth_listeners = new ArrayList<TrackerAuthenticationListener>();

    public TrackerWebContextImpl(TrackerImpl trackerImpl, String string, int n, int n2, InetAddress inetAddress) throws TrackerException {
        this.setTracker(trackerImpl);
        try {
            this.server = n2 == 1 ? TRTrackerServerFactory.create(string, 1, n, inetAddress, false, false) : TRTrackerServerFactory.createSSL(string, 1, n, inetAddress, false, false);
            this.server.addListener2(this);
        }
        catch (TRTrackerServerException tRTrackerServerException) {
            throw new TrackerException("TRTrackerServerFactory failed", tRTrackerServerException);
        }
    }

    @Override
    public String getName() {
        return this.server.getName();
    }

    @Override
    public void setEnableKeepAlive(boolean bl) {
        this.server.setEnableKeepAlive(bl);
    }

    @Override
    public URL[] getURLs() {
        try {
            URL uRL = new URL((this.server.isSSL() ? "https" : "http") + "://" + this.server.getHost() + ":" + this.server.getPort() + "/");
            if (uRL.getPort() != this.server.getPort()) {
                Debug.out("Invalid URL '" + uRL + "' - check tracker configuration");
                uRL = new URL("http://i.am.invalid:" + this.server.getPort() + "/");
            }
            return new URL[]{uRL};
        }
        catch (MalformedURLException malformedURLException) {
            Debug.printStackTrace(malformedURLException);
            return null;
        }
    }

    @Override
    public InetAddress getBindIP() {
        return this.server.getBindIP();
    }

    @Override
    public boolean authenticate(String string, URL uRL, String string2, String string3) {
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                TrackerAuthenticationListener trackerAuthenticationListener = this.auth_listeners.get(i);
                boolean bl = trackerAuthenticationListener instanceof TrackerAuthenticationAdapter ? ((TrackerAuthenticationAdapter)trackerAuthenticationListener).authenticate(string, uRL, string2, string3) : trackerAuthenticationListener.authenticate(uRL, string2, string3);
                if (!bl) continue;
                return true;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return false;
    }

    @Override
    public byte[] authenticate(URL uRL, String string) {
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                byte[] byArray = this.auth_listeners.get(i).authenticate(uRL, string);
                if (byArray == null) continue;
                return byArray;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAuthenticationListener(TrackerAuthenticationListener trackerAuthenticationListener) {
        try {
            this.this_mon.enter();
            this.auth_listeners.add(trackerAuthenticationListener);
            if (this.auth_listeners.size() == 1) {
                this.server.addAuthenticationListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAuthenticationListener(TrackerAuthenticationListener trackerAuthenticationListener) {
        try {
            this.this_mon.enter();
            this.auth_listeners.remove(trackerAuthenticationListener);
            if (this.auth_listeners.size() == 0) {
                this.server.removeAuthenticationListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.auth_listeners.clear();
        this.server.removeAuthenticationListener(this);
        this.server.close();
    }
}

