/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import java.util.HashMap;
import java.util.Set;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.pluginsimpl.local.ui.config.BooleanParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ColorParameter;
import org.gudy.azureus2.pluginsimpl.local.ui.config.DirectoryParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.FileParameter;
import org.gudy.azureus2.pluginsimpl.local.ui.config.IntParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.IntsParameter;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.StringListParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.StringParameterImpl;

public class ParameterRepository {
    private static ParameterRepository instance;
    private static AEMonitor class_mon;
    private HashMap params = new HashMap();

    private ParameterRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParameterRepository getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new ParameterRepository();
            }
            ParameterRepository parameterRepository = instance;
            return parameterRepository;
        }
        finally {
            class_mon.exit();
        }
    }

    public void addPlugin(Parameter[] parameterArray, String string) {
        this.params.put(string, parameterArray);
        ConfigurationDefaults configurationDefaults = ConfigurationDefaults.getInstance();
        if (configurationDefaults == null) {
            return;
        }
        for (int i = 0; i < parameterArray.length; ++i) {
            Parameter parameter = parameterArray[i];
            if (!(parameter instanceof ParameterImpl)) continue;
            String string2 = ((ParameterImpl)parameter).getKey();
            if (parameter instanceof StringParameterImpl) {
                configurationDefaults.addParameter(string2, ((StringParameterImpl)parameter).getDefaultValue());
                continue;
            }
            if (parameter instanceof IntParameterImpl) {
                configurationDefaults.addParameter(string2, ((IntParameterImpl)parameter).getDefaultValue());
                continue;
            }
            if (parameter instanceof BooleanParameterImpl) {
                configurationDefaults.addParameter(string2, ((BooleanParameterImpl)parameter).getDefaultValue());
                continue;
            }
            if (parameter instanceof FileParameter) {
                configurationDefaults.addParameter(string2, ((FileParameter)parameter).getDefaultValue());
                continue;
            }
            if (parameter instanceof DirectoryParameterImpl) {
                configurationDefaults.addParameter(string2, ((DirectoryParameterImpl)parameter).getDefaultValue());
                continue;
            }
            if (parameter instanceof IntsParameter) {
                configurationDefaults.addParameter(string2, ((IntsParameter)parameter).getDefaultValue());
                continue;
            }
            if (parameter instanceof StringListParameterImpl) {
                configurationDefaults.addParameter(string2, ((StringListParameterImpl)parameter).getDefaultValue());
                continue;
            }
            if (!(parameter instanceof ColorParameter)) continue;
            configurationDefaults.addParameter(string2 + ".red", ((ColorParameter)parameter).getDefaultRed());
            configurationDefaults.addParameter(string2 + ".green", ((ColorParameter)parameter).getDefaultGreen());
            configurationDefaults.addParameter(string2 + ".blue", ((ColorParameter)parameter).getDefaultBlue());
        }
    }

    public String[] getNames() {
        Set set = this.params.keySet();
        return set.toArray(new String[set.size()]);
    }

    public Parameter[] getParameterBlock(String string) {
        return (Parameter[])this.params.get(string);
    }

    static {
        class_mon = new AEMonitor("ParameterRepository:class");
    }
}

