/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils;

import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class UTTimerImpl
implements UTTimer {
    private PluginInterface plugin_interface;
    private Timer timer;
    private boolean destroyed;

    public UTTimerImpl(String string, boolean bl) {
        if (!bl) {
            this.timer = new Timer(string);
        }
    }

    protected UTTimerImpl(PluginInterface pluginInterface, String string, boolean bl) {
        this.plugin_interface = pluginInterface;
        if (!bl) {
            this.timer = new Timer("Plugin " + pluginInterface.getPluginID() + ":" + string);
        }
    }

    protected UTTimerImpl(PluginInterface pluginInterface, String string, int n) {
        this.plugin_interface = pluginInterface;
        this.timer = new Timer("Plugin " + pluginInterface.getPluginID() + ":" + string, 1, n);
    }

    @Override
    public UTTimerEvent addEvent(long l, final UTTimerEventPerformer uTTimerEventPerformer) {
        if (this.destroyed) {
            throw new RuntimeException("Timer has been destroyed");
        }
        final timerEvent timerEvent2 = new timerEvent();
        TimerEventPerformer timerEventPerformer = new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent timerEvent22) {
                UtilitiesImpl.callWithPluginThreadContext(UTTimerImpl.this.plugin_interface, new Runnable(){

                    @Override
                    public void run() {
                        timerEvent2.perform(uTTimerEventPerformer);
                    }
                });
            }
        };
        if (this.timer == null) {
            timerEvent2.setEvent(SimpleTimer.addEvent("Plugin:" + uTTimerEventPerformer.getClass(), l, timerEventPerformer));
        } else {
            timerEvent2.setEvent(this.timer.addEvent("Plugin:" + uTTimerEventPerformer.getClass(), l, timerEventPerformer));
        }
        return timerEvent2;
    }

    @Override
    public UTTimerEvent addPeriodicEvent(long l, final UTTimerEventPerformer uTTimerEventPerformer) {
        if (this.destroyed) {
            throw new RuntimeException("Timer has been destroyed");
        }
        final timerEvent timerEvent2 = new timerEvent();
        TimerEventPerformer timerEventPerformer = new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent timerEvent22) {
                UtilitiesImpl.callWithPluginThreadContext(UTTimerImpl.this.plugin_interface, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            timerEvent2.perform(uTTimerEventPerformer);
                        }
                        catch (Throwable throwable) {
                            Debug.out("Plugin '" + UTTimerImpl.this.plugin_interface.getPluginName() + " (" + UTTimerImpl.this.plugin_interface.getPluginID() + " " + UTTimerImpl.this.plugin_interface.getPluginVersion() + ") caused an error while processing a timer event", throwable);
                        }
                    }
                });
            }
        };
        if (this.timer == null) {
            timerEvent2.setEvent(SimpleTimer.addPeriodicEvent("Plugin:" + uTTimerEventPerformer.getClass(), l, timerEventPerformer));
        } else {
            timerEvent2.setEvent(this.timer.addPeriodicEvent("Plugin:" + uTTimerEventPerformer.getClass(), l, timerEventPerformer));
        }
        return timerEvent2;
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        if (this.timer != null) {
            this.timer.destroy();
        }
    }

    protected class timerEvent
    implements UTTimerEvent {
        protected TimerEvent ev;
        protected TimerEventPeriodic pev;

        protected timerEvent() {
        }

        protected void setEvent(TimerEventPeriodic timerEventPeriodic) {
            this.pev = timerEventPeriodic;
        }

        protected void setEvent(TimerEvent timerEvent2) {
            this.ev = timerEvent2;
        }

        protected void perform(UTTimerEventPerformer uTTimerEventPerformer) {
            uTTimerEventPerformer.perform(this);
        }

        @Override
        public void cancel() {
            if (this.ev != null) {
                this.ev.cancel();
            } else {
                this.pev.cancel();
            }
        }
    }
}

