/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote;

import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipfilter.IPFilter;
import org.gudy.azureus2.plugins.ipfilter.IPRange;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPPluginInterface;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestAccessController;
import org.gudy.azureus2.pluginsimpl.remote.rpexceptions.RPInternalProcessException;
import org.gudy.azureus2.pluginsimpl.remote.rpexceptions.RPNoObjectIDException;

public class RPRequestHandler {
    protected PluginInterface plugin_interface;
    protected Map reply_cache = new HashMap();

    public RPRequestHandler(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
    }

    public RPReply processRequest(RPRequest rPRequest) {
        return this.processRequest(rPRequest, null);
    }

    public RPReply processRequest(RPRequest rPRequest, RPRequestAccessController rPRequestAccessController) {
        replyCache replyCache2;
        Long l = new Long(rPRequest.getConnectionId());
        replyCache replyCache3 = replyCache2 = l == 0L ? null : (replyCache)this.reply_cache.get(l);
        if (replyCache2 != null && replyCache2.getId() == rPRequest.getRequestId()) {
            return replyCache2.getReply();
        }
        RPReply rPReply = this.processRequestSupport(rPRequest, rPRequestAccessController);
        if (rPReply == null) {
            rPReply = new RPReply(null);
        }
        this.reply_cache.put(l, new replyCache(rPRequest.getRequestId(), rPReply));
        return rPReply;
    }

    protected RPReply processRequestSupport(RPRequest rPRequest, RPRequestAccessController rPRequestAccessController) {
        try {
            RPObject rPObject = rPRequest.getObject();
            String string = rPRequest.getMethod();
            if (rPObject == null && string.equals("getSingleton")) {
                RPPluginInterface rPPluginInterface = rPRequest.createRemotePluginInterface(this.plugin_interface);
                RPReply rPReply = new RPReply(rPPluginInterface);
                return rPReply;
            }
            if (rPObject == null && string.equals("getDownloads")) {
                RPPluginInterface rPPluginInterface = rPRequest.createRemotePluginInterface(this.plugin_interface);
                RPObject rPObject2 = (RPObject)rPPluginInterface._process(new RPRequest(null, "getDownloadManager", null)).getResponse();
                RPReply rPReply = rPObject2._process(new RPRequest(null, "getDownloads", null));
                rPReply.setProperty("azureus_name", rPPluginInterface.azureus_name);
                rPReply.setProperty("azureus_version", rPPluginInterface.azureus_version);
                return rPReply;
            }
            if (rPObject == null) {
                throw new RPNoObjectIDException();
            }
            rPObject = RPObject._lookupLocal(rPObject._getOID());
            rPObject._setLocal();
            if (string.equals("_refresh")) {
                RPReply rPReply = new RPReply(rPObject);
                return rPReply;
            }
            String string2 = rPObject._getName();
            if (rPRequestAccessController != null) {
                rPRequestAccessController.checkAccess(string2, rPRequest);
            }
            RPReply rPReply = rPObject._process(rPRequest);
            if (string2.equals("IPFilter") && string.equals("setInRangeAddressesAreAllowed[boolean]") && rPRequest.getClientIP() != null) {
                String string3 = rPRequest.getClientIP();
                boolean bl = (Boolean)rPRequest.getParams()[0];
                LoggerChannel[] loggerChannelArray = this.plugin_interface.getLogger().getChannels();
                IPFilter iPFilter = this.plugin_interface.getIPFilter();
                if (bl) {
                    if (iPFilter.isInRange(string3)) {
                        for (int i = 0; i < loggerChannelArray.length; ++i) {
                            loggerChannelArray[i].log(1, "Adding range for client '" + string3 + "' as allow/deny flag changed to allow");
                        }
                        iPFilter.createAndAddRange("auto-added for remote interface", string3, string3, false);
                        iPFilter.save();
                        this.plugin_interface.getPluginconfig().save();
                    }
                } else {
                    IPRange[] iPRangeArray = iPFilter.getRanges();
                    for (int i = 0; i < iPRangeArray.length; ++i) {
                        if (!iPRangeArray[i].isInRange(string3)) continue;
                        for (int j = 0; j < loggerChannelArray.length; ++j) {
                            loggerChannelArray[j].log(1, "deleting range '" + iPRangeArray[i].getStartIP() + "-" + iPRangeArray[i].getEndIP() + "' for client '" + string3 + "' as allow/deny flag changed to deny");
                        }
                        iPRangeArray[i].delete();
                    }
                    iPFilter.save();
                    this.plugin_interface.getPluginconfig().save();
                }
            }
            return rPReply;
        }
        catch (RPException rPException) {
            return new RPReply(rPException);
        }
        catch (Exception exception) {
            throw new RPInternalProcessException(exception);
        }
    }

    protected static class replyCache {
        protected long id;
        protected RPReply reply;

        protected replyCache(long l, RPReply rPReply) {
            this.id = l;
            this.reply = rPReply;
        }

        protected long getId() {
            return this.id;
        }

        protected RPReply getReply() {
            return this.reply;
        }
    }
}

