/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.Utf8;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class RatingBox
extends AbstractFullBox {
    public static final String TYPE = "rtng";
    private String ratingEntity;
    private String ratingCriteria;
    private String language;
    private String ratingInfo;

    public RatingBox() {
        super(TYPE);
    }

    public void setRatingEntity(String string) {
        this.ratingEntity = string;
    }

    public void setRatingCriteria(String string) {
        this.ratingCriteria = string;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setRatingInfo(String string) {
        this.ratingInfo = string;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getRatingEntity() {
        return this.ratingEntity;
    }

    public String getRatingCriteria() {
        return this.ratingCriteria;
    }

    public String getRatingInfo() {
        return this.ratingInfo;
    }

    @Override
    protected long getContentSize() {
        return 15 + Utf8.utf8StringLengthInBytes(this.ratingInfo);
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.ratingEntity = IsoTypeReader.read4cc(byteBuffer);
        this.ratingCriteria = IsoTypeReader.read4cc(byteBuffer);
        this.language = IsoTypeReader.readIso639(byteBuffer);
        this.ratingInfo = IsoTypeReader.readString(byteBuffer);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        byteBuffer.put(IsoFile.fourCCtoBytes(this.ratingEntity));
        byteBuffer.put(IsoFile.fourCCtoBytes(this.ratingCriteria));
        IsoTypeWriter.writeIso639(byteBuffer, this.language);
        byteBuffer.put(Utf8.convert(this.ratingInfo));
        byteBuffer.put((byte)0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RatingBox[language=").append(this.getLanguage());
        stringBuilder.append("ratingEntity=").append(this.getRatingEntity());
        stringBuilder.append(";ratingCriteria=").append(this.getRatingCriteria());
        stringBuilder.append(";language=").append(this.getLanguage());
        stringBuilder.append(";ratingInfo=").append(this.getRatingInfo());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

