/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.Utf8;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class SchemeTypeBox
extends AbstractFullBox {
    public static final String TYPE = "schm";
    String schemeType = "    ";
    long schemeVersion;
    String schemeUri = null;

    public SchemeTypeBox() {
        super(TYPE);
    }

    public String getSchemeType() {
        return this.schemeType;
    }

    public long getSchemeVersion() {
        return this.schemeVersion;
    }

    public String getSchemeUri() {
        return this.schemeUri;
    }

    public void setSchemeType(String string) {
        assert (string != null && string.length() == 4) : "SchemeType may not be null or not 4 bytes long";
        this.schemeType = string;
    }

    public void setSchemeVersion(int n) {
        this.schemeVersion = n;
    }

    public void setSchemeUri(String string) {
        this.schemeUri = string;
    }

    @Override
    protected long getContentSize() {
        return 12 + ((this.getFlags() & 1) == 1 ? Utf8.utf8StringLengthInBytes(this.schemeUri) + 1 : 0);
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.schemeType = IsoTypeReader.read4cc(byteBuffer);
        this.schemeVersion = IsoTypeReader.readUInt32(byteBuffer);
        if ((this.getFlags() & 1) == 1) {
            this.schemeUri = IsoTypeReader.readString(byteBuffer);
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        byteBuffer.put(IsoFile.fourCCtoBytes(this.schemeType));
        IsoTypeWriter.writeUInt32(byteBuffer, this.schemeVersion);
        if ((this.getFlags() & 1) == 1) {
            byteBuffer.put(Utf8.convert(this.schemeUri));
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Schema Type Box[");
        stringBuilder.append("schemeUri=").append(this.schemeUri).append("; ");
        stringBuilder.append("schemeType=").append(this.schemeType).append("; ");
        stringBuilder.append("schemeVersion=").append(this.schemeUri).append("; ");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

