/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.adaptivestreaming;

import com.coremedia.iso.Hex;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.coremedia.iso.boxes.h264.AvcConfigurationBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.Version;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.adaptivestreaming.AbstractManifestWriter;
import com.googlecode.mp4parser.authoring.adaptivestreaming.AudioQuality;
import com.googlecode.mp4parser.authoring.adaptivestreaming.VideoQuality;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.boxes.DTSSpecificBox;
import com.googlecode.mp4parser.boxes.EC3SpecificBox;
import com.googlecode.mp4parser.boxes.mp4.ESDescriptorBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.AudioSpecificConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FlatManifestWriterImpl
extends AbstractManifestWriter {
    private static final Logger LOG = Logger.getLogger(FlatManifestWriterImpl.class.getName());

    protected FlatManifestWriterImpl(FragmentIntersectionFinder fragmentIntersectionFinder) {
        super(fragmentIntersectionFinder);
    }

    protected Document customizeManifest(Document document) {
        return document;
    }

    @Override
    public String getManifest(Movie movie) throws IOException {
        Object object;
        Object object2;
        Object n2;
        int element3;
        DocumentBuilder documentBuilder;
        Object parserConfigurationException;
        LinkedList<VideoQuality> linkedList = new LinkedList<VideoQuality>();
        long l = -1L;
        LinkedList<AudioQuality> linkedList2 = new LinkedList<AudioQuality>();
        long l2 = -1L;
        for (Track object52 : movie.getTracks()) {
            if (object52.getMediaHeaderBox() instanceof VideoMediaHeaderBox) {
                this.videoFragmentsDurations = this.checkFragmentsAlign(this.videoFragmentsDurations, this.calculateFragmentDurations(object52, movie));
                parserConfigurationException = object52.getSampleDescriptionBox();
                linkedList.add(this.getVideoQuality(object52, (VisualSampleEntry)((SampleDescriptionBox)parserConfigurationException).getSampleEntry()));
                if (l == -1L) {
                    l = object52.getTrackMetaData().getTimescale();
                } else assert (l == object52.getTrackMetaData().getTimescale());
            }
            if (!(object52.getMediaHeaderBox() instanceof SoundMediaHeaderBox)) continue;
            this.audioFragmentsDurations = this.checkFragmentsAlign(this.audioFragmentsDurations, this.calculateFragmentDurations(object52, movie));
            parserConfigurationException = object52.getSampleDescriptionBox();
            linkedList2.add(this.getAudioQuality(object52, (AudioSampleEntry)((SampleDescriptionBox)parserConfigurationException).getSampleEntry()));
            if (l2 == -1L) {
                l2 = object52.getTrackMetaData().getTimescale();
                continue;
            }
            assert (l2 == object52.getTrackMetaData().getTimescale());
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException2) {
            throw new IOException(parserConfigurationException2);
        }
        parserConfigurationException = documentBuilder.newDocument();
        Element element = parserConfigurationException.createElement("SmoothStreamingMedia");
        parserConfigurationException.appendChild(element);
        element.setAttribute("MajorVersion", "2");
        element.setAttribute("MinorVersion", "1");
        element.setAttribute("Duration", "0");
        element.appendChild(parserConfigurationException.createComment(Version.VERSION));
        Element element2 = parserConfigurationException.createElement("StreamIndex");
        element2.setAttribute("Type", "video");
        element2.setAttribute("TimeScale", Long.toString(l));
        element2.setAttribute("Chunks", Integer.toString(this.videoFragmentsDurations.length));
        element2.setAttribute("Url", "video/{bitrate}/{start time}");
        element2.setAttribute("QualityLevels", Integer.toString(linkedList.size()));
        element.appendChild(element2);
        for (element3 = 0; element3 < linkedList.size(); ++element3) {
            n2 = (VideoQuality)linkedList.get(element3);
            object2 = parserConfigurationException.createElement("QualityLevel");
            object2.setAttribute("Index", Integer.toString(element3));
            object2.setAttribute("Bitrate", Long.toString(((VideoQuality)n2).bitrate));
            object2.setAttribute("FourCC", ((VideoQuality)n2).fourCC);
            object2.setAttribute("MaxWidth", Long.toString(((VideoQuality)n2).width));
            object2.setAttribute("MaxHeight", Long.toString(((VideoQuality)n2).height));
            object2.setAttribute("CodecPrivateData", ((VideoQuality)n2).codecPrivateData);
            object2.setAttribute("NALUnitLengthField", Integer.toString(((VideoQuality)n2).nalLength));
            element2.appendChild((Node)object2);
        }
        for (element3 = 0; element3 < this.videoFragmentsDurations.length; ++element3) {
            n2 = parserConfigurationException.createElement("c");
            n2.setAttribute("n", Integer.toString(element3));
            n2.setAttribute("d", Long.toString(this.videoFragmentsDurations[element3]));
            element2.appendChild((Node)n2);
        }
        if (this.audioFragmentsDurations != null) {
            int stringWriter;
            Element dOMSource = parserConfigurationException.createElement("StreamIndex");
            dOMSource.setAttribute("Type", "audio");
            dOMSource.setAttribute("TimeScale", Long.toString(l2));
            dOMSource.setAttribute("Chunks", Integer.toString(this.audioFragmentsDurations.length));
            dOMSource.setAttribute("Url", "audio/{bitrate}/{start time}");
            dOMSource.setAttribute("QualityLevels", Integer.toString(linkedList2.size()));
            element.appendChild(dOMSource);
            for (stringWriter = 0; stringWriter < linkedList2.size(); ++stringWriter) {
                object2 = (AudioQuality)linkedList2.get(stringWriter);
                object = parserConfigurationException.createElement("QualityLevel");
                object.setAttribute("Index", Integer.toString(stringWriter));
                object.setAttribute("FourCC", ((AudioQuality)object2).fourCC);
                object.setAttribute("Bitrate", Long.toString(((AudioQuality)object2).bitrate));
                object.setAttribute("AudioTag", Integer.toString(((AudioQuality)object2).audioTag));
                object.setAttribute("SamplingRate", Long.toString(((AudioQuality)object2).samplingRate));
                object.setAttribute("Channels", Integer.toString(((AudioQuality)object2).channels));
                object.setAttribute("BitsPerSample", Integer.toString(((AudioQuality)object2).bitPerSample));
                object.setAttribute("PacketSize", Integer.toString(((AudioQuality)object2).packetSize));
                object.setAttribute("CodecPrivateData", ((AudioQuality)object2).codecPrivateData);
                dOMSource.appendChild((Node)object);
            }
            for (stringWriter = 0; stringWriter < this.audioFragmentsDurations.length; ++stringWriter) {
                object2 = parserConfigurationException.createElement("c");
                object2.setAttribute("n", Integer.toString(stringWriter));
                object2.setAttribute("d", Long.toString(this.audioFragmentsDurations[stringWriter]));
                dOMSource.appendChild((Node)object2);
            }
        }
        parserConfigurationException.setXmlStandalone(true);
        DOMSource dOMSource = new DOMSource(this.customizeManifest((Document)parserConfigurationException));
        StringWriter stringWriter = new StringWriter();
        object2 = new StreamResult(stringWriter);
        object = TransformerFactory.newInstance();
        try {
            Transformer transformer = ((TransformerFactory)object).newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, (Result)object2);
        }
        catch (TransformerConfigurationException transformerException) {
            throw new IOException(transformerException);
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException);
        }
        return stringWriter.getBuffer().toString();
    }

    private AudioQuality getAudioQuality(Track track, AudioSampleEntry audioSampleEntry) {
        if (this.getFormat(audioSampleEntry).equals("mp4a")) {
            return this.getAacAudioQuality(track, audioSampleEntry);
        }
        if (this.getFormat(audioSampleEntry).equals("ec-3")) {
            return this.getEc3AudioQuality(track, audioSampleEntry);
        }
        if (this.getFormat(audioSampleEntry).startsWith("dts")) {
            return this.getDtsAudioQuality(track, audioSampleEntry);
        }
        throw new InternalError("I don't know what to do with audio of type " + this.getFormat(audioSampleEntry));
    }

    private AudioQuality getAacAudioQuality(Track track, AudioSampleEntry audioSampleEntry) {
        AudioQuality audioQuality = new AudioQuality();
        ESDescriptorBox eSDescriptorBox = audioSampleEntry.getBoxes(ESDescriptorBox.class).get(0);
        AudioSpecificConfig audioSpecificConfig = eSDescriptorBox.getEsDescriptor().getDecoderConfigDescriptor().getAudioSpecificInfo();
        audioQuality.fourCC = audioSpecificConfig.getSbrPresentFlag() == 1 ? "AACH" : (audioSpecificConfig.getPsPresentFlag() == 1 ? "AACP" : "AACL");
        audioQuality.bitrate = this.getBitrate(track);
        audioQuality.audioTag = 255;
        audioQuality.samplingRate = audioSampleEntry.getSampleRate();
        audioQuality.channels = audioSampleEntry.getChannelCount();
        audioQuality.bitPerSample = audioSampleEntry.getSampleSize();
        audioQuality.packetSize = 4;
        audioQuality.codecPrivateData = this.getAudioCodecPrivateData(audioSpecificConfig);
        return audioQuality;
    }

    private AudioQuality getEc3AudioQuality(Track track, AudioSampleEntry audioSampleEntry) {
        Object object;
        EC3SpecificBox eC3SpecificBox = audioSampleEntry.getBoxes(EC3SpecificBox.class).get(0);
        if (eC3SpecificBox == null) {
            throw new RuntimeException("EC-3 track misses EC3SpecificBox!");
        }
        int n = 0;
        int n2 = 0;
        byte by = 0;
        byte by2 = 0;
        for (EC3SpecificBox.Entry object22 : eC3SpecificBox.getEntries()) {
            switch (object22.acmod) {
                case 0: {
                    n = (short)(n + 2);
                    throw new RuntimeException("Smooth Streaming doesn't support DDP 1+1 mode");
                }
                case 1: {
                    n = (short)(n + 1);
                    if (object22.num_dep_sub > 0) {
                        object = new DependentSubstreamMask(by, by2, object22).process();
                        by = (byte)(by | ((DependentSubstreamMask)object).getdWChannelMaskFirstByte());
                        by2 = (byte)(by2 | ((DependentSubstreamMask)object).getdWChannelMaskSecondByte());
                        break;
                    }
                    by = (byte)(by | 0x20);
                    break;
                }
                case 2: {
                    n = (short)(n + 2);
                    if (object22.num_dep_sub > 0) {
                        object = new DependentSubstreamMask(by, by2, object22).process();
                        by = (byte)(by | ((DependentSubstreamMask)object).getdWChannelMaskFirstByte());
                        by2 = (byte)(by2 | ((DependentSubstreamMask)object).getdWChannelMaskSecondByte());
                        break;
                    }
                    by = (byte)(by | 0xC0);
                    break;
                }
                case 3: {
                    n = (short)(n + 3);
                    if (object22.num_dep_sub > 0) {
                        object = new DependentSubstreamMask(by, by2, object22).process();
                        by = (byte)(by | ((DependentSubstreamMask)object).getdWChannelMaskFirstByte());
                        by2 = (byte)(by2 | ((DependentSubstreamMask)object).getdWChannelMaskSecondByte());
                        break;
                    }
                    by = (byte)(by | 0xE0);
                    break;
                }
                case 4: {
                    n = (short)(n + 3);
                    if (object22.num_dep_sub > 0) {
                        object = new DependentSubstreamMask(by, by2, object22).process();
                        by = (byte)(by | ((DependentSubstreamMask)object).getdWChannelMaskFirstByte());
                        by2 = (byte)(by2 | ((DependentSubstreamMask)object).getdWChannelMaskSecondByte());
                        break;
                    }
                    by = (byte)(by | 0xC0);
                    by2 = (byte)(by2 | 0x80);
                    break;
                }
                case 5: {
                    n = (short)(n + 4);
                    if (object22.num_dep_sub > 0) {
                        object = new DependentSubstreamMask(by, by2, object22).process();
                        by = (byte)(by | ((DependentSubstreamMask)object).getdWChannelMaskFirstByte());
                        by2 = (byte)(by2 | ((DependentSubstreamMask)object).getdWChannelMaskSecondByte());
                        break;
                    }
                    by = (byte)(by | 0xE0);
                    by2 = (byte)(by2 | 0x80);
                    break;
                }
                case 6: {
                    n = (short)(n + 4);
                    if (object22.num_dep_sub > 0) {
                        object = new DependentSubstreamMask(by, by2, object22).process();
                        by = (byte)(by | ((DependentSubstreamMask)object).getdWChannelMaskFirstByte());
                        by2 = (byte)(by2 | ((DependentSubstreamMask)object).getdWChannelMaskSecondByte());
                        break;
                    }
                    by = (byte)(by | 0xCC);
                    break;
                }
                case 7: {
                    n = (short)(n + 5);
                    if (object22.num_dep_sub > 0) {
                        object = new DependentSubstreamMask(by, by2, object22).process();
                        by = (byte)(by | ((DependentSubstreamMask)object).getdWChannelMaskFirstByte());
                        by2 = (byte)(by2 | ((DependentSubstreamMask)object).getdWChannelMaskSecondByte());
                        break;
                    }
                    by = (byte)(by | 0xEC);
                }
            }
            if (object22.lfeon != 1) continue;
            n2 = (short)(n2 + 1);
            by = (byte)(by | 0x10);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(22);
        byteBuffer.put(new byte[]{0, 6});
        byteBuffer.put(by);
        byteBuffer.put(by2);
        byteBuffer.put(new byte[]{0, 0});
        byteBuffer.put(new byte[]{-81, -121, -5, -89, 2, 45, -5, 66, -92, -44, 5, -51, -109, -124, 59, -35});
        ByteBuffer byteBuffer2 = ByteBuffer.allocate((int)eC3SpecificBox.getContentSize());
        eC3SpecificBox.getContent(byteBuffer2);
        object = new AudioQuality();
        ((AudioQuality)object).fourCC = "EC-3";
        ((AudioQuality)object).bitrate = this.getBitrate(track);
        ((AudioQuality)object).audioTag = 65534;
        ((AudioQuality)object).samplingRate = audioSampleEntry.getSampleRate();
        ((AudioQuality)object).channels = n + n2;
        ((AudioQuality)object).bitPerSample = 16;
        ((AudioQuality)object).packetSize = track.getSamples().get(0).limit();
        ((AudioQuality)object).codecPrivateData = Hex.encodeHex(byteBuffer.array()) + Hex.encodeHex(byteBuffer2.array());
        return object;
    }

    private AudioQuality getDtsAudioQuality(Track track, AudioSampleEntry audioSampleEntry) {
        DTSSpecificBox dTSSpecificBox = audioSampleEntry.getBoxes(DTSSpecificBox.class).get(0);
        if (dTSSpecificBox == null) {
            throw new RuntimeException("DTS track misses DTSSpecificBox!");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(22);
        int n = dTSSpecificBox.getFrameDuration();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 512;
                break;
            }
            case 1: {
                n2 = 1024;
                break;
            }
            case 2: {
                n2 = 2048;
                break;
            }
            case 3: {
                n2 = 4096;
            }
        }
        byteBuffer.put((byte)(n2 & 0xFF));
        byteBuffer.put((byte)(n2 >>> 8));
        int n3 = this.getNumChannelsAndMask(dTSSpecificBox)[1];
        byteBuffer.put((byte)(n3 & 0xFF));
        byteBuffer.put((byte)(n3 >>> 8));
        byteBuffer.put((byte)(n3 >>> 16));
        byteBuffer.put((byte)(n3 >>> 24));
        byteBuffer.put(new byte[]{-82, -28, -65, 94, 97, 94, 65, -121, -110, -4, -92, -127, 38, -103, 2, 17});
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(8);
        byteBuffer2.put((byte)dTSSpecificBox.getStreamConstruction());
        int n4 = dTSSpecificBox.getChannelLayout();
        byteBuffer2.put((byte)(n4 & 0xFF));
        byteBuffer2.put((byte)(n4 >>> 8));
        byteBuffer2.put((byte)(n4 >>> 16));
        byteBuffer2.put((byte)(n4 >>> 24));
        byte by = (byte)(dTSSpecificBox.getMultiAssetFlag() << 1);
        by = (byte)(by | dTSSpecificBox.getLBRDurationMod());
        byteBuffer2.put(by);
        byteBuffer2.put(new byte[]{0, 0});
        AudioQuality audioQuality = new AudioQuality();
        audioQuality.fourCC = this.getFormat(audioSampleEntry);
        audioQuality.bitrate = dTSSpecificBox.getAvgBitRate();
        audioQuality.audioTag = 65534;
        audioQuality.samplingRate = dTSSpecificBox.getDTSSamplingFrequency();
        audioQuality.channels = this.getNumChannelsAndMask(dTSSpecificBox)[0];
        audioQuality.bitPerSample = 16;
        audioQuality.packetSize = track.getSamples().get(0).limit();
        audioQuality.codecPrivateData = Hex.encodeHex(byteBuffer.array()) + Hex.encodeHex(byteBuffer2.array());
        return audioQuality;
    }

    private int[] getNumChannelsAndMask(DTSSpecificBox dTSSpecificBox) {
        int n = dTSSpecificBox.getChannelLayout();
        int n2 = 0;
        int n3 = 0;
        if ((n & 1) == 1) {
            ++n2;
            n3 |= 4;
        }
        if ((n & 2) == 2) {
            n2 += 2;
            n3 |= 1;
            n3 |= 2;
        }
        if ((n & 4) == 4) {
            n2 += 2;
            n3 |= 0x10;
            n3 |= 0x20;
        }
        if ((n & 8) == 8) {
            ++n2;
            n3 |= 8;
        }
        if ((n & 0x10) == 16) {
            ++n2;
            n3 |= 0x100;
        }
        if ((n & 0x20) == 32) {
            n2 += 2;
            n3 |= 0x1000;
            n3 |= 0x4000;
        }
        if ((n & 0x40) == 64) {
            n2 += 2;
            n3 |= 0x10;
            n3 |= 0x20;
        }
        if ((n & 0x80) == 128) {
            ++n2;
            n3 |= 0x2000;
        }
        if ((n & 0x100) == 256) {
            ++n2;
            n3 |= 0x800;
        }
        if ((n & 0x200) == 512) {
            n2 += 2;
            n3 |= 0x40;
            n3 |= 0x80;
        }
        if ((n & 0x400) == 1024) {
            n2 += 2;
            n3 |= 0x200;
            n3 |= 0x400;
        }
        if ((n & 0x800) == 2048) {
            n2 += 2;
            n3 |= 0x10;
            n3 |= 0x20;
        }
        if ((n & 0x1000) == 4096) {
            ++n2;
            n3 |= 8;
        }
        if ((n & 0x2000) == 8192) {
            n2 += 2;
            n3 |= 0x10;
            n3 |= 0x20;
        }
        if ((n & 0x4000) == 16384) {
            ++n2;
            n3 |= 0x10000;
        }
        if ((n & 0x8000) == 32768) {
            n2 += 2;
            n3 |= 0x8000;
            n3 |= 0x20000;
        }
        if ((n & 0x10000) == 65536) {
            ++n2;
        }
        if ((n & 0x20000) == 131072) {
            n2 += 2;
        }
        return new int[]{n2, n3};
    }

    private String getAudioCodecPrivateData(AudioSpecificConfig audioSpecificConfig) {
        byte[] byArray = audioSpecificConfig.getConfigBytes();
        return Hex.encodeHex(byArray);
    }

    private VideoQuality getVideoQuality(Track track, VisualSampleEntry visualSampleEntry) {
        if (!"avc1".equals(this.getFormat(visualSampleEntry))) {
            throw new InternalError("I don't know how to handle video of type " + this.getFormat(visualSampleEntry));
        }
        AvcConfigurationBox avcConfigurationBox = visualSampleEntry.getBoxes(AvcConfigurationBox.class).get(0);
        VideoQuality videoQuality = new VideoQuality();
        videoQuality.bitrate = this.getBitrate(track);
        videoQuality.codecPrivateData = Hex.encodeHex(this.getAvcCodecPrivateData(avcConfigurationBox));
        videoQuality.fourCC = "AVC1";
        videoQuality.width = visualSampleEntry.getWidth();
        videoQuality.height = visualSampleEntry.getHeight();
        videoQuality.nalLength = avcConfigurationBox.getLengthSizeMinusOne() + 1;
        return videoQuality;
    }

    private byte[] getAvcCodecPrivateData(AvcConfigurationBox avcConfigurationBox) {
        List<byte[]> list = avcConfigurationBox.getSequenceParameterSets();
        List<byte[]> list2 = avcConfigurationBox.getPictureParameterSets();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(new byte[]{0, 0, 0, 1});
            for (byte[] byArray : list) {
                byteArrayOutputStream.write(byArray);
            }
            byteArrayOutputStream.write(new byte[]{0, 0, 0, 1});
            for (byte[] byArray : list2) {
                byteArrayOutputStream.write(byArray);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("ByteArrayOutputStream do not throw IOException ?!?!?");
        }
        return byteArrayOutputStream.toByteArray();
    }

    private class DependentSubstreamMask {
        private byte dWChannelMaskFirstByte;
        private byte dWChannelMaskSecondByte;
        private EC3SpecificBox.Entry entry;

        public DependentSubstreamMask(byte by, byte by2, EC3SpecificBox.Entry entry) {
            this.dWChannelMaskFirstByte = by;
            this.dWChannelMaskSecondByte = by2;
            this.entry = entry;
        }

        public byte getdWChannelMaskFirstByte() {
            return this.dWChannelMaskFirstByte;
        }

        public byte getdWChannelMaskSecondByte() {
            return this.dWChannelMaskSecondByte;
        }

        public DependentSubstreamMask process() {
            switch (this.entry.chan_loc) {
                case 0: {
                    this.dWChannelMaskFirstByte = (byte)(this.dWChannelMaskFirstByte | 3);
                    break;
                }
                case 1: {
                    this.dWChannelMaskFirstByte = (byte)(this.dWChannelMaskFirstByte | 0xC);
                    break;
                }
                case 2: {
                    this.dWChannelMaskSecondByte = (byte)(this.dWChannelMaskSecondByte | 0x80);
                    break;
                }
                case 3: {
                    this.dWChannelMaskSecondByte = (byte)(this.dWChannelMaskSecondByte | 8);
                    break;
                }
                case 6: {
                    this.dWChannelMaskSecondByte = (byte)(this.dWChannelMaskSecondByte | 5);
                    break;
                }
                case 7: {
                    this.dWChannelMaskSecondByte = (byte)(this.dWChannelMaskSecondByte | 2);
                }
            }
            return this;
        }
    }
}

