/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.adaptivestreaming;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.adaptivestreaming.FlatManifestWriterImpl;
import com.googlecode.mp4parser.authoring.adaptivestreaming.ManifestWriter;
import com.googlecode.mp4parser.authoring.adaptivestreaming.PackageWriter;
import com.googlecode.mp4parser.authoring.builder.DefaultMp4Builder;
import com.googlecode.mp4parser.authoring.builder.FragmentedMp4Builder;
import com.googlecode.mp4parser.authoring.builder.SyncSampleIntersectFinderImpl;
import com.googlecode.mp4parser.authoring.tracks.ChangeTimeScaleTrack;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.logging.Logger;

public class FlatPackageWriterImpl
implements PackageWriter {
    private static Logger LOG = Logger.getLogger(FlatPackageWriterImpl.class.getName());
    long timeScale = 10000000L;
    private File outputDirectory;
    private boolean debugOutput;
    private FragmentedMp4Builder ismvBuilder = new FragmentedMp4Builder();
    ManifestWriter manifestWriter;

    public FlatPackageWriterImpl() {
        SyncSampleIntersectFinderImpl syncSampleIntersectFinderImpl = new SyncSampleIntersectFinderImpl();
        this.ismvBuilder.setIntersectionFinder(syncSampleIntersectFinderImpl);
        this.manifestWriter = new FlatManifestWriterImpl(syncSampleIntersectFinderImpl);
    }

    public FlatPackageWriterImpl(int n) {
        SyncSampleIntersectFinderImpl syncSampleIntersectFinderImpl = new SyncSampleIntersectFinderImpl(n);
        this.ismvBuilder.setIntersectionFinder(syncSampleIntersectFinderImpl);
        this.manifestWriter = new FlatManifestWriterImpl(syncSampleIntersectFinderImpl);
    }

    public void setOutputDirectory(File file) {
        assert (file.isDirectory());
        this.outputDirectory = file;
    }

    public void setDebugOutput(boolean bl) {
        this.debugOutput = bl;
    }

    public void setIsmvBuilder(FragmentedMp4Builder fragmentedMp4Builder) {
        this.ismvBuilder = fragmentedMp4Builder;
        this.manifestWriter = new FlatManifestWriterImpl(fragmentedMp4Builder.getFragmentIntersectionFinder());
    }

    public void setManifestWriter(ManifestWriter manifestWriter) {
        this.manifestWriter = manifestWriter;
    }

    @Override
    public void write(Movie movie) throws IOException {
        Object object;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (this.debugOutput) {
            this.outputDirectory.mkdirs();
            object6 = new DefaultMp4Builder();
            object5 = ((DefaultMp4Builder)object6).build(movie);
            object4 = new File(this.outputDirectory, "debug_1_muxed.mp4");
            object3 = new FileOutputStream((File)object4);
            ((IsoFile)object5).getBox(((FileOutputStream)object3).getChannel());
            ((FileOutputStream)object3).close();
        }
        object6 = this.removeUnknownTracks(movie);
        object5 = this.correctTimescale((Movie)object6);
        if (this.debugOutput) {
            object4 = new DefaultMp4Builder();
            object3 = ((DefaultMp4Builder)object4).build((Movie)object5);
            File object22 = new File(this.outputDirectory, "debug_2_timescale.mp4");
            object = new FileOutputStream(object22);
            ((IsoFile)object3).getBox(((FileOutputStream)object).getChannel());
            ((FileOutputStream)object).close();
        }
        object4 = this.ismvBuilder.build((Movie)object5);
        if (this.debugOutput) {
            object3 = new File(this.outputDirectory, "debug_3_fragmented.mp4");
            FileOutputStream fileOutputStream = new FileOutputStream((File)object3);
            ((IsoFile)object4).getBox(fileOutputStream.getChannel());
            fileOutputStream.close();
        }
        for (Track track : ((Movie)object5).getTracks()) {
            File file;
            object = Long.toString(this.manifestWriter.getBitrate(track));
            long l = track.getTrackMetaData().getTrackId();
            Iterator<Box> iterator = ((IsoFile)object4).getBoxes().iterator();
            if (track.getMediaHeaderBox() instanceof SoundMediaHeaderBox) {
                file = new File(this.outputDirectory, "audio");
            } else if (track.getMediaHeaderBox() instanceof VideoMediaHeaderBox) {
                file = new File(this.outputDirectory, "video");
            } else {
                System.err.println("Skipping Track with handler " + track.getHandler() + " and " + track.getMediaHeaderBox().getClass().getSimpleName());
                continue;
            }
            File file2 = new File(file, (String)object);
            file2.mkdirs();
            LOG.finer("Created : " + file2.getCanonicalPath());
            long[] lArray = this.manifestWriter.calculateFragmentDurations(track, (Movie)object5);
            long l2 = 0L;
            int n = 0;
            while (iterator.hasNext()) {
                Box box = iterator.next();
                if (!(box instanceof MovieFragmentBox)) continue;
                assert (((MovieFragmentBox)box).getTrackCount() == 1);
                if (((MovieFragmentBox)box).getTrackNumbers()[0] != l) continue;
                FileOutputStream fileOutputStream = new FileOutputStream(new File(file2, Long.toString(l2)));
                l2 += lArray[n++];
                FileChannel fileChannel = fileOutputStream.getChannel();
                Box box2 = iterator.next();
                assert (box2.getType().equals("mdat"));
                box.getBox(fileChannel);
                box2.getBox(fileChannel);
                fileChannel.truncate(fileChannel.position());
                fileChannel.close();
            }
        }
        object3 = new FileWriter(new File(this.outputDirectory, "Manifest"));
        ((Writer)object3).write(this.manifestWriter.getManifest((Movie)object5));
        ((OutputStreamWriter)object3).close();
    }

    private Movie removeUnknownTracks(Movie movie) {
        Movie movie2 = new Movie();
        for (Track track : movie.getTracks()) {
            if ("vide".equals(track.getHandler()) || "soun".equals(track.getHandler())) {
                movie2.addTrack(track);
                continue;
            }
            LOG.fine("Removed track " + track);
        }
        return movie2;
    }

    public Movie correctTimescale(Movie movie) {
        Movie movie2 = new Movie();
        for (Track track : movie.getTracks()) {
            movie2.addTrack(new ChangeTimeScaleTrack(track, this.timeScale, this.ismvBuilder.getFragmentIntersectionFinder().sampleNumbers(track, movie)));
        }
        return movie2;
    }
}

