/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.util.Math;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class SyncSampleIntersectFinderImpl
implements FragmentIntersectionFinder {
    private static Logger LOG = Logger.getLogger(SyncSampleIntersectFinderImpl.class.getName());
    private static Map<CacheTuple, long[]> getTimesCache = new ConcurrentHashMap<CacheTuple, long[]>();
    private static Map<CacheTuple, long[]> getSampleNumbersCache = new ConcurrentHashMap<CacheTuple, long[]>();
    private final int minFragmentDurationSeconds;

    public SyncSampleIntersectFinderImpl() {
        this.minFragmentDurationSeconds = 0;
    }

    public SyncSampleIntersectFinderImpl(int n) {
        this.minFragmentDurationSeconds = n;
    }

    @Override
    public long[] sampleNumbers(Track track, Movie movie) {
        CacheTuple cacheTuple = new CacheTuple(track, movie);
        long[] lArray = getSampleNumbersCache.get(cacheTuple);
        if (lArray != null) {
            return lArray;
        }
        if ("vide".equals(track.getHandler())) {
            if (track.getSyncSamples() != null && track.getSyncSamples().length > 0) {
                List<long[]> list = SyncSampleIntersectFinderImpl.getSyncSamplesTimestamps(movie, track);
                long[] lArray2 = this.getCommonIndices(track.getSyncSamples(), SyncSampleIntersectFinderImpl.getTimes(track, movie), track.getTrackMetaData().getTimescale(), (long[][])list.toArray((T[])new long[list.size()][]));
                getSampleNumbersCache.put(cacheTuple, lArray2);
                return lArray2;
            }
            throw new RuntimeException("Video Tracks need sync samples. Only tracks other than video may have no sync samples.");
        }
        if ("soun".equals(track.getHandler())) {
            Track track2 = null;
            for (Track track3 : movie.getTracks()) {
                if (track3.getSyncSamples() == null || !"vide".equals(track3.getHandler()) || track3.getSyncSamples().length <= 0) continue;
                track2 = track3;
            }
            if (track2 != null) {
                Object object2 = this.sampleNumbers(track2, movie);
                int n = track2.getSamples().size();
                long[] lArray3 = new long[((Object)object2).length];
                long l = 192000L;
                for (Track object3 : movie.getTracks()) {
                    AudioSampleEntry l5;
                    if (!"soun".equals(object3.getHandler()) || (l5 = (AudioSampleEntry)object3.getSampleDescriptionBox().getSampleEntry()).getSampleRate() >= l) continue;
                    l = l5.getSampleRate();
                    long i = object3.getSamples().size();
                    double d = (double)i / (double)n;
                    TimeToSampleBox.Entry entry = object3.getDecodingTimeEntries().get(0);
                    long l2 = entry.getDelta();
                    for (int j = 0; j < lArray3.length; ++j) {
                        long l3;
                        lArray3[j] = l3 = (long)java.lang.Math.ceil(d * (double)(object2[j] - 1L) * (double)l2);
                    }
                }
                AudioSampleEntry audioSampleEntry = (AudioSampleEntry)track.getSampleDescriptionBox().getSampleEntry();
                TimeToSampleBox.Entry d = track.getDecodingTimeEntries().get(0);
                long l4 = d.getDelta();
                double l6 = (double)audioSampleEntry.getSampleRate() / (double)l;
                if (l6 != java.lang.Math.rint(l6)) {
                    throw new RuntimeException("Sample rates must be a multiple of the lowest sample rate to create a correct file!");
                }
                for (int i = 0; i < lArray3.length; ++i) {
                    lArray3[i] = (long)(1.0 + (double)lArray3[i] * l6 / (double)l4);
                }
                getSampleNumbersCache.put(cacheTuple, lArray3);
                return lArray3;
            }
            throw new RuntimeException("There was absolutely no Track with sync samples. I can't work with that!");
        }
        for (Track track4 : movie.getTracks()) {
            if (track4.getSyncSamples() == null || track4.getSyncSamples().length <= 0) continue;
            long[] lArray4 = this.sampleNumbers(track4, movie);
            int n = track4.getSamples().size();
            long[] lArray5 = new long[lArray4.length];
            long l = track.getSamples().size();
            double d = (double)l / (double)n;
            for (int i = 0; i < lArray5.length; ++i) {
                long l5;
                lArray5[i] = l5 = (long)java.lang.Math.ceil(d * (double)(lArray4[i] - 1L)) + 1L;
            }
            getSampleNumbersCache.put(cacheTuple, lArray5);
            return lArray5;
        }
        throw new RuntimeException("There was absolutely no Track with sync samples. I can't work with that!");
    }

    public static List<long[]> getSyncSamplesTimestamps(Movie movie, Track track) {
        LinkedList<long[]> linkedList = new LinkedList<long[]>();
        for (Track track2 : movie.getTracks()) {
            long[] lArray;
            if (!track2.getHandler().equals(track.getHandler()) || (lArray = track2.getSyncSamples()) == null || lArray.length <= 0) continue;
            long[] lArray2 = SyncSampleIntersectFinderImpl.getTimes(track2, movie);
            linkedList.add(lArray2);
        }
        return linkedList;
    }

    public long[] getCommonIndices(long[] lArray, long[] lArray2, long l, long[] ... lArray3) {
        LinkedList<Long> linkedList = new LinkedList<Long>();
        LinkedList<Long> linkedList2 = new LinkedList<Long>();
        for (int i = 0; i < lArray2.length; ++i) {
            boolean bl = true;
            long[][] lArray4 = lArray3;
            int n = lArray4.length;
            for (int j = 0; j < n; ++j) {
                long[] lArray5 = lArray4[j];
                bl &= Arrays.binarySearch(lArray5, lArray2[i]) >= 0;
            }
            if (!bl) continue;
            linkedList.add(lArray[i]);
            linkedList2.add(lArray2[i]);
        }
        if ((double)linkedList.size() < (double)lArray.length * 0.25) {
            String string = "";
            string = string + String.format("%5d - Common:  [", linkedList.size());
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                long l2 = (Long)iterator.next();
                string = string + String.format("%10d,", l2);
            }
            string = string + "]";
            LOG.warning(string);
            string = "";
            string = string + String.format("%5d - In    :  [", lArray.length);
            for (Object object : (Iterator)lArray) {
                string = string + String.format("%10d,", (long)object);
            }
            string = string + "]";
            LOG.warning(string);
            LOG.warning("There are less than 25% of common sync samples in the given track.");
            throw new RuntimeException("There are less than 25% of common sync samples in the given track.");
        }
        if ((double)linkedList.size() < (double)lArray.length * 0.5) {
            LOG.fine("There are less than 50% of common sync samples in the given track. This is implausible but I'm ok to continue.");
        } else if (linkedList.size() < lArray.length) {
            LOG.finest("Common SyncSample positions vs. this tracks SyncSample positions: " + linkedList.size() + " vs. " + lArray.length);
        }
        LinkedList<Long> linkedList3 = new LinkedList<Long>();
        if (this.minFragmentDurationSeconds > 0) {
            long l3 = -1L;
            Iterator iterator = linkedList.iterator();
            Iterator iterator2 = linkedList2.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                long l4 = (Long)iterator.next();
                long l5 = (Long)iterator2.next();
                if (l3 != -1L && (l5 - l3) / l < (long)this.minFragmentDurationSeconds) continue;
                linkedList3.add(l4);
                l3 = l5;
            }
        } else {
            linkedList3 = linkedList;
        }
        long[] lArray6 = new long[linkedList3.size()];
        for (int i = 0; i < lArray6.length; ++i) {
            lArray6[i] = (Long)linkedList3.get(i);
        }
        return lArray6;
    }

    private static long[] getTimes(Track track, Movie movie) {
        CacheTuple cacheTuple = new CacheTuple(track, movie);
        long[] lArray = getTimesCache.get(cacheTuple);
        if (lArray != null) {
            return lArray;
        }
        long[] lArray2 = track.getSyncSamples();
        long[] lArray3 = new long[lArray2.length];
        LinkedList<TimeToSampleBox.Entry> linkedList = new LinkedList<TimeToSampleBox.Entry>(track.getDecodingTimeEntries());
        int n = 1;
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        long l3 = 0L;
        long l4 = SyncSampleIntersectFinderImpl.calculateTracktimesScalingFactor(movie, track);
        while ((long)n <= lArray2[lArray2.length - 1]) {
            if ((long)n++ == lArray2[n2]) {
                lArray3[n2++] = l * l4;
            }
            if (l3-- == 0L) {
                TimeToSampleBox.Entry entry = (TimeToSampleBox.Entry)linkedList.poll();
                l3 = entry.getCount() - 1L;
                l2 = entry.getDelta();
            }
            l += l2;
        }
        getTimesCache.put(cacheTuple, lArray3);
        return lArray3;
    }

    private static long calculateTracktimesScalingFactor(Movie movie, Track track) {
        long l = 1L;
        for (Track track2 : movie.getTracks()) {
            if (!track2.getHandler().equals(track.getHandler()) || track2.getTrackMetaData().getTimescale() == track.getTrackMetaData().getTimescale()) continue;
            l = Math.lcm(l, track2.getTrackMetaData().getTimescale());
        }
        return l;
    }

    public static class CacheTuple {
        Track track;
        Movie movie;

        public CacheTuple(Track track, Movie movie) {
            this.track = track;
            this.movie = movie;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CacheTuple cacheTuple = (CacheTuple)object;
            if (this.movie != null ? !this.movie.equals(cacheTuple.movie) : cacheTuple.movie != null) {
                return false;
            }
            return !(this.track != null ? !this.track.equals(cacheTuple.track) : cacheTuple.track != null);
        }

        public int hashCode() {
            int n = this.track != null ? this.track.hashCode() : 0;
            n = 31 * n + (this.movie != null ? this.movie.hashCode() : 0);
            return n;
        }
    }
}

