/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class CroppedTrack
extends AbstractTrack {
    Track origTrack;
    private int fromSample;
    private int toSample;
    private long[] syncSampleArray;

    public CroppedTrack(Track track, long l, long l2) {
        this.origTrack = track;
        assert (l <= Integer.MAX_VALUE);
        assert (l2 <= Integer.MAX_VALUE);
        this.fromSample = (int)l;
        this.toSample = (int)l2;
    }

    @Override
    public List<ByteBuffer> getSamples() {
        return this.origTrack.getSamples().subList(this.fromSample, this.toSample);
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.origTrack.getSampleDescriptionBox();
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return CroppedTrack.getDecodingTimeEntries(this.origTrack.getDecodingTimeEntries(), this.fromSample, this.toSample);
    }

    static List<TimeToSampleBox.Entry> getDecodingTimeEntries(List<TimeToSampleBox.Entry> list, long l, long l2) {
        if (list != null && !list.isEmpty()) {
            TimeToSampleBox.Entry entry;
            long l3 = 0L;
            ListIterator<TimeToSampleBox.Entry> listIterator = list.listIterator();
            LinkedList<TimeToSampleBox.Entry> linkedList = new LinkedList<TimeToSampleBox.Entry>();
            while ((entry = listIterator.next()).getCount() + l3 <= l) {
                l3 += entry.getCount();
            }
            if (entry.getCount() + l3 >= l2) {
                linkedList.add(new TimeToSampleBox.Entry(l2 - l, entry.getDelta()));
                return linkedList;
            }
            linkedList.add(new TimeToSampleBox.Entry(entry.getCount() + l3 - l, entry.getDelta()));
            l3 += entry.getCount();
            while (listIterator.hasNext() && (entry = listIterator.next()).getCount() + l3 < l2) {
                linkedList.add(entry);
                l3 += entry.getCount();
            }
            linkedList.add(new TimeToSampleBox.Entry(l2 - l3, entry.getDelta()));
            return linkedList;
        }
        return null;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return CroppedTrack.getCompositionTimeEntries(this.origTrack.getCompositionTimeEntries(), this.fromSample, this.toSample);
    }

    static List<CompositionTimeToSample.Entry> getCompositionTimeEntries(List<CompositionTimeToSample.Entry> list, long l, long l2) {
        if (list != null && !list.isEmpty()) {
            CompositionTimeToSample.Entry entry;
            long l3 = 0L;
            ListIterator<CompositionTimeToSample.Entry> listIterator = list.listIterator();
            ArrayList<CompositionTimeToSample.Entry> arrayList = new ArrayList<CompositionTimeToSample.Entry>();
            while ((long)(entry = listIterator.next()).getCount() + l3 <= l) {
                l3 += (long)entry.getCount();
            }
            if ((long)entry.getCount() + l3 >= l2) {
                arrayList.add(new CompositionTimeToSample.Entry((int)(l2 - l), entry.getOffset()));
                return arrayList;
            }
            arrayList.add(new CompositionTimeToSample.Entry((int)((long)entry.getCount() + l3 - l), entry.getOffset()));
            l3 += (long)entry.getCount();
            while (listIterator.hasNext() && (long)(entry = listIterator.next()).getCount() + l3 < l2) {
                arrayList.add(entry);
                l3 += (long)entry.getCount();
            }
            arrayList.add(new CompositionTimeToSample.Entry((int)(l2 - l3), entry.getOffset()));
            return arrayList;
        }
        return null;
    }

    @Override
    public synchronized long[] getSyncSamples() {
        if (this.origTrack.getSyncSamples() != null) {
            int n;
            long[] lArray = this.origTrack.getSyncSamples();
            int n2 = lArray.length;
            for (n = 0; n < lArray.length && lArray[n] < (long)this.fromSample; ++n) {
            }
            while (n2 > 0 && (long)this.toSample < lArray[n2 - 1]) {
                --n2;
            }
            this.syncSampleArray = Arrays.copyOfRange(this.origTrack.getSyncSamples(), n, n2);
            int n3 = 0;
            while (n3 < this.syncSampleArray.length) {
                int n4 = n3++;
                this.syncSampleArray[n4] = this.syncSampleArray[n4] - (long)this.fromSample;
            }
            return this.syncSampleArray;
        }
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        if (this.origTrack.getSampleDependencies() != null && !this.origTrack.getSampleDependencies().isEmpty()) {
            return this.origTrack.getSampleDependencies().subList(this.fromSample, this.toSample);
        }
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.origTrack.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.origTrack.getHandler();
    }

    @Override
    public Box getMediaHeaderBox() {
        return this.origTrack.getMediaHeaderBox();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.origTrack.getSubsampleInformationBox();
    }
}

