/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.UUID;

public abstract class AbstractTrackEncryptionBox
extends AbstractFullBox {
    int defaultAlgorithmId;
    int defaultIvSize;
    byte[] default_KID;

    protected AbstractTrackEncryptionBox(String string) {
        super(string);
    }

    public int getDefaultAlgorithmId() {
        return this.defaultAlgorithmId;
    }

    public void setDefaultAlgorithmId(int n) {
        this.defaultAlgorithmId = n;
    }

    public int getDefaultIvSize() {
        return this.defaultIvSize;
    }

    public void setDefaultIvSize(int n) {
        this.defaultIvSize = n;
    }

    public String getDefault_KID() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.default_KID);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return new UUID(byteBuffer.getLong(), byteBuffer.getLong()).toString();
    }

    public void setDefault_KID(byte[] byArray) {
        this.default_KID = byArray;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.defaultAlgorithmId = IsoTypeReader.readUInt24(byteBuffer);
        this.defaultIvSize = IsoTypeReader.readUInt8(byteBuffer);
        this.default_KID = new byte[16];
        byteBuffer.get(this.default_KID);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt24(byteBuffer, this.defaultAlgorithmId);
        IsoTypeWriter.writeUInt8(byteBuffer, this.defaultIvSize);
        byteBuffer.put(this.default_KID);
    }

    @Override
    protected long getContentSize() {
        return 24L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AbstractTrackEncryptionBox abstractTrackEncryptionBox = (AbstractTrackEncryptionBox)object;
        if (this.defaultAlgorithmId != abstractTrackEncryptionBox.defaultAlgorithmId) {
            return false;
        }
        if (this.defaultIvSize != abstractTrackEncryptionBox.defaultIvSize) {
            return false;
        }
        return Arrays.equals(this.default_KID, abstractTrackEncryptionBox.default_KID);
    }

    public int hashCode() {
        int n = this.defaultAlgorithmId;
        n = 31 * n + this.defaultIvSize;
        n = 31 * n + (this.default_KID != null ? Arrays.hashCode(this.default_KID) : 0);
        return n;
    }
}

