/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitWriterBuffer;
import java.nio.ByteBuffer;

public class DTSSpecificBox
extends AbstractBox {
    public static final String TYPE = "ddts";
    long DTSSamplingFrequency;
    long maxBitRate;
    long avgBitRate;
    int pcmSampleDepth;
    int frameDuration;
    int streamConstruction;
    int coreLFEPresent;
    int coreLayout;
    int coreSize;
    int stereoDownmix;
    int representationType;
    int channelLayout;
    int multiAssetFlag;
    int LBRDurationMod;
    int reservedBoxPresent;
    int reserved;

    public DTSSpecificBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return 20L;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.DTSSamplingFrequency = IsoTypeReader.readUInt32(byteBuffer);
        this.maxBitRate = IsoTypeReader.readUInt32(byteBuffer);
        this.avgBitRate = IsoTypeReader.readUInt32(byteBuffer);
        this.pcmSampleDepth = IsoTypeReader.readUInt8(byteBuffer);
        BitReaderBuffer bitReaderBuffer = new BitReaderBuffer(byteBuffer);
        this.frameDuration = bitReaderBuffer.readBits(2);
        this.streamConstruction = bitReaderBuffer.readBits(5);
        this.coreLFEPresent = bitReaderBuffer.readBits(1);
        this.coreLayout = bitReaderBuffer.readBits(6);
        this.coreSize = bitReaderBuffer.readBits(14);
        this.stereoDownmix = bitReaderBuffer.readBits(1);
        this.representationType = bitReaderBuffer.readBits(3);
        this.channelLayout = bitReaderBuffer.readBits(16);
        this.multiAssetFlag = bitReaderBuffer.readBits(1);
        this.LBRDurationMod = bitReaderBuffer.readBits(1);
        this.reservedBoxPresent = bitReaderBuffer.readBits(1);
        this.reserved = bitReaderBuffer.readBits(5);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        IsoTypeWriter.writeUInt32(byteBuffer, this.DTSSamplingFrequency);
        IsoTypeWriter.writeUInt32(byteBuffer, this.maxBitRate);
        IsoTypeWriter.writeUInt32(byteBuffer, this.avgBitRate);
        IsoTypeWriter.writeUInt8(byteBuffer, this.pcmSampleDepth);
        BitWriterBuffer bitWriterBuffer = new BitWriterBuffer(byteBuffer);
        bitWriterBuffer.writeBits(this.frameDuration, 2);
        bitWriterBuffer.writeBits(this.streamConstruction, 5);
        bitWriterBuffer.writeBits(this.coreLFEPresent, 1);
        bitWriterBuffer.writeBits(this.coreLayout, 6);
        bitWriterBuffer.writeBits(this.coreSize, 14);
        bitWriterBuffer.writeBits(this.stereoDownmix, 1);
        bitWriterBuffer.writeBits(this.representationType, 3);
        bitWriterBuffer.writeBits(this.channelLayout, 16);
        bitWriterBuffer.writeBits(this.multiAssetFlag, 1);
        bitWriterBuffer.writeBits(this.LBRDurationMod, 1);
        bitWriterBuffer.writeBits(this.reservedBoxPresent, 1);
        bitWriterBuffer.writeBits(this.reserved, 5);
    }

    public long getAvgBitRate() {
        return this.avgBitRate;
    }

    public void setAvgBitRate(long l) {
        this.avgBitRate = l;
    }

    public long getDTSSamplingFrequency() {
        return this.DTSSamplingFrequency;
    }

    public void setDTSSamplingFrequency(long l) {
        this.DTSSamplingFrequency = l;
    }

    public long getMaxBitRate() {
        return this.maxBitRate;
    }

    public void setMaxBitRate(long l) {
        this.maxBitRate = l;
    }

    public int getPcmSampleDepth() {
        return this.pcmSampleDepth;
    }

    public void setPcmSampleDepth(int n) {
        this.pcmSampleDepth = n;
    }

    public int getFrameDuration() {
        return this.frameDuration;
    }

    public void setFrameDuration(int n) {
        this.frameDuration = n;
    }

    public int getStreamConstruction() {
        return this.streamConstruction;
    }

    public void setStreamConstruction(int n) {
        this.streamConstruction = n;
    }

    public int getCoreLFEPresent() {
        return this.coreLFEPresent;
    }

    public void setCoreLFEPresent(int n) {
        this.coreLFEPresent = n;
    }

    public int getCoreLayout() {
        return this.coreLayout;
    }

    public void setCoreLayout(int n) {
        this.coreLayout = n;
    }

    public int getCoreSize() {
        return this.coreSize;
    }

    public void setCoreSize(int n) {
        this.coreSize = n;
    }

    public int getStereoDownmix() {
        return this.stereoDownmix;
    }

    public void setStereoDownmix(int n) {
        this.stereoDownmix = n;
    }

    public int getRepresentationType() {
        return this.representationType;
    }

    public void setRepresentationType(int n) {
        this.representationType = n;
    }

    public int getChannelLayout() {
        return this.channelLayout;
    }

    public void setChannelLayout(int n) {
        this.channelLayout = n;
    }

    public int getMultiAssetFlag() {
        return this.multiAssetFlag;
    }

    public void setMultiAssetFlag(int n) {
        this.multiAssetFlag = n;
    }

    public int getLBRDurationMod() {
        return this.LBRDurationMod;
    }

    public void setLBRDurationMod(int n) {
        this.LBRDurationMod = n;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int n) {
        this.reserved = n;
    }

    public int getReservedBoxPresent() {
        return this.reservedBoxPresent;
    }

    public void setReservedBoxPresent(int n) {
        this.reservedBoxPresent = n;
    }
}

