/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.IsoTypeReader;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ExtensionDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorBase;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class InitialObjectDescriptor
extends ObjectDescriptorBase {
    private int objectDescriptorId;
    int urlFlag;
    int includeInlineProfileLevelFlag;
    int urlLength;
    String urlString;
    int oDProfileLevelIndication;
    int sceneProfileLevelIndication;
    int audioProfileLevelIndication;
    int visualProfileLevelIndication;
    int graphicsProfileLevelIndication;
    List<ESDescriptor> esDescriptors = new ArrayList<ESDescriptor>();
    List<ExtensionDescriptor> extensionDescriptors = new ArrayList<ExtensionDescriptor>();
    List<BaseDescriptor> unknownDescriptors = new ArrayList<BaseDescriptor>();

    @Override
    public void parseDetail(ByteBuffer byteBuffer) throws IOException {
        BaseDescriptor baseDescriptor;
        int n = IsoTypeReader.readUInt16(byteBuffer);
        this.objectDescriptorId = (n & 0xFFC0) >> 6;
        this.urlFlag = (n & 0x3F) >> 5;
        this.includeInlineProfileLevelFlag = (n & 0x1F) >> 4;
        int n2 = this.getSize() - 2;
        if (this.urlFlag == 1) {
            this.urlLength = IsoTypeReader.readUInt8(byteBuffer);
            this.urlString = IsoTypeReader.readString(byteBuffer, this.urlLength);
            n2 -= 1 + this.urlLength;
        } else {
            this.oDProfileLevelIndication = IsoTypeReader.readUInt8(byteBuffer);
            this.sceneProfileLevelIndication = IsoTypeReader.readUInt8(byteBuffer);
            this.audioProfileLevelIndication = IsoTypeReader.readUInt8(byteBuffer);
            this.visualProfileLevelIndication = IsoTypeReader.readUInt8(byteBuffer);
            this.graphicsProfileLevelIndication = IsoTypeReader.readUInt8(byteBuffer);
            if ((n2 -= 5) > 2) {
                baseDescriptor = ObjectDescriptorFactory.createFrom(-1, byteBuffer);
                n2 -= baseDescriptor.getSize();
                if (baseDescriptor instanceof ESDescriptor) {
                    this.esDescriptors.add((ESDescriptor)baseDescriptor);
                } else {
                    this.unknownDescriptors.add(baseDescriptor);
                }
            }
        }
        if (n2 > 2) {
            baseDescriptor = ObjectDescriptorFactory.createFrom(-1, byteBuffer);
            if (baseDescriptor instanceof ExtensionDescriptor) {
                this.extensionDescriptors.add((ExtensionDescriptor)baseDescriptor);
            } else {
                this.unknownDescriptors.add(baseDescriptor);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("InitialObjectDescriptor");
        stringBuilder.append("{objectDescriptorId=").append(this.objectDescriptorId);
        stringBuilder.append(", urlFlag=").append(this.urlFlag);
        stringBuilder.append(", includeInlineProfileLevelFlag=").append(this.includeInlineProfileLevelFlag);
        stringBuilder.append(", urlLength=").append(this.urlLength);
        stringBuilder.append(", urlString='").append(this.urlString).append('\'');
        stringBuilder.append(", oDProfileLevelIndication=").append(this.oDProfileLevelIndication);
        stringBuilder.append(", sceneProfileLevelIndication=").append(this.sceneProfileLevelIndication);
        stringBuilder.append(", audioProfileLevelIndication=").append(this.audioProfileLevelIndication);
        stringBuilder.append(", visualProfileLevelIndication=").append(this.visualProfileLevelIndication);
        stringBuilder.append(", graphicsProfileLevelIndication=").append(this.graphicsProfileLevelIndication);
        stringBuilder.append(", esDescriptors=").append(this.esDescriptors);
        stringBuilder.append(", extensionDescriptors=").append(this.extensionDescriptors);
        stringBuilder.append(", unknownDescriptors=").append(this.unknownDescriptors);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

