/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.samplegrouping;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class SampleToGroupBox
extends AbstractFullBox {
    public static final String TYPE = "sbgp";
    private String groupingType;
    private String groupingTypeParameter;
    List<Entry> entries = new LinkedList<Entry>();

    public SampleToGroupBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return this.getVersion() == 1 ? (long)(this.entries.size() * 8 + 16) : (long)(this.entries.size() * 8 + 12);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        byteBuffer.put(this.groupingType.getBytes());
        if (this.getVersion() == 1) {
            byteBuffer.put(this.groupingTypeParameter.getBytes());
        }
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        for (Entry entry : this.entries) {
            IsoTypeWriter.writeUInt32(byteBuffer, entry.getSampleCount());
            IsoTypeWriter.writeUInt32(byteBuffer, entry.getGroupDescriptionIndex());
        }
    }

    @Override
    protected void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.groupingType = IsoTypeReader.read4cc(byteBuffer);
        if (this.getVersion() == 1) {
            this.groupingTypeParameter = IsoTypeReader.read4cc(byteBuffer);
        }
        long l = IsoTypeReader.readUInt32(byteBuffer);
        while (l-- > 0L) {
            this.entries.add(new Entry(CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer)), CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer))));
        }
    }

    public String getGroupingType() {
        return this.groupingType;
    }

    public void setGroupingType(String string) {
        this.groupingType = string;
    }

    public String getGroupingTypeParameter() {
        return this.groupingTypeParameter;
    }

    public void setGroupingTypeParameter(String string) {
        this.groupingTypeParameter = string;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    public static class Entry {
        private long sampleCount;
        private int groupDescriptionIndex;

        public Entry(long l, int n) {
            this.sampleCount = l;
            this.groupDescriptionIndex = n;
        }

        public long getSampleCount() {
            return this.sampleCount;
        }

        public void setSampleCount(long l) {
            this.sampleCount = l;
        }

        public int getGroupDescriptionIndex() {
            return this.groupDescriptionIndex;
        }

        public void setGroupDescriptionIndex(int n) {
            this.groupDescriptionIndex = n;
        }

        public String toString() {
            return "Entry{sampleCount=" + this.sampleCount + ", groupDescriptionIndex=" + this.groupDescriptionIndex + '}';
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Entry entry = (Entry)object;
            if (this.groupDescriptionIndex != entry.groupDescriptionIndex) {
                return false;
            }
            return this.sampleCount == entry.sampleCount;
        }

        public int hashCode() {
            int n = (int)(this.sampleCount ^ this.sampleCount >>> 32);
            n = 31 * n + this.groupDescriptionIndex;
            return n;
        }
    }
}

