/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.samplegrouping;

import com.googlecode.mp4parser.boxes.mp4.samplegrouping.GroupEntry;
import java.nio.ByteBuffer;

public class VisualRandomAccessEntry
extends GroupEntry {
    public static final String TYPE = "rap ";
    private boolean numLeadingSamplesKnown;
    private short numLeadingSamples;

    public boolean isNumLeadingSamplesKnown() {
        return this.numLeadingSamplesKnown;
    }

    public void setNumLeadingSamplesKnown(boolean bl) {
        this.numLeadingSamplesKnown = bl;
    }

    public short getNumLeadingSamples() {
        return this.numLeadingSamples;
    }

    public void setNumLeadingSamples(short s) {
        this.numLeadingSamples = s;
    }

    @Override
    public void parse(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        this.numLeadingSamplesKnown = (by & 0x80) == 128;
        this.numLeadingSamples = (short)(by & 0x7F);
    }

    @Override
    public ByteBuffer get() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        byteBuffer.put((byte)((this.numLeadingSamplesKnown ? 128 : 0) | this.numLeadingSamples & 0x7F));
        byteBuffer.rewind();
        return byteBuffer;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VisualRandomAccessEntry visualRandomAccessEntry = (VisualRandomAccessEntry)object;
        if (this.numLeadingSamples != visualRandomAccessEntry.numLeadingSamples) {
            return false;
        }
        return this.numLeadingSamplesKnown == visualRandomAccessEntry.numLeadingSamplesKnown;
    }

    public int hashCode() {
        int n = this.numLeadingSamplesKnown ? 1 : 0;
        n = 31 * n + this.numLeadingSamples;
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("VisualRandomAccessEntry");
        stringBuilder.append("{numLeadingSamplesKnown=").append(this.numLeadingSamplesKnown);
        stringBuilder.append(", numLeadingSamples=").append(this.numLeadingSamples);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

