/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.piff;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class TfxdBox
extends AbstractFullBox {
    public long fragmentAbsoluteTime;
    public long fragmentAbsoluteDuration;

    public TfxdBox() {
        super("uuid");
    }

    @Override
    public byte[] getUserType() {
        return new byte[]{109, 29, -101, 5, 66, -43, 68, -26, -128, -30, 20, 29, -81, -9, 87, -78};
    }

    @Override
    protected long getContentSize() {
        return this.getVersion() == 1 ? 20L : 12L;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        if (this.getVersion() == 1) {
            this.fragmentAbsoluteTime = IsoTypeReader.readUInt64(byteBuffer);
            this.fragmentAbsoluteDuration = IsoTypeReader.readUInt64(byteBuffer);
        } else {
            this.fragmentAbsoluteTime = IsoTypeReader.readUInt32(byteBuffer);
            this.fragmentAbsoluteDuration = IsoTypeReader.readUInt32(byteBuffer);
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        if (this.getVersion() == 1) {
            IsoTypeWriter.writeUInt64(byteBuffer, this.fragmentAbsoluteTime);
            IsoTypeWriter.writeUInt64(byteBuffer, this.fragmentAbsoluteDuration);
        } else {
            IsoTypeWriter.writeUInt32(byteBuffer, this.fragmentAbsoluteTime);
            IsoTypeWriter.writeUInt32(byteBuffer, this.fragmentAbsoluteDuration);
        }
    }

    public long getFragmentAbsoluteTime() {
        return this.fragmentAbsoluteTime;
    }

    public long getFragmentAbsoluteDuration() {
        return this.fragmentAbsoluteDuration;
    }
}

