/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.util;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class LazyList<E>
extends AbstractList<E> {
    List<E> underlying;
    Iterator<E> elementSource;

    public LazyList(List<E> list, Iterator<E> iterator) {
        this.underlying = list;
        this.elementSource = iterator;
    }

    public List<E> getUnderlying() {
        return this.underlying;
    }

    private void blowup() {
        while (this.elementSource.hasNext()) {
            this.underlying.add(this.elementSource.next());
        }
    }

    @Override
    public E get(int n) {
        if (this.underlying.size() > n) {
            return this.underlying.get(n);
        }
        if (this.elementSource.hasNext()) {
            this.underlying.add(this.elementSource.next());
            return this.get(n);
        }
        throw new NoSuchElementException();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < LazyList.this.underlying.size() || LazyList.this.elementSource.hasNext();
            }

            @Override
            public E next() {
                if (this.pos < LazyList.this.underlying.size()) {
                    return LazyList.this.underlying.get(this.pos++);
                }
                LazyList.this.underlying.add(LazyList.this.elementSource.next());
                return this.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        this.blowup();
        return this.underlying.size();
    }
}

