/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria;

import com.frostwire.alexandria.IcyInputStream;
import com.frostwire.alexandria.db.InternetRadioStationsData;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RadioImportTool {
    public static void main(String[] stringArray) throws Exception {
        RadioImportTool.run0(0);
    }

    public static void run0(int n) throws Exception {
        String string;
        InternetRadioStationsData internetRadioStationsData = new InternetRadioStationsData();
        FileInputStream fileInputStream = new FileInputStream("pls.txt");
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
        PrintWriter printWriter = new PrintWriter("output.txt", "UTF-8");
        int n2 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            try {
                if (n2 < n) {
                    ++n2;
                    continue;
                }
                RadioImportTool.processPls(n2, string, printWriter, internetRadioStationsData.nameSet);
            }
            catch (Exception exception) {
                System.out.println("Error for: " + string);
                exception.printStackTrace();
            }
            ++n2;
        }
        dataInputStream.close();
        printWriter.close();
        System.out.println("Total: " + n2);
    }

    public static void run1() throws Exception {
        RadioImportTool.processPls(0, "http://yp.shoutcast.com/sbin/tunein-station.pls?id=98179", new PrintWriter(System.out), new HashSet<String>());
    }

    public static void run2() throws Exception {
        InternetRadioStationsData internetRadioStationsData = new InternetRadioStationsData();
        List<List<Object>> list = internetRadioStationsData.getData();
        PrintWriter printWriter = new PrintWriter("output.txt", "UTF-8");
        int n = 0;
        for (List<Object> list2 : list) {
            String string = (String)list2.get(2);
            try {
                RadioImportTool.writeData(printWriter, string, internetRadioStationsData.nameSet);
                printWriter.println("\"\");");
            }
            catch (Exception exception) {
                System.out.println(" Error for: " + string);
            }
            ++n;
        }
        printWriter.close();
        System.out.println("Total: " + n);
    }

    private static void processPls(int n, String string, PrintWriter printWriter, Set<String> set) throws Exception {
        String string2;
        URL uRL = new URL(string);
        System.out.print(n + " - " + string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(10000);
        InputStream inputStream = uRLConnection.getInputStream();
        BufferedReader bufferedReader = null;
        bufferedReader = uRLConnection.getContentEncoding() != null ? new BufferedReader(new InputStreamReader(inputStream, uRLConnection.getContentEncoding())) : new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String string3 = "";
        String string4 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            string3 = string3 + string2 + "\\n";
            if (!string2.startsWith("File1=")) continue;
            String string5 = string2.split("=")[1];
            string4 = RadioImportTool.writeData(printWriter, string5, set);
        }
        string3 = "";
        if (string4 != null) {
            printWriter.println("\"" + string3 + "\");");
        }
        inputStream.close();
    }

    private static String writeData(PrintWriter printWriter, String string, Set<String> set) throws Exception {
        String string2 = RadioImportTool.processIcyStream(string, set);
        if (string2 == null) {
            return null;
        }
        System.out.println(string2);
        System.out.println();
        printWriter.print(string2);
        printWriter.flush();
        return string2;
    }

    private static String clean(String string) {
        return string.trim().replace("\"", "\\\"");
    }

    private static String processIcyStream(String string, Set<String> set) throws Exception {
        System.out.print(" - " + string);
        IcyInputStream.Track track = new IcyInputStream.Track();
        IcyInputStream.create(string, track);
        String string2 = RadioImportTool.clean(track.name);
        String string3 = RadioImportTool.clean(track.genre);
        String string4 = RadioImportTool.clean(track.url);
        String string5 = "";
        String string6 = track.bitrate != null ? track.bitrate.trim() + " kbps" : "";
        String string7 = track.contentType;
        if (string7.equals("audio/aacp")) {
            string5 = "AAC+";
        } else if (string7.equals("audio/mpeg")) {
            string5 = "MP3";
        } else if (string7.equals("audio/aac")) {
            string5 = "AAC";
        }
        if (set.contains(string2)) {
            return null;
        }
        set.add(string2);
        return "        add(data, \"" + string2 + "\", \"" + string2 + "\", \"" + string + "\", \"" + string6 + "\", \"" + string5 + "\", \"" + string4 + "\", \"" + string3 + "\", ";
    }
}

