/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria.db;

import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.alexandria.db.LibraryDatabase;
import com.frostwire.alexandria.db.PlaylistItemDB;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PlaylistDB {
    private PlaylistDB() {
    }

    public static void fill(LibraryDatabase libraryDatabase, Playlist playlist) {
        List<List<Object>> list = libraryDatabase.query("SELECT playlistId, name, description FROM Playlists WHERE playlistId = ?", playlist.getId());
        if (list.size() > 0) {
            List<Object> list2 = list.get(0);
            PlaylistDB.fill(list2, playlist);
        }
    }

    public static void fill(List<Object> list, Playlist playlist) {
        int n = (Integer)list.get(0);
        String string = (String)list.get(1);
        String string2 = (String)list.get(2);
        playlist.setId(n);
        playlist.setName(string);
        playlist.setDescription(string2);
        playlist.refresh();
    }

    public static void save(LibraryDatabase libraryDatabase, Playlist playlist) {
        if (playlist.getId() == -2) {
            return;
        }
        if (playlist.getId() == -1) {
            int n = libraryDatabase.insert("INSERT INTO Playlists (name, description) VALUES (LEFT(?, 500), LEFT(?, 10000))", playlist.getName(), playlist.getDescription());
            playlist.setId(n);
        } else {
            libraryDatabase.update("DELETE FROM PlaylistItems WHERE playlistId = ?", playlist.getId());
            Object[] objectArray = PlaylistDB.createPlaylistUpdateStatement(playlist);
            libraryDatabase.update((String)objectArray[0], (Object[])objectArray[1]);
        }
        ArrayList<PlaylistItem> arrayList = new ArrayList<PlaylistItem>(playlist.getItems());
        for (PlaylistItem playlistItem : arrayList) {
            playlistItem.setId(-1);
            playlistItem.save();
        }
    }

    public static void delete(LibraryDatabase libraryDatabase, Playlist playlist) {
        libraryDatabase.update("DELETE FROM PlaylistItems WHERE playlistId = ?", playlist.getId());
        libraryDatabase.update("DELETE FROM Playlists WHERE playlistId = ?", playlist.getId());
    }

    public static List<Playlist> getPlaylists(LibraryDatabase libraryDatabase) {
        List<List<Object>> list = libraryDatabase.query("SELECT playlistId, name, description FROM Playlists", new Object[0]);
        ArrayList<Playlist> arrayList = new ArrayList<Playlist>(list.size());
        for (List<Object> list2 : list) {
            Playlist playlist = new Playlist(libraryDatabase);
            PlaylistDB.fill(list2, playlist);
            arrayList.add(playlist);
        }
        return arrayList;
    }

    public static Playlist getPlaylist(LibraryDatabase libraryDatabase, String string) {
        List<List<Object>> list = libraryDatabase.query("SELECT playlistId, name, description FROM Playlists WHERE name = ?", string);
        Playlist playlist = null;
        if (list.size() > 0) {
            List<Object> list2 = list.get(0);
            playlist = new Playlist(libraryDatabase);
            PlaylistDB.fill(list2, playlist);
        }
        return playlist;
    }

    public static Playlist getStarredPlaylist(LibraryDatabase libraryDatabase) {
        String string = "SELECT playlistItemId, filePath, fileName, fileSize, fileExtension, trackTitle, trackDurationInSecs, trackArtist, trackAlbum, coverArtPath, trackBitrate, trackComment, trackGenre, trackNumber, trackYear, starred FROM PlaylistItems WHERE starred = ?";
        List<List<Object>> list = libraryDatabase.query(string, true);
        Playlist playlist = new Playlist(libraryDatabase, -3, "starred", "starred");
        ArrayList<PlaylistItem> arrayList = new ArrayList<PlaylistItem>(list.size());
        HashSet<String> hashSet = new HashSet<String>();
        for (List<Object> list2 : list) {
            PlaylistItem playlistItem = new PlaylistItem(playlist);
            PlaylistItemDB.fill(list2, playlistItem);
            if (hashSet.contains(playlistItem.getFilePath())) continue;
            arrayList.add(playlistItem);
            hashSet.add(playlistItem.getFilePath());
        }
        playlist.getItems().addAll(arrayList);
        return playlist;
    }

    public static void updatePlaylistItemProperties(LibraryDatabase libraryDatabase, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        Object[] objectArray = PlaylistDB.createPlaylistItemPropertiesUpdate(string, string2, string3, string4, string5, string6, string7, string8);
        libraryDatabase.update((String)objectArray[0], (Object[])objectArray[1]);
    }

    private static Object[] createPlaylistItemPropertiesUpdate(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        String string9 = "UPDATE PlaylistItems SET trackTitle = LEFT(?, 500), trackArtist = LEFT(?, 500), trackAlbum = LEFT(?, 500), trackComment = LEFT(?, 500), trackGenre = LEFT(?, 20), trackNumber = LEFT(?, 6), trackYear = LEFT(?, 6) WHERE filePath = LEFT(?, 10000)";
        Object[] objectArray = new Object[]{string2, string3, string4, string5, string6, string7, string8, string};
        return new Object[]{string9, objectArray};
    }

    private static Object[] createPlaylistUpdateStatement(Playlist playlist) {
        String string = "UPDATE Playlists SET name = LEFT(?, 500), description = LEFT(?, 10000) WHERE playlistId = ?";
        Object[] objectArray = new Object[]{playlist.getName(), playlist.getDescription(), playlist.getId()};
        return new Object[]{string, objectArray};
    }
}

