/*****************************************************************************
 *
 *   connie_ui.cpp
 *
 *   Simulation of an electronic organ like Vox Continental
 *   with JACK MIDI input and JACK audio output
 *
 *   Copyright (C) 2009,2010 Martin Homuth-Rosemann
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; version 2 of the License
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 ******************************************************************************/

#include <QtGui>

#include "connie.h"
#include "drawbar.h"


static const char *hnames[12] = {
    " 16  ",
    "5 1/3",
    "  8  ",
    "  4  ",
    "2 2/3",
    "  2  ",
    "1 3/5",
    "1 1/3",
    "  1  "
};


int ui( int argc, char** argv, const model_t instrument, const keybd_t /*keybd*/ )
{
    QApplication app(argc, argv);
    QWidget window;
    Drawbar *drawbars[12];
    QHBoxLayout *layout = new QHBoxLayout();

    int iii=0;

    switch ( instrument ) {
      default:
      case CONNIE:
        drawbars[iii] = new Drawbar( tg_stops,   " 16  " );
        drawbars[iii]->setValue( 5 );
        layout->addWidget(drawbars[iii]);
        iii++;
        drawbars[iii] = new Drawbar( tg_stops+2, "  8  " );
        drawbars[iii]->setValue( 5 );
        layout->addWidget(drawbars[iii]);
        iii++;
        drawbars[iii] = new Drawbar( tg_stops+3, "  4  " );
        drawbars[iii]->setValue( 5 );
        layout->addWidget(drawbars[iii]);
        iii++;
        drawbars[iii] = new Drawbar( tg_stops+4, " IV  " );
        drawbars[iii]->addMix( tg_stops+5 );
        drawbars[iii]->addMix( tg_stops+6 );
        drawbars[iii]->addMix( tg_stops+8 );
        drawbars[iii]->setValue( 5 );
        layout->addWidget(drawbars[iii]);
        iii++;
        drawbars[iii] = new Drawbar( tg_voices, "  ~  " );
        drawbars[iii]->setValue( 8 );
        layout->addWidget(drawbars[iii]);
        iii++;
        drawbars[iii] = new Drawbar( tg_voices+1, "  M  " );
        drawbars[iii]->setValue( 0 );
        layout->addWidget(drawbars[iii]);
        iii++;
        drawbars[iii] = new Drawbar( tg_voices+2, "sharp" );
        drawbars[iii]->setValue( 0 );
        layout->addWidget(drawbars[iii]);
        iii++;
        break;
      case HAMMOND:
        for ( iii = 0; iii < 9; iii++ ) {
            drawbars[iii] = new Drawbar( tg_stops+iii, hnames[iii] );
            drawbars[iii]->setValue( 5 );
            layout->addWidget(drawbars[iii]);
        }
        break;
    }
    drawbars[iii] = new Drawbar( &tg_vibrato, "vibr." );
    drawbars[iii]->setValue( 0 );
    layout->addWidget(drawbars[iii]);
    iii++;
    drawbars[iii] = new Drawbar( &tg_percussion, "perc." );
    drawbars[iii]->setValue( 0 );
    layout->addWidget(drawbars[iii]);
    iii++;
    drawbars[iii] = new Drawbar( &tg_reverb, "revb." );
    drawbars[iii]->setValue( 4 );
    layout->addWidget(drawbars[iii]);

    window.setLayout(layout);
    window.setWindowTitle( "connie" );
    window.show();
    return app.exec();
}



int ui_set_program( int /*prog*/ ) {
    return 0;
}



int ui_set_drawbars( const int * /*draw*/ ) {
    return 0;
}



void ui_save( int /*type*/, const char * /*path*/ ) {
}

