#!/usr/bin/env python

import mpdclient2, string, sys, kanolaplaylist
from kdeui import KMainWindow, KProgress, KPushButton, KRadioAction
from kdecore import KApplication, KAboutData, KCmdLineArgs, KIcon, KIconLoader
from qt import SIGNAL, QGridLayout, QLabel, QCheckBox

__APPNAME__ = "Kanola"
__APPVER__ = "0.1"
__APPDESC__ = "KDE MPD client"
__APPTITLE__ = __APPNAME__ + " " + __APPVER__

class KanolaWin(KMainWindow):
  def __init__(self, *args):
	KMainWindow.__init__(self)
	self.setCaption(__APPTITLE__)
	self.resize(500,120)
	self.qlayout = QGridLayout(self, 10, 22, 5, 5)
	self.icons = KIconLoader()

	# Start a timer to have info updated every 250ms
	self.startTimer(250)

  def timerEvent(self, event):
	# Called every 250ms to update the display details
	self.cb_setDetails()
	
  def resizeEvent(self, event):
	self.resize(500,120)

  def readTime(self):
	length = int(self.mpd.currentsong().time)
	time = int(self.mpd.status().time.split(":")[0])

	time_mins = str(time/60)
	time_secs = str(time%60)
	
	len_mins = str(length/60)
	len_secs = str(length%60)

	if len(len_mins) < 2:
		len_mins = "0" + len_mins
	if len(len_secs) < 2:
		len_secs = "0" + len_secs
	if len(time_mins) < 2:
		time_mins = "0" + time_mins
	if len(time_secs) < 2:
		time_secs = "0" + time_secs

	return (time, length, time_mins, time_secs, len_mins, len_secs)

  def createWidgets(self):
	# Create Buttons
	self.setIcon(self.icons.loadIcon("kanola",KIcon.Desktop,KIcon.SizeSmall))
	self.btnRew = KPushButton("", self)
	self.btnRew.setPixmap(self.icons.loadIcon("player_rew",KIcon.Desktop,KIcon.SizeSmall))
	self.btnPlay = KPushButton("", self)
	self.btnPlay.setPixmap(self.icons.loadIcon("player_play",KIcon.Desktop,KIcon.SizeSmall))
	self.btnStop = KPushButton("", self)
	self.btnStop.setPixmap(self.icons.loadIcon("player_stop",KIcon.Desktop,KIcon.SizeSmall))
	self.btnFwd = KPushButton("", self)
	self.btnFwd.setPixmap(self.icons.loadIcon("player_fwd",KIcon.Desktop,KIcon.SizeSmall))
	self.btnPlaylist = KPushButton("", self)
	self.btnPlaylist.setPixmap(self.icons.loadIcon("player_playlist",KIcon.Desktop,KIcon.SizeSmall))

	# Create the progress bar
	self.progressbar = KProgress(self)
	self.progressbar.setTextEnabled(False)

	# Create the labels
	self.lblTitle = QLabel(self)
	self.lblArtistAlbum = QLabel(self)
	self.lblTimeStatus = QLabel(self)
	self.radRandom = QCheckBox("Random", self)
	self.radRepeat = QCheckBox("Repeat", self)

	# Organize widgets
	self.qlayout.addMultiCellWidget(self.progressbar, 1, 1, 5, 22, 0)
	self.qlayout.addMultiCellWidget(self.btnRew, 1, 1, 0, 0, 0)
	self.qlayout.addMultiCellWidget(self.btnPlay, 1, 1, 1, 1, 0)
	self.qlayout.addMultiCellWidget(self.btnStop, 1, 1, 2, 2, 0)
	self.qlayout.addMultiCellWidget(self.btnFwd, 1, 1, 3, 3, 0)
	self.qlayout.addMultiCellWidget(self.btnPlaylist, 1, 1, 4, 4, 0)
	self.qlayout.addMultiCellWidget(self.lblTitle, 4, 4, 0, 19, 0)
	self.qlayout.addMultiCellWidget(self.lblArtistAlbum, 5, 5, 0, 20, 0)
	self.qlayout.addMultiCellWidget(self.lblTimeStatus, 6, 6, 0, 20, 0)
	self.qlayout.addMultiCellWidget(self.radRandom, 6, 6, 15, 18, 0)
	self.qlayout.addMultiCellWidget(self.radRepeat, 6, 6, 19, 22, 0)

	# Connect Signals
	self.connect(self.btnRew, SIGNAL("clicked()"), self.cb_rew)
	self.connect(self.btnPlay, SIGNAL("clicked()"), self.cb_toggle)
	self.connect(self.btnStop, SIGNAL("clicked()"), self.cb_stop)
	self.connect(self.btnFwd, SIGNAL("clicked()"), self.cb_fwd)
	self.connect(self.btnPlaylist, SIGNAL("clicked()"), self.cb_playlist)
	self.connect(self.radRandom, SIGNAL("clicked()"), self.cb_random)
	self.connect(self.radRepeat, SIGNAL("clicked()"), self.cb_repeat)


  def cb_random(self):
	if self.mpd.status().random == "1":
		self.mpd.random(0)
		self.radRandom.setChecked(False)
	else:
		self.mpd.random(1)
		self.radRandom.setChecked(True)

  def cb_repeat(self):
	if self.mpd.status().repeat == "1":
		self.mpd.repeat(0)
		self.radRepeat.setChecked(False)
	else:
		self.mpd.repeat(1)
		self.radRepeat.setChecked(True)


  def cb_playlist(self):
	self.playwin = kanolaplaylist.KanolaPlaylist()
	
  def cb_rew(self):
	self.mpd.previous()

  def cb_toggle(self):
	if self.mpd.status().state in ('stop', 'pause'):
		self.mpd.play()
	elif self.mpd.status().state == 'play':
		self.mpd.pause(1)

  def cb_stop(self):
	self.mpd.stop()

  def cb_fwd(self):
	self.mpd.next()

  def cb_setDetails(self):
	try:
		self.mpd = mpdclient2.connect()
		if self.mpd.status().state != "stop":
			title = self.mpd.currentsong().title
			artist = self.mpd.currentsong().artist
			album = self.mpd.currentsong().album
			(time, length, time_mins, time_secs, len_mins, len_secs) = self.readTime()
			self.lblTitle.setText(title)
			self.lblArtistAlbum.setText(artist + " - " + album)
			self.setCaption("Playing " + artist + " - " + title + " - " + __APPTITLE__)
			self.lblTimeStatus.setText(time_mins + ":" + time_secs + "/" + len_mins + ":" + len_secs)
			self.progressbar.setTotalSteps(int(length))
			self.progressbar.setProgress(int(time))
		else:
			self.setCaption("Stopped " + " - " + __APPTITLE__)
			self.lblTitle.setText("Stopped")
			self.lblArtistAlbum.setText("")
			self.progressbar.setProgress(0)

	except:
		self.setCaption("No connection to MPD daemon...")
		self.lblTitle.setText("No connection to MPD daemon...")
		self.lblArtistAlbum.setText("")
		self.progressbar.setProgress(0)

	if self.mpd.status().state in ('stop', 'pause'):
		self.btnPlay.setPixmap(self.icons.loadIcon("player_play",KIcon.Desktop,KIcon.SizeSmall))
	elif self.mpd.status().state == 'play':
		self.btnPlay.setPixmap(self.icons.loadIcon("player_pause",KIcon.Desktop,KIcon.SizeSmall))

	# Button Status
	if self.mpd.status().random == "1":
		self.radRandom.setChecked(True)

	# Button Status
	if self.mpd.status().repeat == "1":
		self.radRepeat.setChecked(True)


  def run(self):
	self.createWidgets()
	self.show()


aboutData = KAboutData("" ,"" , __APPVER__, __APPDESC__, KAboutData.License_GPL, "(c) 2006 Martin Lefebvre")
aboutData.addAuthor("Martin Lefebvre","Main Developer","dadexter@gmail.com")
KCmdLineArgs.init(sys.argv, aboutData)
a = KApplication()
window = KanolaWin()
window.run()
a.exec_loop()
