#ifdef WIN32
#include <windows.h>
#include <winsock2.h>

typedef int            bool_t;
typedef unsigned char  uchar_t;
typedef unsigned short ushort_t;
typedef unsigned int   uint_t;

typedef struct {} XDR;

enum xdr_op { XDR_ENCODE = 0, XDR_DECODE = 1, XDR_FREE = 2 };

static inline bool_t unimp(char *what)
{
	printf("%s not supported in win32\n", what);
	exit(-1);
	return FALSE;
}

static inline void   xdrstdio_create(XDR *xdrs, FILE *file, enum xdr_op op)    {        unimp("xdr"); }
static inline void   xdr_destroy(XDR *xdrs)                                    {        unimp("xdr"); }
static inline bool_t xdr_u_char (XDR *xdrs, uchar_t  *ucp)                     { return unimp("xdr"); }
static inline bool_t xdr_bytes  (XDR *xdrs, char    **sp, uint_t *s, uint_t m) { return unimp("xdr"); }
static inline bool_t xdr_int    (XDR *xdrs, int      *ip)                      { return unimp("xdr"); }
static inline bool_t xdr_string (XDR *xdrs, char    **sp, uint_t maxsize)      { return unimp("xdr"); }
static inline bool_t xdr_u_short(XDR *xdrs, ushort_t *usp)                     { return unimp("xdr"); }
static inline bool_t xdr_short  (XDR *xdrs, short    *sp)                      { return unimp("xdr"); }
static inline bool_t xdr_u_int  (XDR *xdrs, uint_t   *up)                      { return unimp("xdr"); }

static inline pid_t fork(void) { return unimp("fork"); }

static inline char *index(const char *s, int c)
{
    while (*s != c && *s != '\0')
    	s++;
    return *s == '\0' ? NULL : (char*)s;
}
#endif
