10 REM STARTREK SIMULATION PROGRAM
20 REM A TINY BASIC VERSION
30 REM I.L.POWELL 10/3/1979.  CODE PUBLISHED COMPUTING TODAY, OCT 1979
40 K=0
50 T=RND(200)+200
60 E=3000
70 O=15
80 S=0
90 L=T
99 REM SET UP SECTORS
100 FOR I=0 TO 63
105 X=0 : Y=0
110 IF RND(10)<8 X=RND(3)
120 IF RND(100)>88 Y=1
130 Z=RND(5)
140 @(I)=X*100+Y*10+Z
145 K=K+X
150 NEXT I
160 Q=RND(64)-1
170 A=RND(64)-1
180 IF Q<0 Q=Q+64
190 IF Q>63 Q=Q-64
199 REM SET UP THE CURRENT SECTOR
200 Z=@(Q)
210 X=Z/100
215 Z=Z-X*100
220 Y=Z/10
225 Z=Z-Y*10
230 FOR I=64 TO 127
233 @(I)=0
235 NEXT I
237 @(A+64)=4
240 FOR I=1 TO 5
245 IF I>Z GOTO 270
250 J=RND(64)+63
255 IF @(J)#0 GOTO 250
260 @(J)=3
270 IF I>Y GOTO 300
280 J=RND(64)+63
285 IF @(J)#0 GOTO 280
290 @(J)=2
300 IF I>X GOTO 330
310 J=RND(64)+63
315 IF @(J)#0 GOTO 310
320 @(J)=-200
330 NEXT I
340 REM SHORT RANGE SCAN
350 C=1
360 IF X#0 C=2
370 IF (@(A+63)=2)+(@(A+65)=2) C=3
380 IF C=3 E=3000 : S=0 : O=15
400 FOR I=0 TO 7 : rem 8 steps
410 FOR J=64 TO 71 : rem 8 steps
420 U=@((I*8)+J)
430 IF U=0 PRINT " . ",
440 IF U<0 PRINT ">K<",
450 IF U=2 PRINT "<B>",
455 IF U=3 PRINT " * ",
460 IF U=4 PRINT "[E]",
470 NEXT J
480 IF I=0 PRINT "STARDATE", T
485 IF ((I*8)=8)+((I*8)=56) PRINT
490 IF (I*8)#16 GOTO 500
492 PRINT "CONDITION ",
493 IF C=1 PRINT "GREEN"
494 IF C=2 PRINT "RED"
496 IF C=3 PRINT "DOCKED"
500 IF (I*8)=24 PRINT "ENERGY  ",E
510 IF (I*8)=32 PRINT "TORPEDOS ",O
520 IF (I*8)=40 PRINT "SHIELDS ",S
530 IF (I*8)=48 PRINT "KLINGONS ", K
540 NEXT I
550 IF L#T IF RND(9)<6 GOTO 4080
590 REM COMMAND CONTROL
600 IF K=0 PRINT "THE FEDERATION HAS BEEN SAVED" : STOP
605 INPUT "COMMAND ",B
610 IF B=0 GOSUB 700; GOTO 605
620 IF (B>7)+(B<1) GOTO 600
630 REM 1 = HELM CONTROL
631 REM 2 = LONG RANGE SCAN
632 REM 3 = PHASER CONTROL
633 REM 4 = PHOTO TORPEDOS
634 REM 5 = SHIELDS
635 REM 6 = SHORT RANGE SCAN
636 REM 7 = RESIGN
650 GOSUB B*1000
700 PRINT "0=COMMAND LIST,     1=HELM CONTROL,    2=LONG RANGE SCAN"
710 PRINT "3=PHASERS,          4=PHOTON TORPEDOS, 5=SHIELDS"
720 PRINT "6=SHORT RANGE SCAN, 7=RESIGN"
730 RETURN
999 REM HELM CONTROL
1000 GOSUB 8500
1020 INPUT "WARP (1-63) ",W
1030 IF (W<1)+(W>63) GOTO 1020
1035 IF E<W GOSUB 8300 : GOTO 600
1040 @(A+64)=0
1045 E=E-W
1050 T=T+W
1090 I=1 : REM FOR I=1 TO W
1100 U=1 : V=V+N : H=H+M
1110 IF (V<0)+(V>7)+(H<0)+(H>7) GOTO 1120
1113 U=0
1115 IF @(V+8*H+64)#0 V=V-N : H=H-M : GOTO 1140
1120 IF I<W I=I+1 : GOTO 1100
1125 IF V<0 V=V-8
1130 IF H<0 H=H-8
1135 IF U#0 Q=Q+8*(H/8)+V/8; GOTO 170
1140 A=V+8*H
1150 @(A+64)=4
1160 GOTO 350
1999 REM LONG RANGE SENSOR SCAN
2000 FOR I=-1 TO 1
2010 FOR J=-1 TO 1
2015 U=Q+J+(I*8)
2020 IF U<0 U=U+64
2025 IF U>63 U=U-64
2030 PRINT @(U),
2033 NEXT J
2035 PRINT
2037 NEXT I
2040 GOTO 550
2999 REM PHASER CONTROL
3000 GOSUB 8300
3005 INPUT "PHASERS ", P
3010 IF E<P GOTO 3000
3020 E=E-P
3025 IF X=0 GOTO 3120
3030 P=P/X
3033 H=A/8
3035 V=A-(8*H)
3040 FOR I=0 TO 63
3050 J=I+64
3055 IF @(J)>-1 GOTO 3110
3060 F=I/8
3065 U=I-(F*8)
3070 GOSUB 8000
3073 G=@(J)
3075 G=G+(P/D)
3080 IF G>-1 GOSUB 8200 : GOTO 3110
3090 @(J)=G
3100 IF C#3 G=-G/D : S=S-G : PRINT G;" HIT ON THE SHIELDS"
3110 NEXT I
3115 IF S<0 GOTO 8100
3120 @(Q)=@(Q)-(@(Q)/100-X)*100
3130 GOTO 600
3999 REM PHOTON TORPEDO CONTROL
4000 IF O<1 PRINT "NO TORPEDOS" : GOTO 600
4010 GOSUB 8500
4013 O=O-1
4015 I=1 : REM FOR I=1 TO 16
4020 V=V+N
4025 H=H+M
4030 IF (V<0)+(V>7)+(H<0)+(H>7) print "Torpedo left galaxy" : GOTO 4080
4040 J=V+8*H+64
4045 IF @(J)#0 : print "SULU: CAPTAIN, hit on something.." : GOTO 4060
4050 IF I<16 I=I+1 : GOTO 4020
4060 IF @(J)=2 PRINT "STAR BASE DESTROYED" : GOTO 8600
4065 IF @(J)>0 GOTO 4080
4070 GOSUB 8200
4080 P=0
4090 GOTO 3020 
5000 E=E+S
5005 GOSUB 8300
5010 INPUT "SHIELDS ", S
5015 E=E-S
5020 IF E<1 PRINT "NOT ENOUGH ENERGY"; GOTO 5000
5030 GOTO 600
5999 REM JUMP TO SHORT RANGE SENSOR SCAN
6000 GOTO 350
6999 REM RESIGNATION
7000 PRINT "ACCEPTED"
7010 GOTO 8600
7900 REM SUBROUTINES
7910 REM CALCULATE KLINGON ENTERPRISE DISTANCE
8000 Z=H-F
8005 Y=V-U
8010 D=1 : REM FOR D=1 TO 8
8015 G=D+1
8020 IF G*G>(Z*Z+Y*Y) RETURN
8030 IF D<8 THEN D=D+1 : GOTO 8015
8040 RETURN
8090 REM
8100 PRINT "ENTERPRISE DEAD IN SPACE"
8110 GOTO 8600
8190 REM
8200 PRINT "KLINGON DESTROYED"
8210 X=X-1
8220 K=K-1
8230 @(J)=0
8240 RETURN
8290 REM
8300 PRINT "ENERGY=",E
8310 RETURN
8390 REM READ COURSE AND CALCULATE MOVEMENT VECTOR
8500 INPUT "COURSE (0-7) ", B
8510 IF (B<0)+(B>7) GOTO 8500
8520 M=0
8523 N=0
8525 H=A/8
8527 V=A-H*8
8528 rem print "A=";a," H=";h, " V=";v
8530 IF (B<2)+(B>6) M=-1
8540 IF B>2 IF B<6 M=1
8550 IF B<4 IF B>0 N=1
8560 IF B>4 N=-1
8565 rem LOOKS LIKE M is north/south and N is east/west
8566 rem print "m=";m," n=";n
8570 RETURN
8590 REM
8600 PRINT "YOU ARE RELIEVED OF DUTY"
8610 STOP
