rm autogenerated.doxy
for f in * 
do
	echo $f
	if ! [ -d $f ] 
	then
		continue
	fi
	echo "entering $f"
	EXAMPLE_DESCRIPTION=`grep -E "^$f " examples.txt`
	if [ "$EXAMPLE_DESCRIPTION" == "" ]
	then
		EXAMPLE_DESCRIPTION=$f
	else
		EXAMPLE_DESCRIPTION=${EXAMPLE_DESCRIPTION#$f }
	fi
	echo $EXAMPLE_DESCRIPTION
	echo  >> autogenerated.doxy
	echo '/*! \page ' ex_$f $EXAMPLE_DESCRIPTION >>autogenerated.doxy
	echo >>autogenerated.doxy
	cd $f
	find . \
		-iname '*.cpp' \
		-o -iname '*.tmpl' \
		-o -iname 'Makefile*' \
		-o -iname 'CMake*' \
		-o -iname '*.h' \
		-o -iname '*.po' \
		-o -iname '*.js' \
		-o -iname '*.css' \
		-o -iname '*.sql' \
		-o -iname '*.html' \
		 | grep -v svn >../tmp.txt
	cd ..
	for n in `cat tmp.txt`
	do
		FILE=${n//./_/}
		FILE=${FILE//\//_}
		echo "- \subpage ex_${f}_$FILE" >> autogenerated.doxy
	done
	echo >> autogenerated.doxy
	for n in `cat tmp.txt`
	do
		FILE=${n//./_/}
		FILE=${FILE//\//_}
		FILE_PATH=$f${n/.\///}
		DESCRIPTION=`grep -E "^$FILE_PATH " examples.txt`
		if [ "$DESCRIPTION" == "" ]
		then
			case $n  in
				*.cpp* ) DESCRIPTION="Source File" ;;
				*.h* ) DESCRIPTION="Header File" ;;
				*.tmpl ) DESCRIPTION="Template File" ;;
				*.html ) DESCRIPTION="HTML File" ;;
				*.js ) DESCRIPTION="Configuration File" ;;
				*.po ) DESCRIPTION="Gettext Dictionary File" ;;
				*.css ) DESCRIPTION="CSS Media File" ;;
				*.sql ) DESCRIPTION="SQL Script File" ;;
				*CMakeLists* ) DESCRIPTION="CMake Build Script" ;;
				*Makefile* ) DESCRIPTION="Makefile" ;;
			esac
			DESCRIPTION="$FILE_PATH $DESCRIPTION"
		fi
		echo $FILE_PATH
		echo "\page ex_${f}_$FILE $DESCRIPTION" >> autogenerated.doxy
		echo "\include $FILE_PATH" >> autogenerated.doxy
	done
	echo '*/' >> autogenerated.doxy
	rm tmp.txt
done
