# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
# 
# The contents of this file are subject to the Mozilla Public License
# Version 1.1 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
# 
# Software distributed under the License is distributed on an "AS IS"
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
# License for the specific language governing rights and limitations
# under the License.
# 
# The Original Code is Komodo code.
# 
# The Initial Developer of the Original Code is ActiveState Software Inc.
# Portions created by ActiveState Software Inc are Copyright (C) 2000-2007
# ActiveState Software Inc. All Rights Reserved.
# 
# Contributor(s):
#   ActiveState Software Inc
# 
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
# 
# ***** END LICENSE BLOCK *****

# Komodo MXML language service.
#
# Generated by 'luddite.py' on Thu Mar 15 16:06:49 2007.
#

import logging
from xpcom import components
from koXMLLanguageBase import koXMLLanguageBase, KoGenericXMLLinter


log = logging.getLogger("koMXMLLanguage")
#log.setLevel(logging.DEBUG)


def registerLanguage(registry):
    log.debug("Registering language MXML")
    registry.registerLanguage(KoMXMLLanguage())


class KoMXMLLanguage(koXMLLanguageBase):
    name = "MXML"
    lexresLangName = "MXML"
    _reg_desc_ = "%s Language" % name
    _reg_contractid_ = "@activestate.com/koLanguage?language=%s;1" % name
    _reg_clsid_ = "{8cdb154f-47e6-420e-a918-1548ab748499}"
    _reg_categories_ = [("komodo-language", name)]
    defaultExtension = '.mxml'

    lang_from_udl_family = {'CSL': 'ActionScript', 'M': 'XML'}

    systemIdList = ["http://www.adobe.com/2006/mxml",
                  "http://www.macromedia.com/2003/mxml"]
    namespaces = ["http://www.adobe.com/2006/mxml",
                  "http://www.macromedia.com/2003/mxml"]

    sample = """<mx:Application xmlns:mx="http://www.adobe.com/2006/mxml" 
                layout="absolute" backgroundGradientColors="[#000011, #333333]">
   <mx:Label text="Hello World!" verticalCenter="0" horizontalCenter="0" fontSize="48" letterSpacing="1">
      <mx:filters>
         <mx:GlowFilter color="#ffffdd"/>
      </mx:filters>
   </mx:Label>
</mx:Application>
"""

class KoMXMLCompileLinter(KoGenericXMLLinter):
    _reg_desc_ = "Komodo MXML Compile Linter"
    _reg_clsid_ = "{85d92de0-f7d6-4c33-8736-dcb8ea9b6a41}"
    _reg_contractid_ = "@activestate.com/koLinter?language=MXML;1"
    _reg_categories_ = [
         ("category-komodo-linter", 'MXML'),
         ]
