/*
========================================================================

                           D O O M  R e t r o
         The classic, refined DOOM source port. For Windows PC.

========================================================================

  Copyright © 1993-2021 by id Software LLC, a ZeniMax Media company.
  Copyright © 2013-2021 by Brad Harding <mailto:brad@doomretro.com>.

  DOOM Retro is a fork of Chocolate DOOM. For a list of credits, see
  <https://github.com/bradharding/doomretro/wiki/CREDITS>.

  This file is a part of DOOM Retro.

  DOOM Retro is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation, either version 3 of the License, or (at your
  option) any later version.

  DOOM Retro is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with DOOM Retro. If not, see <https://www.gnu.org/licenses/>.

  DOOM is a registered trademark of id Software LLC, a ZeniMax Media
  company, in the US and/or other countries, and is used without
  permission. All other trademarks are the property of their respective
  holders. DOOM Retro is in no way affiliated with nor endorsed by
  id Software.

========================================================================
*/

#include "d_items.h"
#include "states.h"

weaponinfo_t weaponinfo[NUMWEAPONS] =
{
    {
        /* name */        "fists",
        /* ammotype */    am_noammo,
        /* ammoname */    "",
        /* ammoplural */  "",
        /* minammo */     0,
        /* upstate */     S_PUNCHUP,
        /* downstate */   S_PUNCHDOWN,
        /* readystate */  S_PUNCH,
        /* atkstate */    S_PUNCH1,
        /* flashstate */  S_NULL,
        /* recoil */      0,
        /* strength */    37500,
        /* tics */        10,
        /* prev */        wp_bfg,
        /* next */        wp_chainsaw,
        /* spritename */  ""
    },

    {
        /* name */        "pistol",
        /* ammotype */    am_clip,
        /* ammoname */    "bullet",
        /* ammoplural */  "bullets",
        /* minammo */     1,
        /* upstate */     S_PISTOLUP,
        /* downstate */   S_PISTOLDOWN,
        /* readystate */  S_PISTOL,
        /* atkstate */    S_PISTOL1,
        /* flashstate */  S_PISTOLFLASH,
        /* recoil */      4,
        /* strength */    45000,
        /* tics */        10,
        /* prev */        wp_chainsaw,
        /* next */        wp_shotgun,
        /* spritename */  ""
    },

    {
        /* name */        "shotgun",
        /* ammotype */    am_shell,
        /* ammoname */    "shell",
        /* ammoplural */  "shells",
        /* minammo */     1,
        /* upstate */     S_SGUNUP,
        /* downstate */   S_SGUNDOWN,
        /* readystate */  S_SGUN,
        /* atkstate */    S_SGUN1,
        /* flashstate */  S_SGUNFLASH1,
        /* recoil */      8,
        /* strength */    52500,
        /* tics */        10,
        /* prev */        wp_pistol,
        /* next */        wp_supershotgun,
        /* spritename */  "SHOTA0"
    },

    {
        /* name */        "chaingun",
        /* ammotype */    am_clip,
        /* ammoname */    "bullet",
        /* ammoplural */  "bullets",
        /* minammo */     1,
        /* upstate */     S_CHAINUP,
        /* downstate */   S_CHAINDOWN,
        /* readystate */  S_CHAIN,
        /* atkstate */    S_CHAIN1,
        /* flashstate */  S_CHAINFLASH1,
        /* recoil */      4,
        /* strength */    45000,
        /* tics */        10,
        /* prev */        wp_supershotgun,
        /* next */        wp_missile,
        /* spritename */  "MGUNA0"
    },

    {
        /* name */        "rocket launcher",
        /* ammotype */    am_misl,
        /* ammoname */    "rocket",
        /* ammoplural */  "rockets",
        /* minammo */     1,
        /* upstate */     S_MISSILEUP,
        /* downstate */   S_MISSILEDOWN,
        /* readystate */  S_MISSILE,
        /* atkstate */    S_MISSILE1,
        /* flashstate */  S_MISSILEFLASH1,
        /* recoil */      16,
        /* strength */    60000,
        /* tics */        20,
        /* prev */        wp_chaingun,
        /* next */        wp_plasma,
        /* spritename */  "LAUNA0"
    },

    {
        /* name */        "plasma rifle",
        /* ammotype */    am_cell,
        /* ammoname */    "cell",
        /* ammoplural */  "cells",
        /* minammo */     1,
        /* upstate */     S_PLASMAUP,
        /* downstate */   S_PLASMADOWN,
        /* readystate */  S_PLASMA,
        /* atkstate */    S_PLASMA1,
        /* flashstate */  S_PLASMAFLASH1,
        /* recoil */      4,
        /* strength */    52500,
        /* tics */        10,
        /* prev */        wp_missile,
        /* next */        wp_bfg,
        /* spritename */  "PLASA0"
    },

    {
        /* name */        "BFG-9000",
        /* ammotype */    am_cell,
        /* ammoname */    "cell",
        /* ammoplural */  "cells",
        /* minammo */     BFGCELLS,
        /* upstate */     S_BFGUP,
        /* downstate */   S_BFGDOWN,
        /* readystate */  S_BFG,
        /* atkstate */    S_BFG1,
        /* flashstate */  S_BFGFLASH1,
        /* recoil */      16,
        /* strength */    45000,
        /* tics */        30,
        /* prev */        wp_plasma,
        /* next */        wp_fist,
        /* spritename */  "BFUGA0"
    },

    {
        /* name */        "chainsaw",
        /* ammotype */    am_noammo,
        /* ammoname */    "",
        /* ammoplural */  "",
        /* minammo */     0,
        /* upstate */     S_SAWUP,
        /* downstate */   S_SAWDOWN,
        /* readystate */  S_SAW,
        /* atkstate */    S_SAW1,
        /* flashstate */  S_NULL,
        /* recoil */      -2,
        /* strength */    45000,
        /* tics */        10,
        /* prev */        wp_fist,
        /* next */        wp_pistol,
        /* spritename */  "CSAWA0"
    },

    {
        /* name */        "super shotgun",
        /* ammotype */    am_shell,
        /* ammoname */    "shell",
        /* ammoplural */  "shells",
        /* minammo */     2,
        /* upstate */     S_DSGUNUP,
        /* downstate */   S_DSGUNDOWN,
        /* readystate */  S_DSGUN,
        /* atkstate */    S_DSGUN1,
        /* flashstate */  S_DSGUNFLASH1,
        /* recoil */      16,
        /* strength */    60000,
        /* tics */        10,
        /* prev */        wp_shotgun,
        /* next */        wp_chaingun,
        /* spritename */  "SGN2A0"
    }
};

char *powerupnames[NUMPOWERS] =
{
    "",
    "invulnerability",
    "berserk",
    "partial invisibility",
    "radiation shielding suit",
    "computer area map",
    "light amplification visor"
};
