local map = ...
local game = map:get_game()

function map:on_opening_transition_finished()

  assert(not game:is_suspended())

  local timer = sol.timer.start(robyne, 1000, function()
    assert(not game:is_suspended())
    sol.main.exit()
  end)

  assert(timer:is_suspended_with_map())
  robyne:set_enabled(false)
  assert(timer:is_suspended())
  robyne:set_enabled(true)
  assert(not timer:is_suspended())
  assert(not game:is_suspended())
  game:set_paused(true)
  sol.timer.start(sol.main, 10, function()
    assert(game:is_suspended())
    assert(timer:is_suspended())
    game:set_paused(false)
    sol.timer.start(sol.main, 10, function()
      assert(not game:is_suspended())
      assert(not timer:is_suspended())

      timer:set_suspended_with_map(false)
      assert(not timer:is_suspended_with_map())
      robyne:set_enabled(false)
      assert(not timer:is_suspended())
      robyne:set_enabled(true)
      assert(not timer:is_suspended())
      assert(not game:is_suspended())
      game:set_paused(true)
      sol.timer.start(sol.main, 10, function()
        assert(game:is_suspended())
        assert(not timer:is_suspended())
        game:set_paused(false)
        sol.timer.start(sol.main, 10, function()
          assert(not game:is_suspended())
          assert(not timer:is_suspended())
          sol.main.exit()
        end)
      end)
    end)
  end)

end
