/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2019 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package control;

public interface Freak {

    public static final int CONTROL_CALL_BEFORE = 1;
    public static final int CONTROL_CALL_AFTER = 2;
    public static final int CONTROL_STATIC_CALL_BEFORE = 4;
    public static final int CONTROL_STATIC_CALL_AFTER = 8;
    public static final int CONTROL_THROW = 16;
    public static final int CONTROL_CATCH = 32;
    public static final int CONTROL_ALL = 0xffffffff;

    public int  controlFlags();

    public void callBefore(Object object,Object[] pile,String owner,String name,String desc,long hash);
    public Object callBefore(Object object,Object pile,String owner,String name,String desc,long hash);
    public void callBefore(Object object,long[] pile,String owner,String name,String desc,long hash);
    public int callBefore(Object object,int pile,String owner,String name,String desc,long hash);
    public long callBefore(Object object,long pile,String owner,String name,String desc,long hash);
    public void callBefore(Object object,String owner,String name,String desc,long hash);

    public char callAfter(Object object,char value,String owner,String name,String desc,long hash);
    public byte callAfter(Object object,byte value,String owner,String name,String desc,long hash);
    public boolean callAfter(Object object,boolean value,String owner,String name,String desc,long hash);
    public short callAfter(Object object,short value,String owner,String name,String desc,long hash);
    public int callAfter(Object object,int value,String owner,String name,String desc,long hash);
    public long callAfter(Object object,long value,String owner,String name,String desc,long hash);
    public float callAfter(Object object,float value,String owner,String name,String desc,long hash);
    public double callAfter(Object object,double value,String owner,String name,String desc,long hash);
    public Object callAfter(Object object,Object value,String owner,String name,String desc,long hash);
    public void callAfter(Object object,String owner,String name,String desc,long hash);

    public void callStaticBefore(Object[] pile,String owner,String name,String desc,long hash);
    public Object callStaticBefore(Object pile,String owner,String name,String desc,long hash);
    public void callStaticBefore(long[] pile,String owner,String name,String desc,long hash);
    public int callStaticBefore(int pile,String owner,String name,String desc,long hash);
    public long callStaticBefore(long pile,String owner,String name,String desc,long hash);
    public void callStaticBefore(String owner,String name,String desc,long hash);

    public char callStaticAfter(char value,String owner,String name,String desc,long hash);
    public byte callStaticAfter(byte value,String owner,String name,String desc,long hash);
    public boolean callStaticAfter(boolean value,String owner,String name,String desc,long hash);
    public short callStaticAfter(short value,String owner,String name,String desc,long hash);
    public int callStaticAfter(int value,String owner,String name,String desc,long hash);
    public long callStaticAfter(long value,String owner,String name,String desc,long hash);
    public float callStaticAfter(float value,String owner,String name,String desc,long hash);
    public double callStaticAfter(double value,String owner,String name,String desc,long hash);
    public Object callStaticAfter(Object value,String owner,String name,String desc,long hash);
    public void callStaticAfter(String owner,String name,String desc,long hash);

    public void reportThrow(Throwable x);
    public void reportCatch(Throwable x);
}
