/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2019 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarFile extends FsFile {

    ZipFile zipFile;
    ZipEntry zipEntry;
    InputStream stream;
    long streamOffset;

    JarFile(ZipFile zipFile, ZipEntry zipEntry, String path) {
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
        this.stream = null;
        setPath(path, null);
    }

    @Override
    public int writeBytes(long offset, byte[] b, int off, int len) {
        return -1;
    }

    @Override
    protected void lastReferenceClosed() {
        if (stream != null) {
            try {
                stream.close();
            } catch (IOException e) {
            }
            stream = null;
        }
    }

    @Override
    public int readBytes(long offset, byte[] b, int off, int len) {
        if ((stream != null) && (offset < streamOffset)) {
            lastReferenceClosed();
        }

        if (stream == null) {
            try {
                stream = zipFile.getInputStream(zipEntry);
            } catch (IOException e) {
                stream = null;
                return -2;
            }
            streamOffset = 0;
        }

        while (streamOffset != offset) {
            try {
                streamOffset += stream.skip(offset - streamOffset);
            } catch (IOException e) {
                return -2;
            }
        }

        int r;
        try {
            r = stream.read(b, off, len);
            streamOffset += r;
        } catch (IOException e) {
            r = -2;
        }

        return r;
    }

    @Override
    protected void populateAttributes() {
        this.lastModifiedTime = zipEntry.getTime();
        this.length = zipEntry.getSize();
        accessFlags = ACCESS_READ;
    }

    @Override
    public void cleanup() {
        lastReferenceClosed();
    }

}
