/*
 * This file is part of libbluray
 * Copyright (C) 2010  William Hahne
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 */

package jail.org.dvb.media;

public class AspectRatioChangedEvent extends VideoFormatEvent {
    public AspectRatioChangedEvent(Object source, int newRatio) {
        super(source);

        this.newRatio = newRatio;
    }

    public int getNewRatio() {
        return newRatio;
    }

    public String toString() {
        return blues.Jail.rJ(getClass().getName()) + "[source=" + source + ",newRatio=" + newRatio + "]";
    }

    private final int newRatio;
    private static final long serialVersionUID = -897298629574550910L;
}
