/*
# Docsis cable modem diagnostics (cmdiag)
#
# Copyright (C) 2006-2007 Emil Penchev
#
# This program is free software, distributed under the terms of
# the GNU General Public License 2.0
#
*/


#ifndef PBAR_H
#define PBAR_H

#include <string>
#include "bar.h"
#include "globals.h"

using namespace std;


struct color_parts
{
	int n_color;        /* Color to be used */
	int col_pair;       /* Color identifier for the COLOR_PAIR macro */
	int start_pos;      /* Start position for the color bar part */
	int end_pos;        /* End position for the color bar part */
	int lenght;         /* Lenght of the bar */
	int draw_lenght;    /* Lenght to be drawen (visible size) */
};

class PowerBar : public Bar 
{
	private:
		int max_parts;
		color_parts * parts;
		int * bar_parts_lenghts;
		int * bar_parts_colors;
	public:
		PowerBar(int x, int y, string tp, string s_meas, string e_meas, int s_mark, int e_mark, int len, int m_parts, int bartype);
		~PowerBar() { delete parts; }
		void SignalUpdate(int lev, string slev);
		void ErrRateUpdate(int bits);
};

#endif



