/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui;

import com.frostwire.gui.theme.ThemeMediator;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.limewire.util.OSUtils;

public class LocaleLabel
extends JLabel {
    public void setText(LocaleString text) {
        if (OSUtils.isWindows()) {
            Font f = text.canDisplay() ? this.getParent().getFont() : ThemeMediator.DIALOG_FONT;
            this.changeFont(f);
        }
        this.setText(text.getValue());
    }

    private void changeFont(Font f) {
        if (f != null && !f.equals(this.getFont())) {
            this.setFont(f);
        }
    }

    public static class LocaleString {
        private final String value;
        private Boolean canDisplay;

        public LocaleString(String value) {
            this.value = value;
            this.canDisplay = OSUtils.isWindows() ? null : Boolean.TRUE;
        }

        public String getValue() {
            return this.value;
        }

        public boolean canDisplay() {
            if (this.canDisplay == null) {
                this.canDisplay = this.getDefaultFont().canDisplayUpTo(this.value) == -1;
            }
            return this.canDisplay;
        }

        public String toString() {
            return this.value;
        }

        private Font getDefaultFont() {
            return (Font)UIManager.getDefaults().get("defaultFont");
        }
    }
}

