/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.AlphaIcon;
import com.frostwire.gui.bittorrent.LicenseToggleButtonOnToggleListener;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class LicenseToggleButton
extends JPanel {
    private boolean selected;
    private boolean toggleable;
    private final ImageIcon selectedIcon;
    private final AlphaIcon unselectedIcon;
    private final String title;
    private final JLabel iconLabel;
    private final JLabel titleLabel;
    private final JLabel descriptionLabel;
    private LicenseIcon licenseIcon;
    private LicenseToggleButtonOnToggleListener listener;

    public LicenseToggleButton(LicenseIcon iconName, String text, String description, boolean selected, boolean toggleable) {
        this.toggleable = toggleable;
        this.setMeUp();
        this.licenseIcon = iconName;
        this.selectedIcon = LicenseToggleButton.getIcon(iconName);
        this.unselectedIcon = new AlphaIcon(this.selectedIcon, 0.2f);
        this.iconLabel = new JLabel(selected ? this.selectedIcon : this.unselectedIcon);
        this.title = text;
        this.titleLabel = new JLabel("<html><b>" + text + "</b></html>");
        this.descriptionLabel = new JLabel("<html><small>" + description + "</small></html>");
        this.setLayout(new MigLayout("fill, wrap 1"));
        this.add((Component)this.iconLabel, "top, aligny top, alignx center, wrap");
        this.add((Component)this.titleLabel, "top, aligny top, alignx center, wrap");
        this.add((Component)this.descriptionLabel, "top, aligny top, pushy, alignx center");
        this.initEventListeners();
    }

    public String getTitle() {
        return this.title;
    }

    public void setToggleable(boolean t) {
        this.toggleable = t;
    }

    public LicenseIcon getLicenseIcon() {
        return this.licenseIcon;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.updateComponents();
    }

    public void setOnToggleListener(LicenseToggleButtonOnToggleListener listener) {
        this.listener = listener;
    }

    private void onMouseEntered() {
        if (this.toggleable) {
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
            BasicStroke stroke = new BasicStroke(1.0f, 1, 1);
            this.setBorder(BorderFactory.createStrokeBorder(stroke, Color.GRAY));
            this.updateComponents();
        }
    }

    private void onMouseExited() {
        if (this.toggleable) {
            this.setMeUp();
            this.updateComponents();
        }
    }

    private void onToggle() {
        if (this.toggleable) {
            this.selected = !this.selected;
            this.updateComponents();
            if (this.listener != null) {
                this.listener.onButtonToggled(this);
            }
        }
    }

    private void initEventListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LicenseToggleButton.this.onToggle();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LicenseToggleButton.this.onMouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LicenseToggleButton.this.onMouseExited();
            }
        });
    }

    private void updateComponents() {
        if (this.iconLabel != null && this.selectedIcon != null && this.unselectedIcon != null) {
            this.iconLabel.setIcon(this.selected ? this.selectedIcon : this.unselectedIcon);
        }
        if (this.titleLabel != null) {
            this.titleLabel.setEnabled(this.selected);
        }
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setEnabled(this.selected);
        }
    }

    private void setMeUp() {
        this.setBackground(null);
        this.setOpaque(false);
        this.setBorder(null);
    }

    private static ImageIcon getIcon(LicenseIcon iconName) {
        return GUIMediator.getThemeImage(iconName.toString() + ".png");
    }

    public static enum LicenseIcon {
        CC,
        BY,
        SA,
        ND,
        NC,
        APACHE,
        BSD,
        GPL3,
        LGPL3,
        MOZILLA,
        OPENSOURCE,
        CC0,
        PUBLICDOMAIN;

    }
}

