/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.theme.ThemeMediator;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public final class TorrentSaveFolderComponent
extends JPanel {
    private JTextField folderTextField = new JTextField(SharingSettings.TORRENT_DATA_DIR_SETTING.getValueAsString());
    private static String errorMessage;

    public TorrentSaveFolderComponent(boolean border) {
        this.setLayout(new GridBagLayout());
        if (border) {
            this.setBorder(ThemeMediator.createTitledBorder(I18n.tr("Torrent Data Save Folder")));
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.gridwidth = -1;
        gbc.anchor = 21;
        this.add((Component)this.folderTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 22;
        gbc.gridwidth = 0;
        ButtonRow buttonRow = new ButtonRow(new Action[]{new DefaultAction(), new BrowseAction()}, 0, 12);
        boolean isPortable = CommonUtils.isPortable();
        this.folderTextField.setEnabled(!isPortable);
        buttonRow.setButtonsEnabled(!isPortable);
        this.add((Component)buttonRow, gbc);
    }

    public String getTorrentSaveFolderPath() {
        return this.folderTextField.getText();
    }

    public boolean isTorrentSaveFolderPathValid(boolean checkExist) {
        if (this.folderTextField.getText().trim().length() == 0) {
            errorMessage = I18n.tr("You forgot to enter a path for the Torrent Data Folder.");
            return false;
        }
        String path = this.folderTextField.getText().trim();
        File folder = new File(path);
        return TorrentSaveFolderComponent.isTorrentSaveFolderPathValid(checkExist, folder);
    }

    public static boolean isTorrentSaveFolderPathValid(boolean checkExist, File folder) {
        if (!(!checkExist || folder.exists() && folder.isDirectory() && folder.canWrite())) {
            errorMessage = I18n.tr("Please enter a valid path for the Torrent Data Folder");
            return false;
        }
        String lowerCaseFolderPath = folder.getAbsolutePath().toLowerCase();
        return !OSUtils.isWindows() || !lowerCaseFolderPath.contains(System.getenv("ProgramFiles").toLowerCase());
    }

    public static boolean isParentOrChild(File torrentFolder, File otherFolder, String errorMessageSuffix) {
        try {
            if (torrentFolder.getCanonicalPath().startsWith(otherFolder.getCanonicalPath())) {
                errorMessage = I18n.tr("The Torrent Data Folder cannot be inside the") + " " + errorMessageSuffix;
                return true;
            }
        }
        catch (IOException e) {
            errorMessage = I18n.tr("Could not resolve folder path.");
            return true;
        }
        try {
            if (otherFolder.getCanonicalPath().startsWith(torrentFolder.getCanonicalPath())) {
                errorMessage = I18n.tr("The Torrent Data Folder cannot be a parent folder of the") + " " + errorMessageSuffix;
                return true;
            }
        }
        catch (IOException e) {
            errorMessage = I18n.tr("Could not resolve folder path.");
            return true;
        }
        return false;
    }

    public static String getError() {
        return errorMessage;
    }

    private class BrowseAction
    extends AbstractAction {
        private static final long serialVersionUID = 2976380710515726420L;

        public BrowseAction() {
            this.putValue("Name", I18n.tr("Browse..."));
            this.putValue("ShortDescription", I18n.tr("Choose Another Folder"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File saveDir = FileChooserHandler.getInputDirectory(TorrentSaveFolderComponent.this);
            if (saveDir == null || !saveDir.isDirectory()) {
                return;
            }
            TorrentSaveFolderComponent.this.folderTextField.setText(saveDir.getAbsolutePath());
        }
    }

    private class DefaultAction
    extends AbstractAction {
        private static final long serialVersionUID = 7266666461649699221L;

        public DefaultAction() {
            this.putValue("Name", I18n.tr("Use Default"));
            this.putValue("ShortDescription", I18n.tr("Use the Default Folder"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TorrentSaveFolderComponent.this.folderTextField.setText(SharingSettings.DEFAULT_TORRENT_DATA_DIR.getAbsolutePath());
        }
    }
}

