/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.AlphaIcon;
import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.bittorrent.SeedingHolder;
import com.frostwire.transfers.TransferState;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.FWAbstractJPanelTableCellRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;

public final class TransferSeedingRenderer
extends FWAbstractJPanelTableCellRenderer {
    private static final ImageIcon seed_solid = GUIMediator.getThemeImage("transfers_seeding_over");
    private static final AlphaIcon seed_faded = new AlphaIcon(seed_solid, 0.5f);
    private static final ImageIcon loading = GUIMediator.getThemeImage("indeterminate_small_progress");
    private JLabel labelSeed;
    private BTDownload dl;

    public TransferSeedingRenderer() {
        this.setupUI();
    }

    private void setupUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = -1;
        c.ipadx = 3;
        c.insets = new Insets(2, 5, 2, 5);
        this.labelSeed = new JLabel(seed_faded);
        this.labelSeed.setOpaque(false);
        this.labelSeed.setDoubleBuffered(true);
        this.labelSeed.setToolTipText(I18n.tr("SEED this torrent transfer so others can download it. The more seeds, the faster the downloads."));
        this.labelSeed.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    if (TransferSeedingRenderer.this.dl.getState().equals((Object)TransferState.DOWNLOADING)) {
                        return;
                    }
                    BittorrentDownload.RendererHelper.onSeedTransfer(TransferSeedingRenderer.this.dl, false);
                    TransferSeedingRenderer.this.labelSeed.setIcon(loading);
                }
            }
        });
        this.add((Component)this.labelSeed, c);
        this.setEnabled(true);
    }

    @Override
    protected void updateUIData(Object dataHolder, JTable table, int row, int column) {
        this.updateUIData((SeedingHolder)dataHolder, table, row, column);
    }

    private void updateUIData(SeedingHolder actionsHolder, JTable table, int row, int column) {
        if (actionsHolder != null) {
            this.dl = actionsHolder.getDl();
            boolean canShareNow = BittorrentDownload.RendererHelper.canShareNow(this.dl);
            this.updateSeedingButton(canShareNow);
        }
    }

    private void updateSeedingButton(boolean canShareNow) {
        this.labelSeed.setVisible(true);
        if (this.dl instanceof BittorrentDownload) {
            TransferState currentState = this.dl.getState();
            boolean isSeeding = currentState.equals((Object)TransferState.SEEDING) && this.dl.isCompleted();
            boolean isPausing = currentState.equals((Object)TransferState.PAUSING);
            if (!canShareNow) {
                this.labelSeed.setIcon(seed_faded);
            } else {
                this.labelSeed.setIcon(isPausing ? loading : (isSeeding ? seed_solid : seed_faded));
            }
        } else {
            this.labelSeed.setIcon(seed_faded);
        }
    }
}

