/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.slides;

import com.frostwire.gui.components.slides.SlideshowPanel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class SlideshowPanelControls
extends JPanel
implements SlideshowPanel.SlideshowListener {
    private final SlideshowPanel _thePanel;
    private ButtonGroup _buttonGroup;
    private List<JRadioButton> _buttons;
    private ItemListener _selectionAdapter;

    public SlideshowPanelControls(SlideshowPanel panel) {
        this._thePanel = panel;
        this._thePanel.setListener(this);
        this.buildButtons();
        this.autoSelectCurrentSlideButton();
        this.buildItemListener();
        this.attachListeners();
    }

    public void autoSelectCurrentSlideButton() {
        int currentSlideIndex = this._thePanel.getCurrentSlideIndex();
        if (currentSlideIndex != -1) {
            this._buttons.get(currentSlideIndex).setSelected(true);
        } else {
            this._buttons.get(0).setSelected(true);
        }
    }

    private void buildItemListener() {
        this._selectionAdapter = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (((JRadioButton)e.getItemSelectable()).isSelected()) {
                    SlideshowPanelControls.this.onRadioButtonClicked(e);
                }
            }
        };
    }

    protected void onRadioButtonClicked(ItemEvent e) {
        int selectedIndex = this._buttons.indexOf(e.getSource());
        this._thePanel.switchToSlide(selectedIndex);
    }

    private void buildButtons() {
        int numSlides = this._thePanel.getNumSlides();
        this._buttonGroup = new ButtonGroup();
        this._buttons = new ArrayList<JRadioButton>(numSlides);
        for (int i = 0; i < numSlides; ++i) {
            JRadioButton radio = new JRadioButton();
            this._buttons.add(radio);
            this._buttonGroup.add(radio);
            this.add(radio);
        }
    }

    private void attachListeners() {
        for (int i = 0; i < this._buttons.size(); ++i) {
            this._buttons.get(i).addItemListener(this._selectionAdapter);
        }
    }

    @Override
    public void onSlideChanged() {
        ItemListener[] itemListeners;
        int currentSlideIndex = this._thePanel.getCurrentSlideIndex();
        JRadioButton button = this._buttons.get(currentSlideIndex);
        for (ItemListener listener : itemListeners = button.getItemListeners()) {
            button.removeItemListener(listener);
        }
        button.setSelected(true);
        for (ItemListener listener : itemListeners) {
            button.addItemListener(listener);
        }
    }
}

